/**
 ** ADDMODE.C ---- code fragments to manipulate the mode tables
 **
 ** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
 ** Copyright (C) 1992 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** Copyright (C) 1993 Grzegorz Mazur, gbm@ii.pw.edu.pl
 **
 ** This file is distributed under the terms listed in the document
 ** "copying.dj", available from DJ Delorie at the address above.
 ** A copy of "copying.dj" should accompany this file; if not, a copy
 ** should be available from where this file was obtained.  This file
 ** may not be distributed without a verbatim copy of "copying.dj".
 **
 ** This file is distributed WITHOUT ANY WARRANTY; without even the implied
 ** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **/

struct mode_table_desc {
    GrModeEntry *table;
    int cur_size;
    int max_size;
};

struct mode_table_desc text_table_desc = {
    text_mode_table,
    (-1),
    sizeof(text_mode_table) / sizeof(GrModeEntry)
};

struct mode_table_desc graphics_table_desc = {
    graphics_mode_table,
    (-1),
    sizeof(graphics_mode_table) / sizeof(GrModeEntry)
};

void tblcopy(GrModeEntry *to,GrModeEntry *from,int count)
{
	_DI = FP_OFF(to);
	_SI = FP_OFF(from);
	_CX = count * (sizeof(GrModeEntry) / sizeof(short));
	_ES = _DS;
	asm cld;
	if(_DI > _SI) {
	    _AX = _CX + _CX - sizeof(short);
	    asm add di,ax;
	    asm add si,ax;
	    asm std;
	}
	asm rep movsw;
	asm cld;
}

void insert_mode_entry(struct mode_table_desc *dsc,int w,int h,unsigned int colors,int BIOSno,int setup)
{
	GrModeEntry *mdp = dsc->table;
	int copy,pos;

	if(dsc->cur_size < 0) {
	    for(pos = 1; mdp->width > 0; mdp++) pos++;
	    dsc->cur_size = pos;
	    mdp = dsc->table;
	}
	if(dsc->cur_size < dsc->max_size) {
	    for(pos = 0; mdp->width > 0; pos++,mdp++) {
		if(mdp->number_of_colors > colors) break;
		if(mdp->number_of_colors < colors) continue;
		if((mdp->width == w) && (mdp->height == h)) {
		    /* mode already exists */
		    /* give priority to modes with standard setup */
		    if((setup == 0) || (mdp->mode.vdr.BIOS_mode == UNSUP)) {
			mdp->mode.vdr.BIOS_mode = BIOSno;
			mdp->mode.vdr.custom_setup_index = setup;
		    }
		    return;
		}
		if((mdp->width >= w) && (mdp->height >= h)) break;
	    }
	    copy = dsc->cur_size - pos;
	    if(copy > 0) tblcopy((mdp + 1),mdp,copy);
	    mdp->width  = w;
	    mdp->height = h;
	    mdp->number_of_colors = colors;
	    mdp->mode.vdr.BIOS_mode = BIOSno;
	    mdp->mode.vdr.custom_setup_index = setup;
	    dsc->cur_size++;
	}
}

#define add_text_mode(W,H,PL,BNO,SUP)	    insert_mode_entry(&text_table_desc,W,H,PL,BNO,SUP)
#define add_graphics_mode(W,H,PL,BNO,SUP)   insert_mode_entry(&graphics_table_desc,W,H,PL,BNO,SUP)

