#include "fntool.h"
#include "../include/grx.h"
#include "../include/grxfile.h"

static long bitmapsize(void)
{
	chr  *cp;
	long total = 0;

	for(cp = fnt.chars; cp != NULL; cp = cp->next)
	    total += (cp->width + 7) >> 3;
	return(total * fnt.height);
}

static void writeheader(void)
{
	FntFileHdr fhdr;

	memset(&fhdr,0,sizeof(fhdr));
	fhdr.magic = FONT_MAGIC;
	fhdr.bitmapsize = bitmapsize();
	fhdr.h.fnt_isfixed  = fnt.isfixed;
	fhdr.h.fnt_width    = fnt.avgwidth;
	fhdr.h.fnt_height   = fnt.height;
	fhdr.h.fnt_minchar  = fnt.minchar;
	fhdr.h.fnt_maxchar  = fnt.maxchar;
	fhdr.h.fnt_internal = 0;
	fhdr.h.fnt_baseline = fnt.baseline;
	fhdr.h.fnt_undwidth = fnt.undwidth;
	strcpy(fhdr.h.fnt_name,fnt.name);
	strncpy(fhdr.h.fnt_family,fnt.family,15);
	fhdr.h.fnt_family[15] = '\0';
	if((fnt.weight[0] != '\0') || (fnt.slant[0] != '\0'))
	    fhdr.h.fnt_family[15-5] = '\0';
	if((fnt.weight[0] != '\0') && (fnt.slant[0] != '\0'))
	    fhdr.h.fnt_family[15-10] = '\0';
	if(fnt.weight[0] != '\0') {
	    strcat(fhdr.h.fnt_family,"_");
	    strcat(fhdr.h.fnt_family,fnt.weight);
	}
	if(fnt.slant[0] != '\0') {
	    strcat(fhdr.h.fnt_family,"_");
	    strcat(fhdr.h.fnt_family,fnt.slant);
	}
	fwrite(&fhdr,sizeof(fhdr),1,outfile);
}

static void writewidthtable(void)
{
	short wdt[1];
	chr   *cp;

	for(cp = fnt.chars; cp != NULL; cp = cp->next) {
	    wdt[0] = (short)cp->width;
	    fwrite(wdt,sizeof(short),1,outfile);
	}
}

static void writebitmap(void)
{
	int xx,yy,wdt;
	int bits,mask;
	chr *cp;

	for(cp = fnt.chars; cp != NULL; cp = cp->next) {
	    wdt = cp->width;
	    for(yy = 0; yy < fnt.height; yy++) {
		bits = 0;
		mask = 0x100;
		for(xx = 0; xx < wdt; xx++) {
		    if((mask >>= 1) == 0) {
			putc(bits,outfile);
			bits = 0;
			mask = 0x80;
		    }
		    if(cp->bmp[yy][xx] != 0) bits |= mask;
		}
		putc(bits,outfile);
	    }
	}
}

void writefnt(void)
{
	writeheader();
	if(!fnt.isfixed) writewidthtable();
	writebitmap();
	fputs(notes,outfile);
}

