#include "fntool.h"

void writefna(void)
{
	int  xx,yy;
	char *p;
	chr  *cp;

	fprintf(outfile,"name %s\n",fnt.name);
	fprintf(outfile,"family %s",fnt.family);
	if(fnt.weight[0] != '\0') fprintf(outfile,"_%s",fnt.weight);
	if(fnt.slant[0]  != '\0') fprintf(outfile,"_%s",fnt.slant);
	fprintf(outfile,"\nminchar %d\n",fnt.minchar);
	fprintf(outfile,"maxchar %d\n",fnt.maxchar);
	fprintf(outfile,"isfixed %d\n",fnt.isfixed);
	if(fnt.isfixed)
	    fprintf(outfile,"width %d\n",fnt.avgwidth);
	else {
	    fprintf(outfile,"avgwidth %d\n",fnt.avgwidth);
	    fprintf(outfile,"minwidth %d\n",fnt.minwidth);
	    fprintf(outfile,"maxwidth %d\n",fnt.maxwidth);
	}
	fprintf(outfile,"height %d\n",fnt.height);
	fprintf(outfile,"undwidth %d\n",fnt.undwidth);
	fprintf(outfile,"baseline %d\n\n",fnt.baseline);
	for(p = notes,xx = 0; *p != '\0'; p++) {
	    if(xx == 0) fputs("note ",outfile);
	    putc(*p,outfile);
	    xx++;
	    if(*p == '\n') xx = 0;
	}
	for(cp = fnt.chars; cp != NULL; cp = cp->next) {
	    fprintf(outfile,"\n; character %d ",cp->code);
	    if(isprint(cp->code)) fprintf(outfile,"(%c) ",cp->code);
	    fprintf(outfile,"width = %d\n",cp->width);
	    for(yy = 0; yy < fnt.height; yy++) {
		for(xx = 0; xx < cp->width; xx++)
		    putc((cp->bmp[yy][xx] ? '#' : '.'),outfile);
		putc('\n',outfile);
	    }
	}
}

