/**********************************************************************
 *  
 *  NAME:           window.cpp
 *  
 *  DESCRIPTION:    methods for Window class
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  11/30/90    J. Alan Eldridge    created
 *  
 *********************************************************************/

#include    "w.h"

Window::Window(
    int yul,    int xul,
    int ylr,    int xlr,
    uchar   *name):
        basewin(yul,xul,ylr,xlr)
{
    setattr(0);
    setname(name);
}

void
Window::setname(uchar *s)
{
    memset(name, 0, sizeof(name));
    if (s)
        strncpy(name, s, sizeof(name)-1);
}

int
Window::savescreen()
{
    if (save.status() != OK)
        save.open(yOrg, xOrg, yOrg+rows-1, xOrg+cols-1);
    if (save.status() == OK) {
        save.cpscreen();
        return OK;
    }
    return ERR;
}

void
Window::restorescreen(int closeit)
{
    if (save.status() == OK) {
        save.refresh();
        if (closeit)
            save.close();
    }
}
