/*---------------------------------------------------------------------------+
 |  segment.h                                                                |
 |                                                                           |
 |    Replacement for the Linux segment.h header file.                       |
 |                                                                           |
 | Copyright (C) 1994    W. Metzenthen, 22 Parker St, Ormond, Vic 3163,      |
 |                       Australia.  E-mail apm233m@vaxc.cc.monash.edu.au    |
 |                                                                           |
 +---------------------------------------------------------------------------*/

#ifndef _FPU_EMU_ASM_SEGMENT_H
#define _FPU_EMU_ASM_SEGMENT_H

/*
  All references to memory in the DJGPP emulator
  are in the current memory space and require no
  special treatment.
  */

#define get_fs_byte(x) (*((char *)(x)))
#define get_fs_word(x) (*((short *)(x)))
#define get_fs_long(x) (*((long *)(x)))

#define put_fs_byte(v,a) {*((char *)(a)) = (v);}
#define put_fs_word(v,a) {*((short *)(a)) = (v);}
#define put_fs_long(v,a) {*((long *)(a)) = (v);}

#endif
