*** orig/make-3.71/job.c	Thu Jul 21 01:30:04 1994
--- src/make-3.71/job.c	Wed Jul 27 16:21:42 1994
***************
*** 28,33 ****
--- 28,45 ----
  /* Default shell to use.  */
  char default_shell[] = "/bin/sh";
  
+ #ifdef __MSDOS__
+ #include <process.h>
+ static int dos_pid = 123;
+ static int dos_status = 0;
+ static char *bname = 0;
+ static char *bename = 0;
+ static int is_batch_file = 0;
+ #define PATH_SEPARATOR_CHAR ';'
+ #else /* MSDOS */
+ #define PATH_SEPARATOR_CHAR ':'
+ #endif /* ?MSDOS */
+ 
  /* If NGROUPS_MAX == 0 then try other methods for finding a real value.  */
  #if defined (NGROUPS_MAX) && NGROUPS_MAX == 0
  #undef NGROUPS_MAX
***************
*** 260,265 ****
--- 272,278 ----
  	}
        else if (pid == 0)
  	{
+ #ifndef __MSDOS__
  	  /* No remote children.  Check for local children.  */
  
  	  if (any_local)
***************
*** 308,313 ****
--- 321,333 ----
  	      exit_sig = WIFSIGNALED (status) ? WTERMSIG (status) : 0;
  	      coredump = WCOREDUMP (status);
  	    }
+ #else /* MSDOS */
+ 	  pid = dos_pid-1;
+ 	  status = dos_status;
+ 	  exit_code = dos_status;
+ 	  exit_sig = 0;
+ 	  coredump = 0;
+ #endif /* ?MSDOS */
  	}
        else
  	/* We got a remote child.  */
***************
*** 474,479 ****
--- 494,502 ----
    free ((char *) child);
  }
  
+ #ifdef __MSDOS__
+ void unblock_sigs(){}
+ #else /* MSDOS */
  #ifdef	POSIX
  extern sigset_t fatal_signal_set;
  
***************
*** 485,490 ****
--- 508,514 ----
    sigprocmask (SIG_SETMASK, &empty, (sigset_t *) 0);
  }
  #endif
+ #endif /* ?MSDOS */
  
  /* Start a job to run the commands specified in CHILD.
     CHILD is updated to reflect the commands and ID of the child process.  */
***************
*** 618,623 ****
--- 642,649 ----
    if (child->environment == 0)
      child->environment = target_environment (child->file);
  
+ #ifndef __MSDOS__
+ 
    /* start_waiting_job has set CHILD->remote if we can start a remote job.  */
    if (child->remote)
      {
***************
*** 666,672 ****
  	  goto error;
  	}
      }
! 
    /* We are the parent side.  Set the state to
       say the commands are running and return.  */
  
--- 692,712 ----
  	  goto error;
  	}
      }
! #else
!   dos_status = spawnvpe(P_WAIT, argv[0], argv, child->environment);
!   dead_children++;
!   child->pid = dos_pid++;
!   if (is_batch_file)
!   {
!     is_batch_file = 0;
!     remove(bname); /* ignore errors */
!     if (access(bename,0))
!       dos_status = 1;
!     else
!       dos_status = 0;
!     remove(bename);
!   }
! #endif
    /* We are the parent side.  Set the state to
       say the commands are running and return.  */
  
***************
*** 924,929 ****
--- 964,972 ----
  static int
  load_too_high ()
  {
+ #ifdef __MSDOS__
+   return 1;
+ #else
    extern int getloadavg ();
    double load;
  
***************
*** 949,954 ****
--- 992,998 ----
    user_access ();
  
    return load >= max_load_average;
+ #endif /* ?__MSDOS__ */
  }
  
  /* Start jobs that are waiting for the load to be lower.  */
***************
*** 1012,1018 ****
--- 1056,1066 ----
    if (path == 0 || path[0] == '\0')
      path = default_path;
  
+ #ifdef __MSDOS__
+   if (strpbrk (file, "/\\:") != 0)
+ #else
    if (index (file, '/') != 0)
+ #endif
      {
        strcpy (program, file);
        return 1;
***************
*** 1049,1055 ****
  	  int perm;
  	  char *p;
  
! 	  p = index (path, ':');
  	  if (p == 0)
  	    p = path + strlen (path);
  
--- 1097,1103 ----
  	  int perm;
  	  char *p;
  
! 	  p = index (path, PATH_SEPARATOR_CHAR);
  	  if (p == 0)
  	    p = path + strlen (path);
  
***************
*** 1189,1200 ****
--- 1237,1258 ----
       char *line, **restp;
       char *shell, *ifs;
  {
+ #ifdef __MSDOS__
+   static char sh_chars[] = "|<>";
+   static char *sh_cmds[] = {
+ 	"break", "call", "cd", "chcp", "chdir", "cls", "copy", "ctty",
+ 	"date", "del", "dir", "echo", "erase", "exit", "for"
+ 	"goto", "if", "if", "md", "mkdir", "path", "pause", "prompt",
+ 	"rem", "ren", "rename", "set", "shift", "time", "type"
+ 	"ver", "verify", "vol", ":", 0};
+ #else
    static char sh_chars[] = "#;\"*?[]&|<>(){}$`^";
    static char *sh_cmds[] = { "cd", "eval", "exec", "exit", "login",
  			     "logout", "set", "umask", "wait", "while", "for",
  			     "case", "if", ":", ".", "break", "continue",
  			     "export", "read", "readonly", "shift", "times",
  			     "trap", "switch", 0 };
+ #endif
    register int i;
    register char *p;
    register char *ap;
***************
*** 1400,1406 ****
        free (new_argv[0]);
        free (new_argv);
      }
! 
    {
      /* SHELL may be a multi-word command.  Construct a command line
         "SHELL -c LINE", with all special chars in LINE escaped.
--- 1458,1525 ----
        free (new_argv[0]);
        free (new_argv);
      }
! #ifdef __MSDOS__
!   {
!     FILE *batch;
!     char *linep;
!     int pstate=1;
!     is_batch_file = 1;
!     if (!bname)
!     {
!       bname = tempnam(".", "mk");
!       for (i=0; bname[i]; i++)
!         if (bname[i] == '/')
!           bname[i] = '\\';
!       bename = (char *)malloc(strlen(bname)+5);
!       strcpy(bename, bname);
!       strcat(bname, ".bat");
!       strcat(bename, ".err");
!     }
!     batch=fopen(bename, "w"); /* create a file */
!     if (batch) fclose(batch);
!     batch = fopen(bname, "w");
!     fputs("@echo off\n", batch);
!     linep = line;
!     while (1)
!     {
!       if (*linep == 0)
! 	break;
!       switch (pstate)
!       {
!       case 1: /* eat whitespace at bol or after special char */
! 	if (*linep && *linep <= ' ')
! 	  linep++;
! 	else
! 	  pstate = 2;
! 	break;
!       case 2: /* dosify */
! 	if (strchr("><|", *linep))
! 	  pstate = 3;
! 	else if (*linep > ' ')
! 	{
! 	  if (*linep == '/')
! 	    fputc('\\', batch);
! 	  else
! 	    fputc(*linep, batch);
! 	  linep++;
! 	}
! 	else
! 	  pstate = 3;
! 	break;
!       case 3: /* pass */
! 	if (strchr("><|", *linep))
! 	  pstate = 1;
! 	fputc(*linep++, batch);
! 	break;
!       }
!     }
!     fprintf(batch, "\nif errorlevel 1 del %s\n", bename);
!     fclose(batch);
!     new_argv = (char **)xmalloc(2 * sizeof(char *));
!     new_argv[0] = strdup(bname);
!     new_argv[1] = 0;
!   }
! #else /* __MSDOS__ */
    {
      /* SHELL may be a multi-word command.  Construct a command line
         "SHELL -c LINE", with all special chars in LINE escaped.
***************
*** 1458,1464 ****
      new_argv = construct_command_argv_internal (new_line, (char **) NULL,
  						(char *) 0, (char *) 0);
    }
! 
    return new_argv;
  }
  
--- 1577,1583 ----
      new_argv = construct_command_argv_internal (new_line, (char **) NULL,
  						(char *) 0, (char *) 0);
    }
! #endif /* ?__MSDOS__ */
    return new_argv;
  }
  
