This is Info file ./gdb.info, produced by Makeinfo-1.52 from the input
file gdb.texinfo.

START-INFO-DIR-ENTRY
* Gdb::                         The GNU debugger.
END-INFO-DIR-ENTRY
   This file documents the GNU debugger GDB.

   This is Edition 4.12, January 1994, of `Debugging with GDB: the GNU
Source-Level Debugger' for GDB Version 4.12.

   Copyright (C) 1988, '89, '90, '91, '92, '93 Free Software
Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the entire resulting derived work is distributed under the terms
of a permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions.


File: gdb.info,  Node: Thread Stops,  Prev: Signals,  Up: Stopping

Stopping and starting multi-thread programs
===========================================

   When your program has multiple threads (*note Debugging programs
with multiple threads: Threads.), you can choose whether to set
breakpoints on all threads, or on a particular thread.

`break LINESPEC thread THREADNO'
`break LINESPEC thread THREADNO if ...'
     Use the qualifier `thread THREADNO' with a breakpoint command to
     specify that you only want GDB to stop the program when a
     particular thread reaches this breakpoint.  THREADNO is one of the
     numeric thread identifiers assigned by GDB, shown in the first
     column of the `info threads' display.

     If you do not specify `thread THREADNO' when you set a breakpoint,
     the breakpoint applies to *all* threads of your program.

     You can use the `thread' qualifier on conditional breakpoints as
     well; in this case, place `thread THREADNO' before the breakpoint
     condition, like this:

          (gdb) break frik.c:13 thread 28 if bartab > lim

   Whenever your program stops under GDB for any reason, *all* threads
of execution stop, not just the current thread.  This allows you to
examine the overall state of the program, including switching between
threads, without worrying that things may change underfoot.

   Conversely, whenever you restart the program, *all* threads start
executing.  *This is true even when single-stepping* with commands like
`step' or `next'.

   In particular, GDB cannot single-step all threads in lockstep.
Since thread scheduling is up to your debugging target's operating
system (not controlled by GDB), other threads may execute more than one
statement while the current thread completes a single step.  Moreover,
in general other threads stop in the middle of a statement, rather than
at a clean statement boundary, when the program stops.

   You might even find your program stopped in another thread after
continuing or even single-stepping.  This happens whenever some other
thread runs into a breakpoint, a signal, or an exception before the
first thread completes whatever you requested.


File: gdb.info,  Node: Stack,  Next: Source,  Prev: Stopping,  Up: Top

Examining the Stack
*******************

   When your program has stopped, the first thing you need to know is
where it stopped and how it got there.

   Each time your program performs a function call, the information
about where in your program the call was made from is saved in a block
of data called a "stack frame".  The frame also contains the arguments
of the call and the local variables of the function that was called.
All the stack frames are allocated in a region of memory called the
"call stack".

   When your program stops, the GDB commands for examining the stack
allow you to see all of this information.

   One of the stack frames is "selected" by GDB and many GDB commands
refer implicitly to the selected frame.  In particular, whenever you
ask GDB for the value of a variable in your program, the value is found
in the selected frame.  There are special GDB commands to select
whichever frame you are interested in.

   When your program stops, GDB automatically selects the currently
executing frame and describes it briefly as the `frame' command does
(*note Information about a frame: Frame Info.).

* Menu:

* Frames::                      Stack frames
* Backtrace::                   Backtraces
* Selection::                   Selecting a frame
* Frame Info::                  Information on a frame

* MIPS Stack::                  MIPS machines and the function stack


File: gdb.info,  Node: Frames,  Next: Backtrace,  Up: Stack

Stack frames
============

   The call stack is divided up into contiguous pieces called "stack
frames", or "frames" for short; each frame is the data associated with
one call to one function.  The frame contains the arguments given to
the function, the function's local variables, and the address at which
the function is executing.

   When your program is started, the stack has only one frame, that of
the function `main'.  This is called the "initial" frame or the
"outermost" frame.  Each time a function is called, a new frame is
made.  Each time a function returns, the frame for that function
invocation is eliminated.  If a function is recursive, there can be
many frames for the same function.  The frame for the function in which
execution is actually occurring is called the "innermost" frame.  This
is the most recently created of all the stack frames that still exist.

   Inside your program, stack frames are identified by their addresses.
A stack frame consists of many bytes, each of which has its own
address; each kind of computer has a convention for choosing one of
those bytes whose address serves as the address of the frame.  Usually
this address is kept in a register called the "frame pointer register"
while execution is going on in that frame.

   GDB assigns numbers to all existing stack frames, starting with zero
for the innermost frame, one for the frame that called it, and so on
upward.  These numbers do not really exist in your program; they are
assigned by GDB to give you a way of designating stack frames in GDB
commands.

   Some compilers provide a way to compile functions so that they
operate without stack frames.  (For example, the `gcc' option
`-fomit-frame-pointer' generates functions without a frame.) This is
occasionally done with heavily used library functions to save the frame
setup time.  GDB has limited facilities for dealing with these function
invocations.  If the innermost function invocation has no stack frame,
GDB nevertheless regards it as though it had a separate frame, which is
numbered zero as usual, allowing correct tracing of the function call
chain.  However, GDB has no provision for frameless functions elsewhere
in the stack.


File: gdb.info,  Node: Backtrace,  Next: Selection,  Prev: Frames,  Up: Stack

Backtraces
==========

   A backtrace is a summary of how your program got where it is.  It
shows one line per frame, for many frames, starting with the currently
executing frame (frame zero), followed by its caller (frame one), and
on up the stack.

`backtrace'
`bt'
     Print a backtrace of the entire stack: one line per frame for all
     frames in the stack.

     You can stop the backtrace at any time by typing the system
     interrupt character, normally `C-c'.

`backtrace N'
`bt N'
     Similar, but print only the innermost N frames.

`backtrace -N'
`bt -N'
     Similar, but print only the outermost N frames.

   The names `where' and `info stack' (abbreviated `info s') are
additional aliases for `backtrace'.

   Each line in the backtrace shows the frame number and the function
name.  The program counter value is also shown--unless you use `set
print address off'.  The backtrace also shows the source file name and
line number, as well as the arguments to the function.  The program
counter value is omitted if it is at the beginning of the code for that
line number.

   Here is an example of a backtrace.  It was made with the command `bt
3', so it shows the innermost three frames.

     #0  m4_traceon (obs=0x24eb0, argc=1, argv=0x2b8c8)
         at builtin.c:993
     #1  0x6e38 in expand_macro (sym=0x2b600) at macro.c:242
     #2  0x6840 in expand_token (obs=0x0, t=177664, td=0xf7fffb08)
         at macro.c:71
     (More stack frames follow...)

The display for frame zero does not begin with a program counter value,
indicating that your program has stopped at the beginning of the code
for line `993' of `builtin.c'.


File: gdb.info,  Node: Selection,  Next: Frame Info,  Prev: Backtrace,  Up: Stack

Selecting a frame
=================

   Most commands for examining the stack and other data in your program
work on whichever stack frame is selected at the moment.  Here are the
commands for selecting a stack frame; all of them finish by printing a
brief description of the stack frame just selected.

`frame N'
`f N'
     Select frame number N.  Recall that frame zero is the innermost
     (currently executing) frame, frame one is the frame that called the
     innermost one, and so on.  The highest-numbered frame is the one
     for `main'.

`frame ADDR'
`f ADDR'
     Select the frame at address ADDR.  This is useful mainly if the
     chaining of stack frames has been damaged by a bug, making it
     impossible for GDB to assign numbers properly to all frames.  In
     addition, this can be useful when your program has multiple stacks
     and switches between them.

     On the SPARC architecture, `frame' needs two addresses to select
     an arbitrary frame: a frame pointer and a stack pointer.

`up N'
     Move N frames up the stack.  For positive numbers N, this advances
     toward the outermost frame, to higher frame numbers, to frames
     that have existed longer.  N defaults to one.

`down N'
     Move N frames down the stack.  For positive numbers N, this
     advances toward the innermost frame, to lower frame numbers, to
     frames that were created more recently.  N defaults to one.  You
     may abbreviate `down' as `do'.

   All of these commands end by printing two lines of output describing
the frame.  The first line shows the frame number, the function name,
the arguments, and the source file and line number of execution in that
frame.  The second line shows the text of that source line.

   For example:

     (gdb) up
     #1  0x22f0 in main (argc=1, argv=0xf7fffbf4, env=0xf7fffbfc)
         at env.c:10
     10              read_input_file (argv[i]);

   After such a printout, the `list' command with no arguments prints
ten lines centered on the point of execution in the frame.  *Note
Printing source lines: List.

`up-silently N'
`down-silently N'
     These two commands are variants of `up' and `down', respectively;
     they differ in that they do their work silently, without causing
     display of the new frame.  They are intended primarily for use in
     GDB command scripts, where the output might be unnecessary and
     distracting.


File: gdb.info,  Node: Frame Info,  Next: MIPS Stack,  Prev: Selection,  Up: Stack

Information about a frame
=========================

   There are several other commands to print information about the
selected stack frame.

`frame'
`f'
     When used without any argument, this command does not change which
     frame is selected, but prints a brief description of the currently
     selected stack frame.  It can be abbreviated `f'.  With an
     argument, this command is used to select a stack frame.  *Note
     Selecting a frame: Selection.

`info frame'
`info f'
     This command prints a verbose description of the selected stack
     frame, including the address of the frame, the addresses of the
     next frame down (called by this frame) and the next frame up
     (caller of this frame), the language that the source code
     corresponding to this frame was written in, the address of the
     frame's arguments, the program counter saved in it (the address of
     execution in the caller frame), and which registers were saved in
     the frame.  The verbose description is useful when something has
     gone wrong that has made the stack format fail to fit the usual
     conventions.

`info frame ADDR'
`info f ADDR'
     Print a verbose description of the frame at address ADDR, without
     selecting that frame.  The selected frame remains unchanged by
     this command.

`info args'
     Print the arguments of the selected frame, each on a separate line.

`info locals'
     Print the local variables of the selected frame, each on a separate
     line.  These are all variables (declared either static or
     automatic) accessible at the point of execution of the selected
     frame.

`info catch'
     Print a list of all the exception handlers that are active in the
     current stack frame at the current point of execution.  To see
     other exception handlers, visit the associated frame (using the
     `up', `down', or `frame' commands); then type `info catch'.  *Note
     Breakpoints and exceptions: Exception Handling.


File: gdb.info,  Node: MIPS Stack,  Prev: Frame Info,  Up: Stack

MIPS machines and the function stack
====================================

   MIPS based computers use an unusual stack frame, which sometimes
requires GDB to search backward in the object code to find the
beginning of a function.

   To improve response time (especially for embedded applications, where
GDB may be restricted to a slow serial line for this search) you may
want to limit the size of this search, using one of these commands:

`set heuristic-fence-post LIMIT'
     Restrict GDB to examining at most LIMIT bytes in its search for
     the beginning of a function.  A value of `0' (the default) means
     there is no limit.

`show heuristic-fence-post'
     Display the current limit.

These commands are available *only* when GDB is configured for
debugging programs on MIPS processors.


File: gdb.info,  Node: Source,  Next: Data,  Prev: Stack,  Up: Top

Examining Source Files
**********************

   GDB can print parts of your program's source, since the debugging
information recorded in the program tells GDB what source files were
used to build it.  When your program stops, GDB spontaneously prints
the line where it stopped.  Likewise, when you select a stack frame
(*note Selecting a frame: Selection.), GDB prints the line where
execution in that frame has stopped.  You can print other portions of
source files by explicit command.

   If you use GDB through its GNU Emacs interface, you may prefer to use
Emacs facilities to view source; *note Using GDB under GNU Emacs:
Emacs..

* Menu:

* List::                        Printing source lines

* Search::                      Searching source files

* Source Path::                 Specifying source directories
* Machine Code::                Source and machine code


File: gdb.info,  Node: List,  Next: Search,  Up: Source

Printing source lines
=====================

   To print lines from a source file, use the `list' command
(abbreviated `l').  There are several ways to specify what part of the
file you want to print.

   Here are the forms of the `list' command most commonly used:

`list LINENUM'
     Print lines centered around line number LINENUM in the current
     source file.

`list FUNCTION'
     Print lines centered around the beginning of function FUNCTION.

`list'
     Print more lines.  If the last lines printed were printed with a
     `list' command, this prints lines following the last lines
     printed; however, if the last line printed was a solitary line
     printed as part of displaying a stack frame (*note Examining the
     Stack: Stack.), this prints lines centered around that line.

`list -'
     Print lines just before the lines last printed.

   By default, GDB prints ten source lines with any of these forms of
the `list' command.  You can change this using `set listsize':

`set listsize COUNT'
     Make the `list' command display COUNT source lines (unless the
     `list' argument explicitly specifies some other number).

`show listsize'
     Display the number of lines that `list' prints.

   Repeating a `list' command with RET discards the argument, so it is
equivalent to typing just `list'.  This is more useful than listing the
same lines again.  An exception is made for an argument of `-'; that
argument is preserved in repetition so that each repetition moves up in
the source file.

   In general, the `list' command expects you to supply zero, one or two
"linespecs".  Linespecs specify source lines; there are several ways of
writing them but the effect is always to specify some source line.
Here is a complete description of the possible arguments for `list':

`list LINESPEC'
     Print lines centered around the line specified by LINESPEC.

`list FIRST,LAST'
     Print lines from FIRST to LAST.  Both arguments are linespecs.

`list ,LAST'
     Print lines ending with LAST.

`list FIRST,'
     Print lines starting with FIRST.

`list +'
     Print lines just after the lines last printed.

`list -'
     Print lines just before the lines last printed.

`list'
     As described in the preceding table.

   Here are the ways of specifying a single source line--all the kinds
of linespec.

`NUMBER'
     Specifies line NUMBER of the current source file.  When a `list'
     command has two linespecs, this refers to the same source file as
     the first linespec.

`+OFFSET'
     Specifies the line OFFSET lines after the last line printed.  When
     used as the second linespec in a `list' command that has two, this
     specifies the line OFFSET lines down from the first linespec.

`-OFFSET'
     Specifies the line OFFSET lines before the last line printed.

`FILENAME:NUMBER'
     Specifies line NUMBER in the source file FILENAME.

`FUNCTION'
     Specifies the line of the open-brace that begins the body of the
     function FUNCTION.

`FILENAME:FUNCTION'
     Specifies the line of the open-brace that begins the body of the
     function FUNCTION in the file FILENAME.  You only need the file
     name with a function name to avoid ambiguity when there are
     identically named functions in different source files.

`*ADDRESS'
     Specifies the line containing the program address ADDRESS.
     ADDRESS may be any expression.


File: gdb.info,  Node: Search,  Next: Source Path,  Prev: List,  Up: Source

Searching source files
======================

   There are two commands for searching through the current source file
for a regular expression.

`forward-search REGEXP'
`search REGEXP'
     The command `forward-search REGEXP' checks each line, starting
     with the one following the last line listed, for a match for
     REGEXP.  It lists the line that is found.  You can use synonym
     `search REGEXP' or abbreviate the command name as `fo'.

`reverse-search REGEXP'
     The command `reverse-search REGEXP' checks each line, starting
     with the one before the last line listed and going backward, for a
     match for REGEXP.  It lists the line that is found.  You can
     abbreviate this command as `rev'.


File: gdb.info,  Node: Source Path,  Next: Machine Code,  Prev: Search,  Up: Source

Specifying source directories
=============================

   Executable programs sometimes do not record the directories of the
source files from which they were compiled, just the names.  Even when
they do, the directories could be moved between the compilation and
your debugging session.  GDB has a list of directories to search for
source files; this is called the "source path".  Each time GDB wants a
source file, it tries all the directories in the list, in the order
they are present in the list, until it finds a file with the desired
name.  Note that the executable search path is *not* used for this
purpose.  Neither is the current working directory, unless it happens
to be in the source path.

   If GDB cannot find a source file in the source path, and the object
program records a directory, GDB tries that directory too.  If the
source path is empty, and there is no record of the compilation
directory, GDB looks in the current directory as a last resort.

   Whenever you reset or rearrange the source path, GDB clears out any
information it has cached about where source files are found and where
each line is in the file.

   When you start GDB, its source path is empty.  To add other
directories, use the `directory' command.

`directory DIRNAME ...'
     Add directory DIRNAME to the front of the source path.  Several
     directory names may be given to this command, separated by `:' or
     whitespace.  You may specify a directory that is already in the
     source path; this moves it forward, so GDB searches it sooner.

     You can use the string `$cdir' to refer to the compilation
     directory (if one is recorded), and `$cwd' to refer to the current
     working directory.  `$cwd' is not the same as `.'--the former
     tracks the current working directory as it changes during your GDB
     session, while the latter is immediately expanded to the current
     directory at the time you add an entry to the source path.

`directory'
     Reset the source path to empty again.  This requires confirmation.

`show directories'
     Print the source path: show which directories it contains.

   If your source path is cluttered with directories that are no longer
of interest, GDB may sometimes cause confusion by finding the wrong
versions of source.  You can correct the situation as follows:

  1. Use `directory' with no argument to reset the source path to empty.

  2. Use `directory' with suitable arguments to reinstall the
     directories you want in the source path.  You can add all the
     directories in one command.


File: gdb.info,  Node: Machine Code,  Prev: Source Path,  Up: Source

Source and machine code
=======================

   You can use the command `info line' to map source lines to program
addresses (and vice versa), and the command `disassemble' to display a
range of addresses as machine instructions.

`info line LINESPEC'
     Print the starting and ending addresses of the compiled code for
     source line LINESPEC.  You can specify source lines in any of the
     ways understood by the `list' command (*note Printing source
     lines: List.).

   For example, we can use `info line' to discover the location of the
object code for the first line of function `m4_changequote':

     (gdb) info line m4_changecom
     Line 895 of "builtin.c" starts at pc 0x634c and ends at 0x6350.

We can also inquire (using `*ADDR' as the form for LINESPEC) what
source line covers a particular address:
     (gdb) info line *0x63ff
     Line 926 of "builtin.c" starts at pc 0x63e4 and ends at 0x6404.

   After `info line', the default address for the `x' command is
changed to the starting address of the line, so that `x/i' is
sufficient to begin examining the machine code (*note Examining memory:
Memory.).  Also, this address is saved as the value of the convenience
variable `$_' (*note Convenience variables: Convenience Vars.).

`disassemble'
     This specialized command dumps a range of memory as machine
     instructions.  The default memory range is the function
     surrounding the program counter of the selected frame.  A single
     argument to this command is a program counter value; GDB dumps the
     function surrounding this value.  Two arguments specify a range of
     addresses (first inclusive, second exclusive) to dump.

   We can use `disassemble' to inspect the object code range shown in
the last `info line' example (the example shows SPARC machine
instructions):

     (gdb) disas 0x63e4 0x6404
     Dump of assembler code from 0x63e4 to 0x6404:
     0x63e4 <builtin_init+5340>:     ble 0x63f8 <builtin_init+5360>
     0x63e8 <builtin_init+5344>:     sethi %hi(0x4c00), %o0
     0x63ec <builtin_init+5348>:     ld [%i1+4], %o0
     0x63f0 <builtin_init+5352>:     b 0x63fc <builtin_init+5364>
     0x63f4 <builtin_init+5356>:     ld [%o0+4], %o0
     0x63f8 <builtin_init+5360>:     or %o0, 0x1a4, %o0
     0x63fc <builtin_init+5364>:     call 0x9288 <path_search>
     0x6400 <builtin_init+5368>:     nop
     End of assembler dump.


File: gdb.info,  Node: Data,  Next: Languages,  Prev: Source,  Up: Top

Examining Data
**************

   The usual way to examine data in your program is with the `print'
command (abbreviated `p'), or its synonym `inspect'.  It evaluates and
prints the value of an expression of the language your program is
written in (*note Using GDB with Different Languages: Languages.).

`print EXP'
`print /F EXP'
     EXP is an expression (in the source language).  By default the
     value of EXP is printed in a format appropriate to its data type;
     you can choose a different format by specifying `/F', where F is a
     letter specifying the format; *note Output formats: Output
     Formats..

`print'
`print /F'
     If you omit EXP, GDB displays the last value again (from the
     "value history"; *note Value history: Value History.).  This
     allows you to conveniently inspect the same value in an
     alternative format.

   A more low-level way of examining data is with the `x' command.  It
examines data in memory at a specified address and prints it in a
specified format.  *Note Examining memory: Memory.

   If you are interested in information about types, or about how the
fields of a struct or class are declared, use the `ptype EXP' command
rather than `print'. *Note Examining the Symbol Table: Symbols.

* Menu:

* Expressions::                 Expressions
* Variables::                   Program variables
* Arrays::                      Artificial arrays
* Output Formats::              Output formats
* Memory::                      Examining memory
* Auto Display::                Automatic display
* Print Settings::              Print settings
* Value History::               Value history
* Convenience Vars::            Convenience variables
* Registers::                   Registers

* Floating Point Hardware::     Floating point hardware


File: gdb.info,  Node: Expressions,  Next: Variables,  Up: Data

Expressions
===========

   `print' and many other GDB commands accept an expression and compute
its value.  Any kind of constant, variable or operator defined by the
programming language you are using is valid in an expression in GDB.
This includes conditional expressions, function calls, casts and string
constants.  It unfortunately does not include symbols defined by
preprocessor `#define' commands.

   Because C is so widespread, most of the expressions shown in
examples in this manual are in C.  *Note Using GDB with Different
Languages: Languages, for information on how to use expressions in other
languages.

   In this section, we discuss operators that you can use in GDB
expressions regardless of your programming language.

   Casts are supported in all languages, not just in C, because it is so
useful to cast a number into a pointer so as to examine a structure at
that address in memory.

   GDB supports these operators in addition to those of programming
languages:

`@'
     `@' is a binary operator for treating parts of memory as arrays.
     *Note Artificial arrays: Arrays, for more information.

`::'
     `::' allows you to specify a variable in terms of the file or
     function where it is defined.  *Note Program variables: Variables.

`{TYPE} ADDR'
     Refers to an object of type TYPE stored at address ADDR in memory.
     ADDR may be any expression whose value is an integer or pointer
     (but parentheses are required around binary operators, just as in
     a cast).  This construct is allowed regardless of what kind of
     data is normally supposed to reside at ADDR.


File: gdb.info,  Node: Variables,  Next: Arrays,  Prev: Expressions,  Up: Data

Program variables
=================

   The most common kind of expression to use is the name of a variable
in your program.

   Variables in expressions are understood in the selected stack frame
(*note Selecting a frame: Selection.); they must either be global (or
static) or be visible according to the scope rules of the programming
language from the point of execution in that frame.  This means that in
the function

     foo (a)
          int a;
     {
       bar (a);
       {
         int b = test ();
         bar (b);
       }
     }

you can examine and use the variable `a' whenever your program is
executing within the function `foo', but you can only use or examine
the variable `b' while your program is executing inside the block where
`b' is declared.

   There is an exception: you can refer to a variable or function whose
scope is a single source file even if the current execution point is not
in this file.  But it is possible to have more than one such variable or
function with the same name (in different source files).  If that
happens, referring to that name has unpredictable effects.  If you wish,
you can specify a static variable in a particular function or file,
using the colon-colon notation:

     FILE::VARIABLE
     FUNCTION::VARIABLE

Here FILE or FUNCTION is the name of the context for the static
VARIABLE.  In the case of file names, you can use quotes to make sure
GDB parses the file name as a single word--for example, to print a
global value of `x' defined in `f2.c':

     (gdb) p 'f2.c'::x

   This use of `::' is very rarely in conflict with the very similar
use of the same notation in C++.  GDB also supports use of the C++
scope resolution operator in GDB expressions.

     *Warning:* Occasionally, a local variable may appear to have the
     wrong value at certain points in a function--just after entry to a
     new scope, and just before exit.
   You may see this problem when you are stepping by machine
instructions.  This is because on most machines, it takes more than one
instruction to set up a stack frame (including local variable
definitions); if you are stepping by machine instructions, variables
may appear to have the wrong values until the stack frame is completely
built.  On exit, it usually also takes more than one machine
instruction to destroy a stack frame; after you begin stepping through
that group of instructions, local variable definitions may be gone.


File: gdb.info,  Node: Arrays,  Next: Output Formats,  Prev: Variables,  Up: Data

Artificial arrays
=================

   It is often useful to print out several successive objects of the
same type in memory; a section of an array, or an array of dynamically
determined size for which only a pointer exists in the program.

   You can do this by referring to a contiguous span of memory as an
"artificial array", using the binary operator `@'.  The left operand of
`@' should be the first element of the desired array, as an individual
object.  The right operand should be the desired length of the array.
The result is an array value whose elements are all of the type of the
left argument.  The first element is actually the left argument; the
second element comes from bytes of memory immediately following those
that hold the first element, and so on.  Here is an example.  If a
program says

     int *array = (int *) malloc (len * sizeof (int));

you can print the contents of `array' with

     p *array@len

   The left operand of `@' must reside in memory.  Array values made
with `@' in this way behave just like other arrays in terms of
subscripting, and are coerced to pointers when used in expressions.
Artificial arrays most often appear in expressions via the value history
(*note Value history: Value History.), after printing one out.

   Sometimes the artificial array mechanism is not quite enough; in
moderately complex data structures, the elements of interest may not
actually be adjacent--for example, if you are interested in the values
of pointers in an array.  One useful work-around in this situation is
to use a convenience variable (*note Convenience variables: Convenience
Vars.) as a counter in an expression that prints the first interesting
value, and then repeat that expression via RET.  For instance, suppose
you have an array `dtab' of pointers to structures, and you are
interested in the values of a field `fv' in each structure.  Here is an
example of what you might type:

     set $i = 0
     p dtab[$i++]->fv
     RET
     RET
     ...


File: gdb.info,  Node: Output Formats,  Next: Memory,  Prev: Arrays,  Up: Data

Output formats
==============

   By default, GDB prints a value according to its data type.  Sometimes
this is not what you want.  For example, you might want to print a
number in hex, or a pointer in decimal.  Or you might want to view data
in memory at a certain address as a character string or as an
instruction.  To do these things, specify an "output format" when you
print a value.

   The simplest use of output formats is to say how to print a value
already computed.  This is done by starting the arguments of the
`print' command with a slash and a format letter.  The format letters
supported are:

`x'
     Regard the bits of the value as an integer, and print the integer
     in hexadecimal.

`d'
     Print as integer in signed decimal.

`u'
     Print as integer in unsigned decimal.

`o'
     Print as integer in octal.

`t'
     Print as integer in binary.  The letter `t' stands for "two".  (1)

`a'
     Print as an address, both absolute in hexadecimal and as an offset
     from the nearest preceding symbol.  You can use this format used
     to discover where (in what function) an unknown address is located:

          (gdb) p/a 0x54320
          $3 = 0x54320 <_initialize_vx+396>

`c'
     Regard as an integer and print it as a character constant.

`f'
     Regard the bits of the value as a floating point number and print
     using typical floating point syntax.

   For example, to print the program counter in hex (*note
Registers::.), type

     p/x $pc

Note that no space is required before the slash; this is because command
names in GDB cannot contain a slash.

   To reprint the last value in the value history with a different
format, you can use the `print' command with just a format and no
expression.  For example, `p/x' reprints the last value in hex.

   ---------- Footnotes ----------

   (1)  `b' cannot be used because these format letters are also used
with the `x' command, where `b' stands for "byte"; *note Examining
memory: Memory..


File: gdb.info,  Node: Memory,  Next: Auto Display,  Prev: Output Formats,  Up: Data

Examining memory
================

   You can use the command `x' (for "examine") to examine memory in any
of several formats, independently of your program's data types.

`x/NFU ADDR'
`x ADDR'
`x'
     Use the `x' command to examine memory.

   N, F, and U are all optional parameters that specify how much memory
to display and how to format it; ADDR is an expression giving the
address where you want to start displaying memory.  If you use defaults
for NFU, you need not type the slash `/'.  Several commands set
convenient defaults for ADDR.

N, the repeat count
     The repeat count is a decimal integer; the default is 1.  It
     specifies how much memory (counting by units U) to display.

F, the display format
     The display format is one of the formats used by `print', or `s'
     (null-terminated string) or `i' (machine instruction).  The
     default is `x' (hexadecimal) initially, or the format from the
     last time you used either `x' or `print'.

U, the unit size
     The unit size is any of

    `b'
          Bytes.

    `h'
          Halfwords (two bytes).

    `w'
          Words (four bytes).  This is the initial default.

    `g'
          Giant words (eight bytes).

     Each time you specify a unit size with `x', that size becomes the
     default unit the next time you use `x'.  (For the `s' and `i'
     formats, the unit size is ignored and is normally not written.)

ADDR, starting display address
     ADDR is the address where you want GDB to begin displaying memory.
     The expression need not have a pointer value (though it may); it
     is always interpreted as an integer address of a byte of memory.
     *Note Expressions: Expressions, for more information on
     expressions.  The default for ADDR is usually just after the last
     address examined--but several other commands also set the default
     address: `info breakpoints' (to the address of the last breakpoint
     listed), `info line' (to the starting address of a line), and
     `print' (if you use it to display a value from memory).

   For example, `x/3uh 0x54320' is a request to display three halfwords
(`h') of memory, formatted as unsigned decimal integers (`u'), starting
at address `0x54320'.  `x/4xw $sp' prints the four words (`w') of
memory above the stack pointer (here, `$sp'; *note Registers::.) in
hexadecimal (`x').

   Since the letters indicating unit sizes are all distinct from the
letters specifying output formats, you do not have to remember whether
unit size or format comes first; either order works.  The output
specifications `4xw' and `4wx' mean exactly the same thing.  (However,
the count N must come first; `wx4' does not work.)

   Even though the unit size U is ignored for the formats `s' and `i',
you might still want to use a count N; for example, `3i' specifies that
you want to see three machine instructions, including any operands.
The command `disassemble' gives an alternative way of inspecting
machine instructions; *note Source and machine code: Machine Code..

   All the defaults for the arguments to `x' are designed to make it
easy to continue scanning memory with minimal specifications each time
you use `x'.  For example, after you have inspected three machine
instructions with `x/3i ADDR', you can inspect the next seven with just
`x/7'.  If you use RET to repeat the `x' command, the repeat count N is
used again; the other arguments default as for successive uses of `x'.

   The addresses and contents printed by the `x' command are not saved
in the value history because there is often too much of them and they
would get in the way.  Instead, GDB makes these values available for
subsequent use in expressions as values of the convenience variables
`$_' and `$__'.  After an `x' command, the last address examined is
available for use in expressions in the convenience variable `$_'.  The
contents of that address, as examined, are available in the convenience
variable `$__'.

   If the `x' command has a repeat count, the address and contents saved
are from the last memory unit printed; this is not the same as the last
address printed if several units were printed on the last line of
output.


File: gdb.info,  Node: Auto Display,  Next: Print Settings,  Prev: Memory,  Up: Data

Automatic display
=================

   If you find that you want to print the value of an expression
frequently (to see how it changes), you might want to add it to the
"automatic display list" so that GDB prints its value each time your
program stops.  Each expression added to the list is given a number to
identify it; to remove an expression from the list, you specify that
number.  The automatic display looks like this:

     2: foo = 38
     3: bar[5] = (struct hack *) 0x3804

This display shows item numbers, expressions and their current values.
As with displays you request manually using `x' or `print', you can
specify the output format you prefer; in fact, `display' decides
whether to use `print' or `x' depending on how elaborate your format
specification is--it uses `x' if you specify a unit size, or one of the
two formats (`i' and `s') that are only supported by `x'; otherwise it
uses `print'.

`display EXP'
     Add the expression EXP to the list of expressions to display each
     time your program stops.  *Note Expressions: Expressions.

     `display' does not repeat if you press RET again after using it.

`display/FMT EXP'
     For FMT specifying only a display format and not a size or count,
     add the expression EXP to the auto-display list but arrange to
     display it each time in the specified format FMT.  *Note Output
     formats: Output Formats.

`display/FMT ADDR'
     For FMT `i' or `s', or including a unit-size or a number of units,
     add the expression ADDR as a memory address to be examined each
     time your program stops.  Examining means in effect doing `x/FMT
     ADDR'.  *Note Examining memory: Memory.

   For example, `display/i $pc' can be helpful, to see the machine
instruction about to be executed each time execution stops (`$pc' is a
common name for the program counter; *note Registers::.).

`undisplay DNUMS...'
`delete display DNUMS...'
     Remove item numbers DNUMS from the list of expressions to display.

     `undisplay' does not repeat if you press RET after using it.
     (Otherwise you would just get the error `No display number ...'.)

`disable display DNUMS...'
     Disable the display of item numbers DNUMS.  A disabled display
     item is not printed automatically, but is not forgotten.  It may be
     enabled again later.

`enable display DNUMS...'
     Enable display of item numbers DNUMS.  It becomes effective once
     again in auto display of its expression, until you specify
     otherwise.

`display'
     Display the current values of the expressions on the list, just as
     is done when your program stops.

`info display'
     Print the list of expressions previously set up to display
     automatically, each one with its item number, but without showing
     the values.  This includes disabled expressions, which are marked
     as such.  It also includes expressions which would not be
     displayed right now because they refer to automatic variables not
     currently available.

   If a display expression refers to local variables, then it does not
make sense outside the lexical context for which it was set up.  Such an
expression is disabled when execution enters a context where one of its
variables is not defined.  For example, if you give the command
`display last_char' while inside a function with an argument
`last_char', GDB displays this argument while your program continues to
stop inside that function.  When it stops elsewhere--where there is no
variable `last_char'--the display is disabled automatically.  The next
time your program stops where `last_char' is meaningful, you can enable
the display expression once again.

