/**********************************************************************
 *  
 *  NAME:           gppconio.h
 *  
 *  DESCRIPTION:    simulate Borland text video funcs for GNU C++
 *  
 *  copyright (c) 1991 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  10/27/91    J. Alan Eldridge    created
 *  
 *********************************************************************/

#ifndef __GPPCONIO_H
#define __GPPCONIO_H

#if defined(__TURBOC__)
#error  Use conio.h for Borland compilers!
#endif

extern int directvideo; /* ignored by gppconio */
extern int _wscroll;

#define _NOCURSOR      0
#define _SOLIDCURSOR   1
#define _NORMALCURSOR  2

struct text_info {
    unsigned char winleft;
    unsigned char wintop;
    unsigned char winright;
    unsigned char winbottom;
    unsigned char attribute;
    unsigned char normattr;
    unsigned char currmode;
    unsigned char screenheight;
    unsigned char screenwidth;
    unsigned char curx;
    unsigned char cury;
};

enum text_modes { LASTMODE=-1, BW40=0, C40, BW80, C80, MONO=7, C4350=64 };

enum COLORS {
    /*  dark colors     */
    BLACK,          
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    /*  light colors    */
    DARKGRAY,
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE
};

#define BLINK   0x80    /*  blink bit   */

#ifdef  __cplusplus
extern "C" {
#endif

void    clreol(void);
void    clrscr(void);
void    gotoxy(int x, int y);
int     wherex(void);
int     wherey(void);
int     putch(int c);
int     getch(void);
int     getche(void);
int     ungetch(int); 
int     kbhit(void);
int     _conio_kbhit(void); /* checks for ungetch char */
void    delline(void);
int     gettext(int left, int top, int right, int bottom, void *destin);
void    gettextinfo(struct text_info *r);
void    highvideo(void);
void    insline(void);
void    lowvideo(void);
int     movetext(int left, int top, int right, int bottom, 
            int destleft, int desttop);
void    normvideo(void);
int     puttext(int left, int top, int right, int bottom, void *source);
void    textattr(int attr);
void    textbackground(int color);
void    textcolor(int color);
void    textmode(int unused_mode);
void    window(int left, int top, int right, int bottom);
void    _setcursortype(int unused_type);
char    *cgets(char *str); 
int     cprintf(const char *format, ...);
int     cputs(const char *str);
int     cscanf(const char *format, ...); 
/* char    *getpass(const char *prompt); */
void gppconio_init(void);

#ifdef  __cplusplus
}
#endif

#define kbhit _conio_kbhit /* Who ever includes gppconio.h probably
                              also wants _conio_kbhit and not kbhit
                              from libc */
#endif
