//------------------------------------------------------------------------------
// File: Graph.h
//
// Desc: Sample code for BDA graph building.
//
//
// Copyright (c) 2003, Conexant Sytems, Inc. All rights reserved.
//------------------------------------------------------------------------------

#ifndef GRAPH_H_INCLUDED_
#define GRAPH_H_INCLUDED_


#include "bdasampl.h"
#include "THIOCtrl.h"

// Constants

const ULONG SMALLEST_FREQ          = 0;
const ULONG LARGEST_FREQ           = 999999; // in KHz

const ULONG  SMALLEST_MPEG_PID     = 0;
const ULONG  LARGEST_MPEG_PID      = 8191;


// Constants
// {B5FAEB6A-D051-43a1-B499-24F4DE1B87EC}
static const GUID IID_IMpeg2PsiParser = 
{ 0xb5faeb6a, 0xd051, 0x43a1, { 0xb4, 0x99, 0x24, 0xf4, 0xde, 0x1b, 0x87, 0xec } };


//
// PSI parser Filter Object
//
// {19712ABA-EA52-4959-BF49-F02E639F27E3}
static const GUID CLSID_THPsiParser = 
{ 0x19712aba, 0xea52, 0x4959, { 0xbf, 0x49, 0xf0, 0x2e, 0x63, 0x9f, 0x27, 0xe3 } }; //New
//{ 0xbc08af6c, 0x63ab, 0x4e43, { 0xa7, 0x74, 0x4,  0xbc, 0xa4, 0x87, 0x98, 0x10 } } ; //OLD



// {255E0082-2017-4b03-90F8-856A62CB3D67}
static const GUID GUID_THBDA_CMD = 
{ 0x255e0082, 0x2017, 0x4b03, { 0x90, 0xf8, 0x85, 0x6a, 0x62, 0xcb, 0x3d, 0x67 } };


//{E5644CC4-17A1-4eed-BD90-74FDA1D65423}
static GUID GUID_THBDA_TUNER = 
{ 0xE5644CC4, 0x17A1, 0x4eed, { 0xBD, 0x90, 0x74, 0xFD, 0xA1, 0xD6, 0x54, 0x23 } };

	DECLARE_INTERFACE_(IMpeg2PsiParser, IUnknown)
    {
		STDMETHOD(SetPMTType) (THIS_
            unsigned int PMTType           //0: Original, 1:CAPMT
        ) PURE;

		STDMETHOD(SetCAPMT) (THIS_
            unsigned int VPID, unsigned int APID, unsigned int CamType
        ) PURE;

		STDMETHOD(GetPMTData) (THIS_
            PBYTE pBuff, PBYTE byBuffSize
        ) PURE;

        STDMETHOD(GetTransportStreamId) (THIS_
            WORD *pStreamId      
        ) PURE;

        STDMETHOD(GetPatVersionNumber) (THIS_
            BYTE *pPatVersion        
        ) PURE;

        STDMETHOD(GetCountOfPrograms) (THIS_
            int *pNumOfPrograms        
        ) PURE;

        STDMETHOD(GetRecordProgramNumber) (THIS_
            DWORD dwIndex, 
            WORD * pwVal     
        ) PURE;

        STDMETHOD(GetRecordProgramMapPid) (THIS_
            DWORD dwIndex, 
            WORD * pwVal      
        ) PURE;

        STDMETHOD(FindRecordProgramMapPid) (THIS_
            WORD wProgramNumber, 
            WORD * pwVal       
        ) PURE;


        STDMETHOD(GetPmtVersionNumber) (THIS_
            WORD wProgramNumber, 
            BYTE *pPmtVersion
            )PURE;


        STDMETHOD(GetCountOfElementaryStreams) (THIS_
            WORD wProgramNumber, 
            WORD *pwVal
            )PURE;

        STDMETHOD(GetRecordStreamType) (THIS_
            WORD wProgramNumber,
            DWORD dwRecordIndex, 
            BYTE *pbVal
            )PURE;

        STDMETHOD(GetRecordElementaryPid) (THIS_
            WORD wProgramNumber,
            DWORD dwRecordIndex, 
            WORD *pwVal
            )PURE;

        };


class CBDAFilterGraph
{
private:
    CComPtr <ITuningSpace>          m_pITuningSpace;
	CComPtr <ITuningSpaceContainer> m_pTuningSpaceContainer;

    CComPtr <IScanningTuner> m_pITuner;

    CComPtr <IGraphBuilder>  m_pFilterGraph;      // for current graph
    CComPtr <IMediaControl>  m_pIMediaControl;    // for controlling graph state
    CComPtr <ICreateDevEnum> m_pICreateDevEnum;   // for enumerating system devices

	CComPtr <IMpeg2PsiParser> m_pIMpeg2PsiParser;

    CComPtr <IBaseFilter>    m_pNetworkProvider;  // for network provider filter
    CComPtr <IBaseFilter>    m_pTunerDemodDevice; // for tuner device filter
    CComPtr <IBaseFilter>    m_pCaptureDevice;    // for capture device filter
    CComPtr <IBaseFilter>    m_pDemux;            // for demux filter
    CComPtr <IBaseFilter>    m_pVideoDecoder;     // for mpeg video decoder filter
    CComPtr <IBaseFilter>    m_pAudioDecoder;     // for mpeg audio decoder filter
    CComPtr <IBaseFilter>    m_pTIF;              // for transport information filter
    CComPtr <IBaseFilter>    m_pMPE;              // for multiple proto
	CComPtr <IBaseFilter>    m_pTHPsiParser;       // for THPSI Parsercol encapsulator
    CComPtr <IBaseFilter>    m_pIPSink;           // for ip sink filter
    CComPtr <IBaseFilter>    m_pOVMixer;          // for overlay mixer filter
    CComPtr <IBaseFilter>    m_pVRenderer;        // for video renderer filter
    CComPtr <IBaseFilter>    m_pDDSRenderer;      // for sound renderer filter

    CComPtr <IPin>           m_pVideoPin;         // demux filter video pin
    CComPtr <IPin>           m_pAudioPin;         // demux filter audio pin
	CComPtr <IPin>           m_pTHParserPin;         // demux filter audio pin

    CComPtr <IMPEG2PIDMap>   m_pIVideoPIDMap;     // for demux filter video pin PID 
    CComPtr <IMPEG2PIDMap>   m_pIAudioPIDMap;     // for demux filter audio pin PID
	CComPtr <IMPEG2PIDMap>   m_pITHParserPIDMap;  // for demux filter THParser pin PID

    CComPtr <IKsPropertySet> m_KsTunerPropSet;    // IKsPropertySet for tuner
    CComPtr <IKsPropertySet> m_KsDemodPropSet;    // IKsPropertySet for demod

    LONG                     m_mappedVidPid;      // the video pin PID
    LONG                     m_mappedAudPid;      // the audio pin PID

    CComPtr <IPin>           m_pTunerPin;         // the tuner pin on the tuner/demod filter
    CComPtr <IPin>           m_pDemodPin;         // the demod pin on the tuner/demod filter
    
    //
    //required for an DVBT network when creating a tune request
    //
    ULONG                    m_ulCarrierFrequency;
	ULONG					m_SymbolRate;
	ULONG					m_PMTPID;

    LONG                     m_ONID;  // original network ID
    LONG                     m_TSID;  // transponder ID
    LONG                     m_SID;   // service ID

    //registration number for the RunningObjectTable
    DWORD                    m_dwGraphRegister;

    HRESULT InitializeGraphBuilder();
    HRESULT LoadTuningSpace(CComBSTR pNetworkType);
    HRESULT LoadNetworkProvider(CComBSTR pNetworkType);
    HRESULT LoadDemux();
    HRESULT RenderDemux();
    void    BuildGraphError();
    HRESULT BuildAVSegment();
    HRESULT LoadVideoDecoder();
    HRESULT LoadAudioDecoder();
    void    ReleaseInterfaces();

    HRESULT LoadFilter(
        REFCLSID clsid, 
        IBaseFilter** ppFilter,
        IBaseFilter* pConnectFilter, 
        BOOL fIsUpstream
        );

    HRESULT ConnectFilters(
        IBaseFilter* pFilterUpstream, 
        IBaseFilter* pFilterDownstream
        );

    HRESULT CreateDVBTTuneRequest(IDVBTuneRequest** pTuneRequest);

    HRESULT CreateTuningSpace(CComBSTR pNetworkType);

    IPin* FindPinOnFilter(IBaseFilter *pBaseFilter, char *pPinName);

    BOOL GetTunerDemodPropertySetInterfaces();

public:
    bool m_fGraphBuilt;
    bool m_fGraphRunning;
    bool m_fGraphFailure;

    CBDAFilterGraph();   
    ~CBDAFilterGraph();

    CComPtr<IScanningTuner> getITuner() { return m_pITuner; }

	HRESULT BuildGraph(CComBSTR pNetworkType);
    HRESULT RunGraph();
    HRESULT StopGraph();
    HRESULT TearDownGraph();

    IBaseFilter* getDemux() { return m_pDemux; }

    HRESULT SetVideoWindow(HWND hwndMain);
    
    HRESULT ChangeChannel();

    HRESULT SetVideoAndAudioPIDs(LONG lNewVideoPID, LONG lNewAudioPID);
    HRESULT UnmapVideoAndAudioPIDs(LONG lOldVideoPID, LONG lOldAudioPID);

    // Adds/removes a DirectShow filter graph from the Running Object Table,
    // allowing GraphEdit to "spy" on a remote filter graph if enabled.
    HRESULT AddGraphToRot(IUnknown *pUnkGraph, DWORD *pdwRegister);

    void RemoveGraphFromRot(DWORD pdwRegister);

    ULONG GetCarrierFrequency() { return m_ulCarrierFrequency; }

    BOOL GetSignalStrength(LONG* lSignalStrength);
    BOOL GetSignalQuality(LONG* lSignalQuality);

    LONG GetONID() { return m_ONID; }
    LONG GetTSID() { return m_TSID; }
    LONG GetSID() { return m_SID; }

    LONG GetVideoPID() { return m_mappedVidPid; }
    LONG GetAudioPID() { return m_mappedAudPid; }

	BOOL CheckBDAInterface();
	BOOL BDAIOControl( DWORD  dwIoControlCode,
						LPVOID lpInBuffer,
						DWORD  nInBufferSize,
						LPVOID lpOutBuffer,
						DWORD  nOutBufferSize,
						LPDWORD lpBytesReturned);
	BOOL SendCAPMT(PBYTE pBuff, BYTE byBuffSize);
	BOOL CI_Parser_PMT(PPARSERPMTINFO pPMTInfo);
	BOOL GetAppInfo(PTHAppInfo pAppInfo);
	BOOL THBDA_IOCTL_SET_REG_PARAMS_Fun(PTHBDAREGPARAMS pTH_Params);

    void SetCarrierFrequency( ULONG ulCarrierFreq ) { m_ulCarrierFrequency = ulCarrierFreq; }
    void SetONID( LONG lONID ) { m_ONID = lONID; }
    void SetTSID( LONG lTSID ) { m_TSID = lTSID; }
    void SetSID( LONG lSID ) { m_SID = lSID; }

    void SetVideoPID(LONG VideoPID) { m_mappedVidPid = VideoPID; }
    void SetAudioPID(LONG AudioPID) { m_mappedAudPid = AudioPID; }
};
 
VOID MessagePrint(LPTSTR szFormat, ...);
/*
typedef enum _CAM_TYPE_ENUM
{
    CAM_DEFAULT = 1, //Viaccess
    TH_CAM_ASTON = 2,
    TH_CAM_CONAX = 3,
    TH_CAM_CRYPTOWORKS = 4    
}  CAM_TYPE_ENUM;
*/
#endif // GRAPH_H_INCLUDED_
