program idecfg;

function HexToWord( s : string ) : word;
{converts the hex represented by the string, to a WORD}
var
  i     :  Byte;
  Wd    :  Word;
  Digit :  Byte;
  Error :  Boolean;
begin
  Wd := 0; Error := False;
  if (length(s) <= 4) then begin
    for i := 1 to length(s) do begin
      case s[i] of
        '0'..'9' : Digit := BYTE(s[i]) - 48;
        'A'..'F' : Digit := 10 + (BYTE(s[i]) - 65);
        'a'..'f' : Digit := 10 + (BYTE(s[i]) - 97);
      else Error := True;
      end;{case}
      if Error then i := length(s)
      else Wd := (Wd SHL 4) + Digit;
    end;{for}
  end;{if}
  if Error then HexToWord := 0
  else HexToWord := Wd;
end;{function}


var
  MemMapBase, Res : Word;

begin
  WriteLn('XT-CF Board Run-time Configurator, version 0.2');
  WriteLn;
  If ParamCount = 0 then begin
    {show help}
    WriteLn('Enables or disables memory-mapped IO for Fast XT/IDE family of');
    WriteLn('IDE controllers.');
    WriteLn;
    WriteLn('To enable memory-mapped IO, specify the base address to use');
    WriteLn('i.e. D800 for that address.  A 4K window will then be used by');
    WriteLn('the card, starting there (must be 4K aligned)');
    WriteLn;
    WriteLn('To disabed memory-mapped IO, specify 0 as the parameter.');
    WriteLn;
    WriteLn;
    WriteLn('Also enables DMA channel 3 operation for compact flash boards');
    WriteLn('(only) - specify any value 0 < x < A000, i.e. 1.  This also');
    Writeln('attempts to put the CF card into 8-bit mode via a feature set');
    WriteLn('assuming the board is at 300h');
    WriteLn;
  end else
  begin {do the work}
    Write('Attempting to set window to ',ParamStr(1), '... ');
    MemMapBase := HexToWord(ParamStr(1));
    {set register first}
    asm
      mov       ax, MemMapBase
      xchg      al, ah
      mov       dx, $30f
      out       dx, al
    end;
    {next set CF card to 8-bit if we need to}
    if (MemMapBase > 0) and (MemMapBase < $A000) then
    begin
      {set CF card to 8-bit transfers}
      asm
        mov     al, $01
        mov     dx, $308
        out     dx, al
        mov     al, $ef
        mov     dx, $30e
        out     dx, al
      end;
    end {if}
    else
    begin
      {set CF card to 16-bit transfers}
      asm
        mov     al, $81
        mov     dx, $308
        out     dx, al
        mov     al, $ef
        mov     dx, $30e
        out     dx, al
      end;
    end;{if/else}
    WriteLn('OK.')
  end;{if/else}
end.{program}
