/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.AccessHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Effect {
    public static final Effect DefaultInput = null;
    private WeakPCSList propListeners;
    private final PropertyChangeListener inputListener;
    private final List<Effect> inputs;
    private final List<Effect> unmodifiableInputs;
    private final int maxInputs;

    protected Effect() {
        this.inputs = Collections.emptyList();
        this.unmodifiableInputs = this.inputs;
        this.maxInputs = 0;
        this.inputListener = null;
    }

    protected Effect(Effect effect) {
        this.inputs = new ArrayList<Effect>(1);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 1;
        this.inputListener = new InputChangeListener();
        this.setInput(0, effect);
    }

    protected Effect(Effect effect, Effect effect2) {
        this.inputs = new ArrayList<Effect>(2);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 2;
        this.inputListener = new InputChangeListener();
        this.setInput(0, effect);
        this.setInput(1, effect2);
    }

    Object getState() {
        return null;
    }

    public int getNumInputs() {
        return this.inputs.size();
    }

    public final List<Effect> getInputs() {
        return this.unmodifiableInputs;
    }

    protected void setInput(int n, Effect effect) {
        if (n < 0 || n >= this.maxInputs) {
            throw new IllegalArgumentException("Index must be within allowable range");
        }
        if (n < this.inputs.size()) {
            Effect effect2 = this.inputs.get(n);
            if (effect2 != null) {
                effect2.removePropertyChangeListener(this.inputListener);
            }
            this.inputs.set(n, effect);
        } else {
            this.inputs.add(effect);
        }
        if (effect != null) {
            effect.addPropertyChangeListener(this.inputListener);
        }
        this.firePropertyChange("inputs", null, this.inputs);
    }

    public static BaseBounds combineBounds(BaseBounds ... baseBoundsArray) {
        BaseBounds baseBounds = null;
        if (baseBoundsArray.length == 1) {
            baseBounds = baseBoundsArray[0];
        } else {
            for (int i = 0; i < baseBoundsArray.length; ++i) {
                BaseBounds baseBounds2 = baseBoundsArray[i];
                if (baseBounds2 == null || baseBounds2.isEmpty()) continue;
                if (baseBounds == null) {
                    baseBounds = new RectBounds();
                    baseBounds = baseBounds.deriveWithNewBounds(baseBounds2);
                    continue;
                }
                baseBounds = baseBounds.deriveWithUnion(baseBounds2);
            }
        }
        if (baseBounds == null) {
            baseBounds = new RectBounds();
        }
        return baseBounds;
    }

    public static Rectangle combineBounds(Rectangle ... rectangleArray) {
        Rectangle rectangle = null;
        if (rectangleArray.length == 1) {
            rectangle = rectangleArray[0];
        } else {
            for (int i = 0; i < rectangleArray.length; ++i) {
                Rectangle rectangle2 = rectangleArray[i];
                if (rectangle2 == null || rectangle2.isEmpty()) continue;
                if (rectangle == null) {
                    rectangle = new Rectangle(rectangle2);
                    continue;
                }
                rectangle.add(rectangle2);
            }
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        return rectangle;
    }

    public Rectangle getResultBounds(BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
        int n = imageDataArray.length;
        Rectangle[] rectangleArray = new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            rectangleArray[i] = imageDataArray[i].getTransformedBounds(rectangle);
        }
        Rectangle rectangle2 = Effect.combineBounds(rectangleArray);
        return rectangle2;
    }

    public abstract ImageData filter(FilterContext var1, BaseTransform var2, Rectangle var3, Object var4, Effect var5);

    public static BaseBounds transformBounds(BaseTransform baseTransform, BaseBounds baseBounds) {
        if (baseTransform == null || baseTransform.isIdentity()) {
            return baseBounds;
        }
        BaseBounds baseBounds2 = new RectBounds();
        baseBounds2 = baseTransform.transform(baseBounds, baseBounds2);
        return baseBounds2;
    }

    protected ImageData ensureTransform(FilterContext filterContext, ImageData imageData, BaseTransform baseTransform, Rectangle rectangle) {
        if (baseTransform == null || baseTransform.isIdentity()) {
            return imageData;
        }
        if (!imageData.validate(filterContext)) {
            imageData.unref();
            return new ImageData(filterContext, null, new Rectangle());
        }
        return imageData.transform(baseTransform);
    }

    public final BaseBounds getBounds() {
        return this.getBounds(null, null);
    }

    Effect getDefaultedInput(int n, Effect effect) {
        return Effect.getDefaultedInput(this.inputs.get(n), effect);
    }

    static Effect getDefaultedInput(Effect effect, Effect effect2) {
        return effect == null ? effect2 : effect;
    }

    public abstract BaseBounds getBounds(BaseTransform var1, Effect var2);

    public Point2D transform(Point2D point2D, Effect effect) {
        return point2D;
    }

    public Point2D untransform(Point2D point2D, Effect effect) {
        return point2D;
    }

    public static Filterable createCompatibleImage(FilterContext filterContext, int n, int n2) {
        return Renderer.getRenderer(filterContext).createCompatibleImage(n, n2);
    }

    public static Filterable getCompatibleImage(FilterContext filterContext, int n, int n2) {
        return Renderer.getRenderer(filterContext).getCompatibleImage(n, n2);
    }

    public static void releaseCompatibleImage(FilterContext filterContext, Filterable filterable) {
        Renderer.getRenderer(filterContext).releaseCompatibleImage(filterable);
    }

    public abstract AccelType getAccelType(FilterContext var1);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propListeners = WeakPCSList.add(this.propListeners, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propListeners = WeakPCSList.remove(this.propListeners, propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propListeners = WeakPCSList.firePropertyChange(this.propListeners, this, string, object, object2);
    }

    static {
        AccessHelper.setStateAccessor(new AccessHelper.StateAccessor(){

            @Override
            public Object getState(Effect effect) {
                return effect.getState();
            }
        });
    }

    public static enum AccelType {
        INTRINSIC("Intrinsic"),
        NONE("CPU/Java"),
        SIMD("CPU/SIMD"),
        FIXED("CPU/Fixed"),
        OPENGL("OpenGL"),
        DIRECT3D("Direct3D");

        private String text;

        private AccelType(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }
    }

    private class InputChangeListener
    implements PropertyChangeListener {
        private InputChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Effect.this.firePropertyChange("inputs", null, Effect.this.inputs);
        }
    }

    private static class WeakPCSList {
        WeakReference<PropertyChangeListener> delegateListener;
        WeakPCSList next;

        private WeakPCSList(PropertyChangeListener propertyChangeListener) {
            this.delegateListener = new WeakReference<PropertyChangeListener>(propertyChangeListener);
        }

        public static WeakPCSList add(WeakPCSList weakPCSList, PropertyChangeListener propertyChangeListener) {
            WeakPCSList weakPCSList2;
            WeakPCSList weakPCSList3 = null;
            WeakPCSList weakPCSList4 = null;
            boolean bl = false;
            while (weakPCSList != null) {
                weakPCSList2 = weakPCSList.next;
                Object t = weakPCSList.delegateListener.get();
                if (t == null) {
                    if (weakPCSList4 != null) {
                        weakPCSList4.next = weakPCSList2;
                    }
                } else {
                    if (t == propertyChangeListener) {
                        bl = true;
                    }
                    weakPCSList4 = weakPCSList;
                    if (weakPCSList3 == null) {
                        weakPCSList3 = weakPCSList;
                    }
                }
                weakPCSList = weakPCSList2;
            }
            if (!bl) {
                weakPCSList2 = new WeakPCSList(propertyChangeListener);
                if (weakPCSList3 == null) {
                    return weakPCSList2;
                }
                if (weakPCSList4 != null) {
                    weakPCSList4.next = weakPCSList2;
                }
            }
            return weakPCSList3;
        }

        public static WeakPCSList remove(WeakPCSList weakPCSList, PropertyChangeListener propertyChangeListener) {
            WeakPCSList weakPCSList2 = null;
            WeakPCSList weakPCSList3 = null;
            while (weakPCSList != null) {
                WeakPCSList weakPCSList4 = weakPCSList.next;
                Object t = weakPCSList.delegateListener.get();
                if (t == null || t == propertyChangeListener) {
                    if (weakPCSList3 != null) {
                        weakPCSList3.next = weakPCSList4;
                    }
                } else {
                    weakPCSList3 = weakPCSList;
                    if (weakPCSList2 == null) {
                        weakPCSList2 = weakPCSList;
                    }
                }
                weakPCSList = weakPCSList4;
            }
            return weakPCSList2;
        }

        public static WeakPCSList firePropertyChange(WeakPCSList weakPCSList, Effect effect, String string, Object object, Object object2) {
            WeakPCSList weakPCSList2 = null;
            if (weakPCSList != null) {
                WeakPCSList weakPCSList3;
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(effect, string, object, object2);
                WeakPCSList weakPCSList4 = null;
                do {
                    weakPCSList3 = weakPCSList.next;
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)weakPCSList.delegateListener.get();
                    if (propertyChangeListener == null) {
                        if (weakPCSList4 == null) continue;
                        weakPCSList4.next = weakPCSList3;
                        continue;
                    }
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                    weakPCSList4 = weakPCSList;
                    if (weakPCSList2 != null) continue;
                    weakPCSList2 = weakPCSList;
                } while ((weakPCSList = weakPCSList3) != null);
            }
            return weakPCSList2;
        }
    }
}

