/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladePowerCommand
extends MicroBladeCommand {
    @Override
    public void execute() throws Exception {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand;
        ISessionController sessionController;
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        if (this.getParameters() == null || this.getParameters().length < 3) {
            this.printUsage();
            this.statusCode = 147;
            return;
        }
        String subCommand = this.getParameters()[0];
        String bladeIndex = this.getParameters()[1];
        String nodeIndex = this.getParameters()[2];
        int bootOption = 2;
        if (subCommand.equalsIgnoreCase("cycle")) {
            if (this.getParameters().length > 3) {
                bladeIndex = this.getParameters()[2];
                nodeIndex = this.getParameters()[3];
            }
        } else if (subCommand.equalsIgnoreCase("bootOption")) {
            if (this.getParameters().length > 3) {
                bootOption = Integer.parseInt(this.getParameters()[1]);
                bladeIndex = this.getParameters()[2];
                nodeIndex = this.getParameters()[3];
            } else {
                this.printUsage();
                return;
            }
        }
        if ((sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null))) == null) {
            return;
        }
        NodeSensorInfo nodeSensorInfo = ipmiMicroBladeOEMCommand.getNodeSensor((byte)NodeSensorInfo.getBladeIndex(bladeIndex), (byte)(Integer.parseInt(nodeIndex) - 1));
        sessionController.closeSession();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(nodeSensorInfo.getBMCIP());
        config.setUserName(nodeSensorInfo.getDecryptedUsername());
        config.setPassword(nodeSensorInfo.getDecryptedPassword());
        config.setPrivilege((byte)4);
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        sessionController = SessionControllerFactory.createSessionController(config, ipmiChassisCommand);
        if (sessionController == null) {
            return;
        }
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(ipmiChassisCommand.getIPMIInterface());
        if (subCommand.equalsIgnoreCase("status")) {
            ACPIInfo acpi1 = ipmiGlobalCommand.getACPI();
            MOut.G(this).println("ACPI Power Status: " + acpi1.getSystemStateInfo() + " (" + acpi1.getSystemStateDescription() + ")");
            this.statusCode = 0;
        } else if (subCommand.equalsIgnoreCase("up")) {
            if (ipmiChassisCommand.powerUp()) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else if (subCommand.equalsIgnoreCase("down")) {
            if (ipmiChassisCommand.powerDown()) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else if (subCommand.equalsIgnoreCase("softshutdown")) {
            if (ipmiChassisCommand.softShutdown()) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else if (subCommand.equalsIgnoreCase("reset")) {
            if (ipmiChassisCommand.reset()) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else if (subCommand.equalsIgnoreCase("bootOption")) {
            GlobalDefine.BootDevice bootDevice = GlobalDefine.BootDevice.BIOS;
            switch (bootOption) {
                case 1: {
                    bootDevice = GlobalDefine.BootDevice.PXE;
                    break;
                }
                case 2: {
                    bootDevice = GlobalDefine.BootDevice.HD_DEFAULT;
                    break;
                }
                case 3: {
                    bootDevice = GlobalDefine.BootDevice.CD_DVD;
                    break;
                }
                case 4: {
                    bootDevice = GlobalDefine.BootDevice.BIOS;
                    break;
                }
                case 5: {
                    bootDevice = GlobalDefine.BootDevice.USB_KEY;
                    break;
                }
                case 6: {
                    bootDevice = GlobalDefine.BootDevice.USB_HDD;
                    break;
                }
                case 7: {
                    bootDevice = GlobalDefine.BootDevice.USB_FLOPPY;
                    break;
                }
                case 8: {
                    bootDevice = GlobalDefine.BootDevice.USB_CD_DVD;
                    break;
                }
                case 9: {
                    bootDevice = GlobalDefine.BootDevice.UEFI_USB_KEY;
                    break;
                }
                case 10: {
                    bootDevice = GlobalDefine.BootDevice.UEFI_CD_DVD;
                    break;
                }
                default: {
                    MOut.G(this).println("Parameter out of Range");
                    return;
                }
            }
            boolean boolResult = ipmiChassisCommand.setBootDeviceOption(bootDevice);
            if (!boolResult) {
                MOut.G(this).println("Set boot device failed");
                this.statusCode = 149;
            }
            if (!(boolResult = ipmiChassisCommand.keepBootFlagValidBit())) {
                MOut.G(this).println("Can't keep boot flag valid bit");
                this.statusCode = 149;
            } else {
                MOut.G(this).println("Set boot device done");
                this.statusCode = 0;
            }
        } else if (subCommand.equalsIgnoreCase("cycle")) {
            byte cycleInterval = 0;
            if (this.getParameters().length > 3) {
                cycleInterval = Byte.valueOf(this.parameters[1]);
            }
            if (cycleInterval > 0 && ipmiChassisCommand.setPowerCycleInterval(cycleInterval)) {
                MOut.G(this).println("Set power cycle interval fail");
                return;
            }
            if (ipmiChassisCommand.powerCycle()) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else if (subCommand.equalsIgnoreCase("diag")) {
            if (ipmiChassisCommand.injectNMI()) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else {
            ACPIInfo acpi = ipmiGlobalCommand.getACPI();
            MOut.G(this).println("ACPI Power Status: " + acpi.getSystemStateInfo() + " (" + acpi.getSystemStateDescription() + ")");
            this.printUsage();
            this.statusCode = 0;
        }
        sessionController.closeSession();
    }

    public void printUsage() {
        MOut.G(this).println("Available commands:");
        MOut.G(this).println("status <blade index> <node index>                  power status");
        MOut.G(this).println("up <blade index> <node index>                      power up system");
        MOut.G(this).println("down <blade index> <node index>                    power down system");
        MOut.G(this).println("softshutdown <blade index> <node index>            power softshotdown");
        MOut.G(this).println("reset <blade index> <node index>             power reset");
        MOut.G(this).println("cycle [interval] <blade index> <node index>        power cycle");
        MOut.G(this).println("diag <blade index> <node index>                    pulse diagnostic interrupt");
        MOut.G(this).println("bootoption <option> <blade index> <node index>     Force a boot device");
        MOut.G(this).println("                                                   in next boot only.");
        MOut.G(this).println("");
        MOut.G(this).println("For bootoption option :");
        MOut.G(this).println("1: PXE            2:  Hard-drive");
        MOut.G(this).println("3: CD/DVD         4:  Bios");
        MOut.G(this).println("5: USB KEY        6:  USB HDD");
        MOut.G(this).println("7: USB Floppy     8:  USB CD/DVD");
        MOut.G(this).println("9: UEFI USB KEY   10: UEFI CD/DVD");
        MOut.G(this).println("Ex: set power cycle interval as 10 seconds and execute power cycle");
        MOut.G(this).println("IPMI>microblade power cycle 10 A1 1");
    }
}

