/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMBladeModeCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        this.preParameters.remove(0);
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.G(this).println("CMM Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isConnectToCMM(cmmIndex - 1)) {
            MOut.G(this).println("This function is only available for the CMM connected");
            this.statusCode = 152;
            return;
        }
        if (this.parameters != null && this.parameters.length == 1) {
            byte bladeMode;
            String strBladeMode = this.parameters[0];
            try {
                bladeMode = (byte)Integer.parseInt(strBladeMode);
            }
            catch (NumberFormatException ex) {
                this.statusCode = 182;
                MOut.G(this).print("Parameter invalid");
                return;
            }
            if (bladeMode > 1 || bladeMode < 0) {
                this.statusCode = 182;
                MOut.G(this).print("Parameter invalid");
                return;
            }
            boolean result = this.ipmiCMMOEMCommand.setBladeMode(bladeMode);
            if (result) {
                MOut.G(this).print("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).print("Failed");
                this.statusCode = 149;
            }
        } else {
            byte bladeMode = this.ipmiCMMOEMCommand.getBladeMode();
            switch (bladeMode) {
                case 0: {
                    MOut.G(this).println("Enterprise Blade Mode");
                    break;
                }
                case 1: {
                    MOut.G(this).println("Office Blade Mode");
                    break;
                }
                default: {
                    MOut.G(this).println("Unknown");
                }
            }
            this.statusCode = 0;
        }
    }
}

