/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rcsoftkbd;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import nn.pp.rckbd.KbdFactory;
import nn.pp.rcsoftkbd.MapDef;

public abstract class KbdMapping {
    private Hashtable htmodifier = new Hashtable();
    private Hashtable imghash = new Hashtable(5);
    private MappingPrefs MappingPrefs = new MappingPrefs();

    protected abstract MapDef[] getMapDefs(Short var1);

    protected abstract String getKeyImgName(Short var1);

    protected abstract void getMappingPrefs(MappingPrefs var1);

    public abstract short getKeyImgHeight();

    public abstract Locale getLocale();

    public KbdMapping() {
        this.getMappingPrefs(this.MappingPrefs);
    }

    public int getImageXPos(int ImageIdx) {
        if (ImageIdx < this.MappingPrefs.ImageThreshold || this.MappingPrefs.ImageThreshold == 0) {
            return ImageIdx * this.MappingPrefs.ImageWidth;
        }
        return this.MappingPrefs.ImageThreshold * this.MappingPrefs.ImageWidth + (ImageIdx - this.MappingPrefs.ImageThreshold) * this.MappingPrefs.ImageExtWidth;
    }

    public Image getKeyImg(Short mod) {
        Image img = null;
        String imgname = this.getKeyImgName(mod);
        if (null != imgname && null == (img = (Image)this.imghash.get(imgname))) {
            String jvd = System.getProperty("java.vendor");
            String jvs = System.getProperty("java.version");
            if (jvs.startsWith("1.1") && (jvd.startsWith("Netscape") || jvd.startsWith("IBM"))) {
                img = this.getImageOldJava(imgname);
            } else if (jvs.startsWith("3.1")) {
                if (KbdFactory.applet_codebase != null) {
                    try {
                        URL imurl = new URL(KbdFactory.applet_codebase, "/" + imgname);
                        img = Toolkit.getDefaultToolkit().getImage(imurl);
                    }
                    catch (MalformedURLException e) {}
                }
            } else {
                URL imurl = this.getClass().getClassLoader().getResource(imgname);
                img = Toolkit.getDefaultToolkit().getImage(imurl);
            }
            if (img != null) {
                this.imghash.put(imgname, img);
            }
        }
        return img;
    }

    public boolean hasMapping(Short modifier) {
        return this.getMapDefs(modifier) != null;
    }

    public String getKeyChar(Short keynumber, Short mod) {
        Hashtable htkey = this.loadKeyTable(mod);
        MapDef map = this.getMapDef(keynumber, mod);
        if (map != null) {
            return map.keychar;
        }
        return null;
    }

    public MapDef getMapDef(Short keynumber, Short mod) {
        Hashtable htkey = this.loadKeyTable(mod);
        MapDef map = (MapDef)htkey.get(keynumber);
        return map;
    }

    public short getKeyImgIdx(Short keynumber, Short modifier) {
        Hashtable htkey = this.loadKeyTable(modifier);
        MapDef map = (MapDef)htkey.get(keynumber);
        return map.imgidx;
    }

    private Hashtable loadKeyTable(Short modifier) {
        if (!this.hasMapping(modifier)) {
            return null;
        }
        Hashtable htkey = new Hashtable();
        htkey = (Hashtable)this.htmodifier.get(modifier);
        if (null == htkey) {
            htkey = this.create_hashmap_for(modifier);
        }
        return htkey;
    }

    private Hashtable create_hashmap_for(Short modifier) {
        Hashtable<Short, MapDef> hash = new Hashtable<Short, MapDef>();
        MapDef[] map = this.getMapDefs(modifier);
        for (int i = 0; i < map.length; ++i) {
            hash.put(new Short(map[i].keynr), map[i]);
        }
        this.htmodifier.put(modifier, hash);
        return hash;
    }

    private Image getImageOldJava(String imgname) {
        Image img = null;
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(imgname);
            if (null == in) {
                return null;
            }
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            img = Toolkit.getDefaultToolkit().createImage(buffer);
        }
        catch (IOException e) {
            System.err.println("KbdMapping: getResImage: " + e);
        }
        return img;
    }

    class MappingPrefs {
        public short ImageWidth;
        public short ImageExtWidth;
        public short ImageThreshold;

        MappingPrefs() {
        }
    }
}

