/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import nn.pp.rc.RFBRenderer;
import nn.pp.rc.RFBproto;
import nn.pp.rc.T;
import nn.pp.rc.TightCacheTile;

public abstract class ByteColorRFBRenderer
extends RFBRenderer
implements ImageObserver {
    private Color[] colors;
    private int[] intcolors;
    private int[] tightLUT1BitFullColorBlackWhite;
    private int[] tightLUT2BitFullColorGrayscale;
    private int[] tightLUT4BitFullColorGrayscale;
    private int[] tightLUT4BitFullColor16Colors;
    private int[] tightLUT8BitFullColor256Colors;
    static final int sh = 16;
    static final int sw = 16;
    private Image simg;
    private MemoryImageSource simgsrc;
    private int[] simgmem;
    private byte[] simgmemb;
    static final int tightZlibBufferSize = 512;
    Inflater[] tightInflaters;
    Image timg = null;
    MemoryImageSource timgsrc;
    int[] timgmemi = null;
    byte[] timgtempb = null;
    byte[] timgtempbcache = null;
    private byte[] rimgmemb;
    private byte[] rimgtempb;
    public TightCacheTile[] tightCacheTiles;

    @Override
    public abstract void setInterpol(boolean var1);

    @Override
    public abstract void paint(Graphics var1, boolean var2, Dimension var3);

    @Override
    public abstract void repaint();

    @Override
    public abstract void sendUpdateMsg() throws IOException;

    public ByteColorRFBRenderer(Component comp) {
        super(comp);
        DirectColorModel colormodel = new DirectColorModel(8, 7, 56, 192);
        this.colors = new Color[256];
        this.intcolors = new int[256];
        for (int i = 0; i < 256; ++i) {
            int c = colormodel.getRGB(i);
            this.colors[i] = new Color(c);
            this.intcolors[i] = c;
        }
        this.simgmem = new int[256];
        this.simgmemb = new byte[256];
        this.simgsrc = new MemoryImageSource(16, 16, this.simgmem, 0, 16);
        this.simgsrc.setAnimated(true);
        this.simgsrc.setFullBufferUpdates(false);
        this.simg = comp.createImage(this.simgsrc);
        this.initTightLUTXBitFullColor();
    }

    @Override
    public void sendPixelMsg() throws IOException {
        this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
    }

    @Override
    public void setRenderSize(Dimension d) {
        super.setRenderSize(d);
        this.mysize = d;
        this.createTImg(d);
    }

    void checkRawBufSize(int newSize) {
        if (this.rimgmemb == null || this.rimgmemb.length < newSize) {
            this.rimgmemb = new byte[newSize];
        }
    }

    void checkRawTmpBufSize(int newSize) {
        if (this.rimgtempb == null || this.rimgtempb.length < newSize) {
            this.rimgtempb = new byte[newSize];
        }
    }

    @Override
    public final void drawRawRect(int x, int y, int w, int h, boolean bigEndian) throws IOException {
        int c = w * h;
        this.checkRawBufSize(c);
        this.rfb.is_rect.readFully(this.rimgmemb, 0, c);
        this.colorDecode(this.timgmemi, this.rimgmemb, y * this.mysize.width + x, w, h, this.mysize.width);
        this.timgsrc.newPixels(x, y, w, h);
        this.gvimg.setClip(x, y, w, h);
        this.gvimg.drawImage(this.timg, 0, 0, null);
        this.gvimg.setClip(0, 0, this.mysize.width, this.mysize.height);
    }

    @Override
    public final void drawRawVSCRect(int x, int y, int w, int h, boolean bigEndian) throws IOException {
        int TILE_WIDTH = 16;
        int TILE_HEIGHT = 16;
        byte flags = this.rfb.is_rect.readByte();
        if ((flags & 1) == 0) {
            this.drawRawRect(x, y, w, h, bigEndian);
            return;
        }
        int c = w * h;
        this.checkRawTmpBufSize(c);
        this.rfb.is_rect.readFully(this.rimgtempb, 0, c);
        w = Math.min(w, this.mysize.width - x);
        h = Math.min(h, this.mysize.height - y);
        c = w * h;
        this.checkRawBufSize(c);
        int indexsrc = 0;
        int indexdst = 0;
        int indexsrcstart = 0;
        int lines = 0;
        int rows = 0;
        for (int i = 0; i < h; ++i) {
            int cols = 0;
            for (int j = 0; j < w; ++j) {
                this.rimgmemb[indexdst] = this.rimgtempb[indexsrc];
                ++indexdst;
                ++indexsrc;
                if (++cols != TILE_WIDTH) continue;
                indexsrc += (TILE_HEIGHT - 1) * TILE_WIDTH;
                cols = 0;
            }
            indexsrc = indexsrcstart + ++lines * TILE_WIDTH;
            if (lines != TILE_HEIGHT) continue;
            indexsrc = indexsrcstart = ++rows * TILE_HEIGHT * w;
            lines = 0;
        }
        this.colorDecode(this.timgmemi, this.rimgmemb, y * this.mysize.width + x, w, h, this.mysize.width);
        this.timgsrc.newPixels(x, y, w, h);
        this.gvimg.setClip(x, y, w, h);
        this.gvimg.drawImage(this.timg, 0, 0, null);
        this.gvimg.setClip(0, 0, this.mysize.width, this.mysize.height);
    }

    public final void drawHextileRawRect(int x, int y, int w, int h, boolean bigEndian) throws IOException {
        int c = w * h;
        this.finishBufferedReading(this.rfb.is_rect);
        this.rfb.is_rect.readFully(this.simgmemb, 0, c);
        this.colorDecode(this.simgmem, this.simgmemb, 0, w, h, 16);
        this.simgsrc.newPixels(0, 0, w, h);
        if (h < 16 || w < 16) {
            this.gvimg.setClip(x, y, w, h);
            this.gvimg.drawImage(this.simg, x, y, x + w, y + h, 0, 0, w, h, null);
            this.gvimg.setClip(0, 0, this.mysize.width, this.mysize.height);
        } else {
            this.gvimg.drawImage(this.simg, x, y, null);
        }
    }

    @Override
    public final void drawCopyRect(int srcX, int srcY, int x, int y, int w, int h) throws IOException {
        this.gvimg.copyArea(srcX, srcY, w, h, x - srcX, y - srcY);
    }

    @Override
    public final void drawHextileRect(int x, int y, int w, int h, boolean bigEndian) throws IOException {
        int bg = 0;
        int fg = 0;
        int counter = 0;
        RFBproto rfb = this.rfb;
        Graphics gvimg = this.gvimg;
        for (int ty = y; ty < y + h; ty += 16) {
            for (int tx = x; tx < x + w; tx += 16) {
                int uh;
                int uw;
                int uy;
                int ux;
                int b2;
                int b1;
                int j;
                int tw = 16;
                int th = 16;
                if (x + w - tx < 16) {
                    tw = x + w - tx;
                }
                if (y + h - ty < 16) {
                    th = y + h - ty;
                }
                int subencoding = this.readBufferedByte(rfb.is_rect);
                ++counter;
                if ((subencoding & 1) != 0) {
                    this.drawHextileRawRect(tx, ty, tw, th, bigEndian);
                    continue;
                }
                if ((subencoding & 2) != 0) {
                    bg = this.readBufferedByte(rfb.is_rect);
                    ++counter;
                }
                gvimg.setColor(this.colors[bg]);
                gvimg.fillRect(tx, ty, tw, th);
                if ((subencoding & 4) != 0) {
                    fg = this.readBufferedByte(rfb.is_rect);
                    ++counter;
                }
                if ((subencoding & 8) == 0) continue;
                int nSubrects = this.readBufferedByte(rfb.is_rect);
                ++counter;
                gvimg.translate(tx, ty);
                if ((subencoding & 0x10) != 0) {
                    for (j = 0; j < nSubrects; ++j) {
                        fg = this.readBufferedByte(rfb.is_rect);
                        b1 = this.readBufferedByte(rfb.is_rect);
                        b2 = this.readBufferedByte(rfb.is_rect);
                        ux = b1 >> 4;
                        uy = b1 & 0xF;
                        uw = (b2 >> 4) + 1;
                        uh = (b2 & 0xF) + 1;
                        gvimg.setColor(this.colors[fg]);
                        gvimg.fillRect(ux, uy, uw, uh);
                    }
                    counter += nSubrects * 3;
                } else {
                    gvimg.setColor(this.colors[fg]);
                    for (j = 0; j < nSubrects; ++j) {
                        b1 = this.readBufferedByte(rfb.is_rect);
                        b2 = this.readBufferedByte(rfb.is_rect);
                        ux = b1 >> 4;
                        uy = b1 & 0xF;
                        uw = (b2 >> 4) + 1;
                        uh = (b2 & 0xF) + 1;
                        gvimg.fillRect(ux, uy, uw, uh);
                    }
                    counter += nSubrects * 2;
                }
                gvimg.translate(-tx, -ty);
            }
        }
        this.finishBufferedReading(rfb.is_rect);
        rfb.min.increaseCounters(counter);
    }

    @Override
    public final void drawTightRect(int x, int y, int w, int h) throws IOException {
        this.drawTightRect0(x, y, w, h, null, 0, 0, 0);
    }

    @Override
    public final void drawTightCachedRect(int x, int y, int w, int h) throws IOException {
        int comp_ctl;
        int pix_red_fac;
        int subencoding = this.rfb.is_rect.read();
        int stream_id = subencoding >> 4 & 3;
        int cache_tag = subencoding >> 4 & 0xC;
        int tightXBitFullColor = subencoding & 0xF;
        int tile_dim = 16;
        switch (tightXBitFullColor) {
            case 1: {
                pix_red_fac = 8;
                comp_ctl = 10;
                break;
            }
            case 2: {
                pix_red_fac = 4;
                comp_ctl = 11;
                break;
            }
            case 3: {
                pix_red_fac = 2;
                comp_ctl = 12;
                break;
            }
            case 4: {
                pix_red_fac = 2;
                comp_ctl = 13;
                break;
            }
            case 8: {
                pix_red_fac = 1;
                comp_ctl = 0;
                break;
            }
            default: {
                return;
            }
        }
        if (y % tile_dim != 0) {
            int y_s = (y / tile_dim + 1) * tile_dim - y;
        } else {
            boolean y_s = false;
        }
        int h_e = (y + h) % tile_dim != 0 ? (y + h) / tile_dim * tile_dim - y : h;
        int mc_t_size = w / tile_dim * (h_e / tile_dim);
        byte[] memcpy_tag = new byte[mc_t_size];
        if (mc_t_size < 12) {
            this.rfb.is_rect.readFully(memcpy_tag, 0, mc_t_size);
        } else {
            int zlibDataLen = this.rfb.readCompactLen();
            byte[] zlibData = new byte[zlibDataLen];
            this.rfb.is_rect.readFully(zlibData, 0, zlibDataLen);
            if (this.tightInflaters[stream_id] == null) {
                this.tightInflaters[stream_id] = new Inflater();
            }
            Inflater myInflater = this.tightInflaters[stream_id];
            myInflater.setInput(zlibData, 0, zlibDataLen);
            try {
                myInflater.inflate(memcpy_tag, 0, mc_t_size);
            }
            catch (DataFormatException dfe) {
                throw new IOException(dfe.toString());
            }
        }
        if (cache_tag == 0) {
            this.readCacheMetaRect(x, y, w, h, memcpy_tag, cache_tag, tile_dim, pix_red_fac);
            this.drawXBitFullColor(x, y, w, h, comp_ctl);
            this.timgsrc.newPixels(x, y, w, h);
            this.gvimg.setClip(x, y, w, h);
            this.gvimg.drawImage(this.timg, 0, 0, null);
            this.gvimg.setClip(0, 0, this.mysize.width, this.mysize.height);
        } else {
            this.drawTightRect0(x, y, w, h, memcpy_tag, cache_tag, tile_dim, pix_red_fac);
        }
    }

    public final void drawTightRect0(int x, int y, int w, int h, byte[] memcpy_tag, int cache_tag, int tile_dim, int pix_red_fac) throws IOException {
        int counter;
        int comp_ctl;
        RFBproto rfb;
        block44: {
            block43: {
                rfb = this.rfb;
                comp_ctl = rfb.is_rect.read();
                counter = 1;
                for (int stream_id = 0; stream_id < 4; ++stream_id) {
                    if ((comp_ctl & 1) != 0 && this.tightInflaters[stream_id] != null) {
                        this.tightInflaters[stream_id] = null;
                    }
                    comp_ctl >>= 1;
                }
                if (comp_ctl > 15) {
                    throw new IOException(T._("Incorrect tight subencoding:") + " " + comp_ctl);
                }
                if (comp_ctl == 8) break block43;
                if (comp_ctl != 15) break block44;
            }
            if (comp_ctl == 8) {
                this.gvimg.setColor(this.colors[rfb.is_rect.read()]);
                ++counter;
            } else {
                int bg = 0;
                switch (rfb.is_rect.read()) {
                    case 1: {
                        bg = this.tightLUT1BitFullColorBlackWhite[rfb.is_rect.read()];
                        break;
                    }
                    case 2: {
                        bg = this.tightLUT2BitFullColorGrayscale[rfb.is_rect.read()];
                        break;
                    }
                    case 3: {
                        bg = this.tightLUT4BitFullColorGrayscale[rfb.is_rect.read()];
                        break;
                    }
                    case 4: {
                        bg = this.tightLUT4BitFullColor16Colors[rfb.is_rect.read()];
                    }
                }
                this.gvimg.setColor(new Color(bg));
                counter += 2;
            }
            this.gvimg.fillRect(x, y, w, h);
            rfb.min.increaseCounters(counter);
            return;
        }
        int numColors = 0;
        int rowSize = w;
        int[] paletteXBit = new int[2];
        if ((comp_ctl | 3) == 7) {
            int b = rfb.is_rect.read();
            ++counter;
            int filter_id = b & 0xF;
            int useXBit = b >> 4 & 0xF;
            if (filter_id == 1) {
                numColors = rfb.is_rect.read() + 1;
                ++counter;
                if (numColors != 2) {
                    throw new IOException(T._("Incorrect tight palette size:") + " " + numColors);
                }
                switch (useXBit) {
                    case 1: {
                        b = rfb.is_rect.read();
                        ++counter;
                        paletteXBit[0] = this.tightLUT1BitFullColorBlackWhite[b >> 1];
                        paletteXBit[1] = this.tightLUT1BitFullColorBlackWhite[b & 1];
                        break;
                    }
                    case 2: {
                        b = rfb.is_rect.read();
                        ++counter;
                        paletteXBit[0] = this.tightLUT2BitFullColorGrayscale[b >> 2];
                        paletteXBit[1] = this.tightLUT2BitFullColorGrayscale[b & 3];
                        break;
                    }
                    case 3: {
                        b = rfb.is_rect.read();
                        ++counter;
                        paletteXBit[0] = this.tightLUT4BitFullColorGrayscale[b >> 4];
                        paletteXBit[1] = this.tightLUT4BitFullColorGrayscale[b & 0xF];
                        break;
                    }
                    case 4: {
                        b = rfb.is_rect.read();
                        ++counter;
                        paletteXBit[0] = this.tightLUT4BitFullColor16Colors[b >> 4];
                        paletteXBit[1] = this.tightLUT4BitFullColor16Colors[b & 0xF];
                        break;
                    }
                    default: {
                        paletteXBit[0] = this.tightLUT8BitFullColor256Colors[rfb.is_rect.read()];
                        paletteXBit[1] = this.tightLUT8BitFullColor256Colors[rfb.is_rect.read()];
                        counter += 2;
                    }
                }
                rowSize = (w + 7) / 8;
            } else if (filter_id != 0) {
                throw new IOException(T._("Incorrect tight filter id:") + " " + filter_id);
            }
        } else {
            switch (comp_ctl) {
                case 10: {
                    rowSize = (w + 7) / 8;
                    break;
                }
                case 11: {
                    rowSize = (w + 3) / 4;
                    break;
                }
                case 12: 
                case 13: {
                    rowSize = (w + 1) / 2;
                }
            }
        }
        int dataSize = h * rowSize;
        if (dataSize < 12) {
            if (numColors == 2) {
                byte[] monoData = new byte[dataSize];
                rfb.is_rect.readFully(monoData, 0, dataSize);
                this.drawMonoData(x, y, w, h, monoData, paletteXBit);
            } else {
                rfb.is_rect.readFully(this.timgtempb, 0, dataSize);
                this.drawXBitFullColor(x, y, w, h, comp_ctl);
            }
        } else {
            int zlibDataLen = rfb.readCompactLen();
            byte[] zlibData = new byte[zlibDataLen];
            rfb.is_rect.readFully(zlibData, 0, zlibDataLen);
            int stream_id = (comp_ctl & 8) != 0 ? 0 : comp_ctl & 3;
            if (this.tightInflaters[stream_id] == null) {
                this.tightInflaters[stream_id] = new Inflater();
            }
            Inflater myInflater = this.tightInflaters[stream_id];
            myInflater.setInput(zlibData, 0, zlibDataLen);
            try {
                if (numColors == 2) {
                    byte[] monoData = new byte[dataSize];
                    myInflater.inflate(monoData, 0, dataSize);
                    this.drawMonoData(x, y, w, h, monoData, paletteXBit);
                } else {
                    myInflater.inflate(this.timgtempb, 0, dataSize);
                    if (memcpy_tag != null) {
                        this.readCacheMetaRect(x, y, w, h, memcpy_tag, cache_tag, tile_dim, pix_red_fac);
                    }
                    this.drawXBitFullColor(x, y, w, h, comp_ctl);
                }
            }
            catch (DataFormatException dfe) {
                throw new IOException(dfe.toString());
            }
        }
        this.timgsrc.newPixels(x, y, w, h);
        this.gvimg.setClip(x, y, w, h);
        this.gvimg.drawImage(this.timg, 0, 0, null);
        this.gvimg.setClip(0, 0, this.mysize.width, this.mysize.height);
        rfb.min.increaseCounters(counter);
    }

    public void readCacheMetaRect(int x, int y, int w, int h, byte[] memcpy_tag, int cache_tag, int tile_dim, int pix_red_fac) {
        int mc_pos = 0;
        int y_s = y % tile_dim != 0 ? (y / tile_dim + 1) * tile_dim - y : 0;
        int h_e = (y + h) % tile_dim != 0 ? (y + h) / tile_dim * tile_dim - y : h;
        if (cache_tag == 8) {
            int j;
            byte[] src = this.timgtempb;
            byte[] dst = this.timgtempbcache;
            if (y_s != 0) {
                System.arraycopy(src, 0, dst, 0, y_s * w / pix_red_fac);
                mc_pos += y_s * w / pix_red_fac;
            }
            for (j = y_s; j < h_e; j += tile_dim) {
                for (int k = 0; k < tile_dim; ++k) {
                    for (int i = 0; i < w; i += tile_dim) {
                        byte mc_t = memcpy_tag[j / tile_dim * (w / tile_dim) + i / tile_dim];
                        int client_index = mc_t & 0x7F;
                        if ((mc_t & 0x80) == 0) {
                            this.tightCacheTiles[(y + j) / tile_dim * (this.mysize.width / tile_dim) + (x + i) / tile_dim].saveDataStream(client_index, k * (tile_dim / pix_red_fac), tile_dim / pix_red_fac, src, mc_pos);
                            mc_pos += tile_dim / pix_red_fac;
                        }
                        this.tightCacheTiles[(y + j) / tile_dim * (this.mysize.width / tile_dim) + (x + i) / tile_dim].restoreDataStream(client_index, k * (tile_dim / pix_red_fac), tile_dim / pix_red_fac, dst, ((j + k) * w + i) / pix_red_fac);
                    }
                }
            }
            if (h_e != h) {
                System.arraycopy(src, mc_pos, dst, j * w / pix_red_fac, (h - h_e) * w / pix_red_fac);
                mc_pos += (h - h_e) * w / pix_red_fac;
            }
            System.arraycopy(dst, 0, src, 0, w * h / pix_red_fac);
        } else if (cache_tag == 4) {
            byte[] src = this.timgtempb;
            for (int j = y_s; j < h_e; j += tile_dim) {
                for (int i = 0; i < w; i += tile_dim) {
                    int client_index = memcpy_tag[j / tile_dim * (w / tile_dim) + i / tile_dim] & 0x7F;
                    for (int k = 0; k < tile_dim; ++k) {
                        this.tightCacheTiles[(y + j) / tile_dim * (this.mysize.width / tile_dim) + (x + i) / tile_dim].saveDataStream(client_index, k * (tile_dim / pix_red_fac), tile_dim / pix_red_fac, src, ((j + k) * w + i) / pix_red_fac);
                    }
                }
            }
        } else {
            byte[] dst = this.timgtempb;
            for (int j = 0; j < h; j += tile_dim) {
                for (int i = 0; i < w; i += tile_dim) {
                    int client_index = memcpy_tag[j / tile_dim * (w / tile_dim) + i / tile_dim] & 0x7F;
                    for (int k = 0; k < tile_dim; ++k) {
                        this.tightCacheTiles[(y + j) / tile_dim * (this.mysize.width / tile_dim) + (x + i) / tile_dim].restoreDataStream(client_index, k * (tile_dim / pix_red_fac), tile_dim / pix_red_fac, dst, ((j + k) * w + i) / pix_red_fac);
                    }
                }
            }
        }
    }

    @Override
    public void dispose() {
        if (this.timg != null) {
            this.timg.flush();
        }
        this.simg.flush();
        if (this.vimg != null) {
            this.vimg.flush();
        }
        if (this.gvimg != null) {
            this.gvimg.dispose();
        }
    }

    private final void drawMonoData(int x, int y, int w, int h, byte[] src, int[] paletteXBit) throws IOException {
        int[] dst = this.timgmemi;
        int i = y * this.rfb.framebufferWidth + x;
        int index2 = 0;
        int rowBytes = (w + 7) / 8;
        for (int dy = 0; dy < h; ++dy) {
            int n;
            int b;
            int dx;
            index2 = dy * rowBytes;
            for (dx = 0; dx < w / 8; ++dx) {
                b = src[index2 + dx] & 0xFF;
                for (n = 7; n >= 0; --n) {
                    dst[i++] = paletteXBit[b >> n & 1];
                }
            }
            for (n = 7; n >= 8 - w % 8; --n) {
                b = src[index2 + dx] & 0xFF;
                dst[i++] = paletteXBit[b >> n & 1];
            }
            i += this.rfb.framebufferWidth - w;
        }
    }

    private final void drawXBitFullColor(int x, int y, int w, int h, int comp_ctl) throws IOException {
        int fb_width = this.rfb.framebufferWidth;
        int index = y * fb_width + x;
        int index2 = 0;
        byte[] src = this.timgtempb;
        int[] dst = this.timgmemi;
        switch (comp_ctl) {
            case 10: {
                int[] lut = this.tightLUT1BitFullColorBlackWhite;
                int wDiv = w / 8;
                int wMod = w % 8;
                for (int j = 0; j < h; ++j) {
                    int s;
                    byte b;
                    for (int i = 0; i < wDiv; ++i) {
                        b = src[index2++];
                        for (s = 7; s >= 0; --s) {
                            dst[index++] = lut[b >> s & 1];
                        }
                    }
                    if (wMod != 0) {
                        b = src[index2++];
                        for (s = wMod; s > 0; --s) {
                            dst[index++] = lut[b >> s & 1];
                        }
                    }
                    index += fb_width - w;
                }
                break;
            }
            case 11: {
                int[] lut = this.tightLUT2BitFullColorGrayscale;
                int wDiv = w / 4;
                int wMod = w % 4;
                for (int j = 0; j < h; ++j) {
                    int s;
                    byte b;
                    for (int i = 0; i < wDiv; ++i) {
                        b = src[index2++];
                        for (s = 6; s >= 0; s -= 2) {
                            dst[index++] = lut[b >> s & 3];
                        }
                    }
                    if (wMod != 0) {
                        b = src[index2++];
                        for (s = wMod; s > 0; --s) {
                            dst[index++] = lut[b >> 2 * s & 3];
                        }
                    }
                    index += fb_width - w;
                }
                break;
            }
            case 12: 
            case 13: {
                int[] lut = comp_ctl == 13 ? this.tightLUT4BitFullColor16Colors : this.tightLUT4BitFullColorGrayscale;
                int wDiv = w / 2;
                int wMod = w % 2;
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < wDiv; ++i) {
                        byte b = src[index2++];
                        dst[index++] = lut[b >> 4 & 0xF];
                        dst[index++] = lut[b & 0xF];
                    }
                    if (wMod != 0) {
                        dst[index++] = lut[src[index2++] >> 4 & 0xF];
                    }
                    index += fb_width - w;
                }
                break;
            }
            default: {
                int[] lut = this.tightLUT8BitFullColor256Colors;
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < w; ++i) {
                        dst[index++] = lut[src[index2++] & 0xFF];
                    }
                    index += fb_width - w;
                }
            }
        }
    }

    private void createTImg(Dimension d) {
        Dimension padsize = new Dimension(d);
        if (padsize.width % 16 != 0) {
            padsize.width = (padsize.width / 16 + 1) * 16;
        }
        if (padsize.height % 16 != 0) {
            padsize.height = (padsize.height / 16 + 1) * 16;
        }
        if (this.tightInflaters == null) {
            this.tightInflaters = new Inflater[4];
            this.timgtempb = new byte[65536];
            this.timgtempbcache = new byte[65536];
        }
        if (this.timg != null) {
            this.timg.flush();
        }
        this.timgmemi = new int[padsize.width * padsize.height];
        this.jimgsrc = this.timgsrc = new MemoryImageSource(this.mysize.width, this.mysize.height, this.timgmemi, 0, this.mysize.width);
        this.timgsrc.setAnimated(true);
        this.timgsrc.setFullBufferUpdates(false);
        this.timg = this.comp.createImage(this.timgsrc);
    }

    private final void colorDecode(int[] px32, byte[] px8, int off, int w, int h, int scanline) {
        int index_src = 0;
        int index_dst = off;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int px = this.intcolors[0xFF & px8[index_src++]];
                px32[index_dst++] = px;
            }
            index_dst += scanline - w;
        }
    }

    private final void initTightLUTXBitFullColor() {
        this.tightLUT1BitFullColorBlackWhite = new int[2];
        this.tightLUT2BitFullColorGrayscale = new int[4];
        this.tightLUT4BitFullColorGrayscale = new int[16];
        this.tightLUT4BitFullColor16Colors = new int[16];
        this.tightLUT8BitFullColor256Colors = this.intcolors;
        this.tightLUT1BitFullColorBlackWhite[0] = new Color(0, 0, 0).getRGB();
        this.tightLUT1BitFullColorBlackWhite[1] = new Color(255, 255, 255).getRGB();
        this.tightLUT2BitFullColorGrayscale[0] = new Color(0, 0, 0).getRGB();
        this.tightLUT2BitFullColorGrayscale[1] = new Color(128, 128, 128).getRGB();
        this.tightLUT2BitFullColorGrayscale[2] = new Color(192, 192, 192).getRGB();
        this.tightLUT2BitFullColorGrayscale[3] = new Color(255, 255, 255).getRGB();
        this.tightLUT4BitFullColorGrayscale[0] = new Color(0, 0, 0).getRGB();
        this.tightLUT4BitFullColorGrayscale[1] = new Color(33, 33, 33).getRGB();
        this.tightLUT4BitFullColorGrayscale[2] = new Color(50, 50, 50).getRGB();
        this.tightLUT4BitFullColorGrayscale[3] = new Color(67, 67, 67).getRGB();
        this.tightLUT4BitFullColorGrayscale[4] = new Color(92, 92, 92).getRGB();
        this.tightLUT4BitFullColorGrayscale[5] = new Color(105, 105, 105).getRGB();
        this.tightLUT4BitFullColorGrayscale[6] = new Color(117, 117, 117).getRGB();
        this.tightLUT4BitFullColorGrayscale[7] = new Color(134, 134, 134).getRGB();
        this.tightLUT4BitFullColorGrayscale[8] = new Color(151, 151, 151).getRGB();
        this.tightLUT4BitFullColorGrayscale[9] = new Color(163, 163, 163).getRGB();
        this.tightLUT4BitFullColorGrayscale[10] = new Color(178, 178, 178).getRGB();
        this.tightLUT4BitFullColorGrayscale[11] = new Color(193, 193, 193).getRGB();
        this.tightLUT4BitFullColorGrayscale[12] = new Color(209, 209, 209).getRGB();
        this.tightLUT4BitFullColorGrayscale[13] = new Color(226, 226, 226).getRGB();
        this.tightLUT4BitFullColorGrayscale[14] = new Color(79, 79, 79).getRGB();
        this.tightLUT4BitFullColorGrayscale[15] = new Color(255, 255, 255).getRGB();
        this.tightLUT4BitFullColor16Colors[0] = new Color(0, 0, 0).getRGB();
        this.tightLUT4BitFullColor16Colors[1] = new Color(128, 0, 0).getRGB();
        this.tightLUT4BitFullColor16Colors[2] = new Color(255, 0, 0).getRGB();
        this.tightLUT4BitFullColor16Colors[3] = new Color(0, 128, 0).getRGB();
        this.tightLUT4BitFullColor16Colors[4] = new Color(128, 128, 0).getRGB();
        this.tightLUT4BitFullColor16Colors[5] = new Color(255, 255, 0).getRGB();
        this.tightLUT4BitFullColor16Colors[6] = new Color(0, 255, 0).getRGB();
        this.tightLUT4BitFullColor16Colors[7] = new Color(0, 0, 128).getRGB();
        this.tightLUT4BitFullColor16Colors[8] = new Color(128, 0, 128).getRGB();
        this.tightLUT4BitFullColor16Colors[9] = new Color(0, 128, 128).getRGB();
        this.tightLUT4BitFullColor16Colors[10] = new Color(128, 128, 128).getRGB();
        this.tightLUT4BitFullColor16Colors[11] = new Color(192, 192, 192).getRGB();
        this.tightLUT4BitFullColor16Colors[12] = new Color(255, 0, 255).getRGB();
        this.tightLUT4BitFullColor16Colors[13] = new Color(0, 255, 255).getRGB();
        this.tightLUT4BitFullColor16Colors[14] = new Color(255, 255, 255).getRGB();
        this.tightLUT4BitFullColor16Colors[15] = new Color(0, 0, 255).getRGB();
    }

    @Override
    public void setNewTightCacheSize() {
        if (this.rfb.profile.encoding.isTightCacheUsed()) {
            if (this.tightCacheTiles != null) {
                this.deinitTightCache();
                System.gc();
            }
            this.initTightCache();
        }
    }

    @Override
    public void enableTightCache(boolean enable) {
        if (enable) {
            if (this.tightCacheTiles == null) {
                this.initTightCache();
            }
        } else if (this.tightCacheTiles != null) {
            this.deinitTightCache();
        }
    }

    public void initTightCache() {
        int tightCacheTilesSize = this.rfb.framebufferWidthPadded / 16 * (this.rfb.framebufferHeightPadded / 16);
        this.tightCacheTiles = new TightCacheTile[tightCacheTilesSize];
        for (int i = 0; i < tightCacheTilesSize; ++i) {
            this.tightCacheTiles[i] = new TightCacheTile(8, 16 * 16);
        }
    }

    public void deinitTightCache() {
        this.tightCacheTiles = null;
    }

    @Override
    public void drawLRLERect(long encoding, int x, int y, int w, int h) throws IOException {
        throw new IOException(T._("Byte color LRLE encoding not implemented"));
    }
}

