/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.lic.License;
import com.supermicro.ipmi.lic.SWKeyExpiredException;
import com.supermicro.ipmi.lic.SWLicenseAdapter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class WSISOUmount
extends SuperBladeCommand {
    byte deviceID = 0;

    @Override
    public boolean preValidate() {
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        boolean isTwitterOEMProject = false;
        if (GlobalDefine.OOB_PROJECT_TWITTER_BYPASS) {
            isTwitterOEMProject = License.confirmIsTwitterOEMProject(this.config);
        }
        this.closeSessionIfExist();
        boolean isPassSWKey = false;
        if (!isTwitterOEMProject) {
            try {
                if (SWLicenseAdapter.isSWFRUSupported(this.config) && SWLicenseAdapter.check_SFT_SUM_LIC_ProductKey(this.config)) {
                    isPassSWKey = true;
                }
            }
            catch (SWKeyExpiredException e) {
                MOut.G(this).println("Node product key is expired");
                this.statusCode = 155;
                return;
            }
        }
        this.createSession();
        if (!isTwitterOEMProject && !isPassSWKey && this.checkIfSWProductKeyNotActivated()) {
            MOut.G(this).println("The node product key needs to be activated for this device");
            this.statusCode = 153;
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            ipmiOEMWebSettingCommand.umountISO();
            this.statusCode = 0;
            MOut.G(this).println("Done");
        }
        catch (IPMIException e) {
            if (e.getIPMIMessage().completionCode == -43) {
                MOut.G(this).println("Please activate SFT-OOB-LIC node product key for this command");
                this.statusCode = 153;
                return;
            }
            MOut.G(this).println("This device doesn't support WSISO commands");
            this.statusCode = 153;
            return;
        }
    }
}

