// *************************************************************************
// *                         Cinematix Studios                             *
// *                     Brain Dead MOD Player Code                        *
// *                             demo.cpp                                  *
// *************************************************************************

#include <windows.h>
#include <mmsystem.h>

// *********************************
// * Some Easy MIDAS MCI functions *
// *********************************

// Note:
//
// There are currently NO extra messages or parameters defined for the MIDAS
// MCI driver.  MIDAS currently responds to only the basic ELEMENT (i.e. file)
// based MCI commands, including MCI_OPEN, MCI_SET, MCI_STATUS, etc.


static int moddevice = 0;
static BOOL modplaying = FALSE;


BOOL PlayMIDAS(char *file, HWND notifyhwnd = NULL)
{
	MCI_OPEN_PARMS mciOpenParms;
	MCI_PLAY_PARMS mciPlayParms;

	if (modplaying)
	{
		mciSendCommand(moddevice, MCI_CLOSE, 0, NULL);
		modplaying = FALSE;
		return FALSE;
	}

  // Open device
	mciOpenParms.lpstrDeviceType = "modplayer";
	mciOpenParms.lpstrElementName = file;
	if (mciSendCommand(NULL, MCI_OPEN,
	  MCI_OPEN_TYPE | MCI_OPEN_ELEMENT, (DWORD)(LPVOID)&mciOpenParms))
		return FALSE;

  // Get device id
	moddevice = mciOpenParms.wDeviceID;

  // Begin playing
	mciPlayParms.dwCallback = (DWORD)notifyhwnd;
	DWORD flags;
	if (notifyhwnd)
		flags = MCI_NOTIFY;
	else
		flags = 0;
	if (mciSendCommand(moddevice, MCI_PLAY, flags,
		(DWORD)(LPVOID) &mciPlayParms))
	{
		mciSendCommand(moddevice, MCI_CLOSE, 0, NULL);
		return FALSE;
	}

	modplaying = TRUE;
	return TRUE;
}

void StopMIDAS()
{
	if (modplaying)
	{
		mciSendCommand(moddevice, MCI_CLOSE, 0, NULL);
		modplaying = FALSE;
	}
}

BOOL IsMIDASPlaying()
{
	return modplaying;
}

// *************************************
// * A Sample Brain Dead Module Player *
// *************************************

int PASCAL WinMain(HINSTANCE, HINSTANCE, LPSTR lpCmdLine, int)
{
	char buf[80];

	if (lpCmdLine == NULL || *lpCmdLine == NULL)
	{
		MessageBox(NULL, "Please specify a module file on the command line!",
			"Brain Dead MOD Player", MB_ICONEXCLAMATION | MB_OK);
	}
	else
	{
		if (!PlayMIDAS(lpCmdLine))
		{
			MessageBox(NULL, "Can't open MIDAS (Where are you MIDAS)",
				"Brain Dead Error", MB_ICONEXCLAMATION | MB_OK);
			return 1;
		}
		wsprintf(buf, "Now playing %s", lpCmdLine);
		MessageBox(NULL, buf, "Brain Dead MOD Player", MB_OK);
		StopMIDAS();
	}

	return 0;
}
void main() {}

