/*------------------------------------------
   ABOUT1.C -- About Box Demo Program No. 1
	       (c) Charles Petzold, 1992
  ------------------------------------------*/

#include "tstmci.h"


WORD    gwDevId;

long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG) ;
BOOL FAR PASCAL _export DialogProc (HWND, UINT, UINT, LONG);
BYTE   gbOpened = 0;


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                   LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName [] = "TstMCI" ;
     MSG         msg;
     HWND        hwnd ;
     WNDCLASS    wndclass ;

     if (!hPrevInstance) 
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = DLGWINDOWEXTRA ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateDialog (hInstance, szAppName, 0, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd); 

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg);
          DispatchMessage (&msg);
          }
     return msg.wParam;
     }

long FAR PASCAL _export WndProc (HWND hDlg, UINT message, UINT wParam,
                                 LONG lParam)
{
	char		achFileName[128];
	DWORD		dwStatus = 0;
	HDC		hDevContext;

   switch (message)
   {

      case WM_COMMAND :
         switch (wParam)
         {
             case IDN_OPEN:
                  if ( ( dwStatus = DvmciOpen() ) == 0 )
                    gbOpened = TRUE;
                  return TRUE ;

             case IDN_CLOSE:
						if ( !gbOpened )
						{
                     MessageBox( hDlg,
                     "DVMCI must be opened before executing CLOSE",
                     "DVMCI NOT OPENED",
                     MB_OK | MB_ICONEXCLAMATION );
							return TRUE;
						}
                  DvmciClose();
                  gbOpened = FALSE;
                  return TRUE ;

/*             case IDN_LOAD:
						if ( !gbOpened )
						{
                     MessageBox( hDlg,
                     "DVMCI must be opened before executing LOAD",
                     "DVMCI NOT OPENED",
                     MB_OK | MB_ICONEXCLAMATION );
							return TRUE;
						}
                  GetWindowText(GetDlgItem(hDlg, IDN_TEXT1), 
                                 (LPSTR)achFileName,128);
						if ( achFileName[0] == NULL )
						{
                     MessageBox( hDlg,
                     "Give a valid MPEG path and filename in the parameter box",
                     "NO FILENAME SPECIFIED",
                     MB_OK | MB_ICONEXCLAMATION );
							strcpy(achFileName, "*.mpg");
   	               SetWindowText(GetDlgItem(hDlg, IDN_TEXT1), 
                                 (LPSTR)achFileName);
                     return TRUE;
						}

                  DvmciLoad((LPSTR) achFileName);
                  return TRUE ;
*/
             case IDN_PLAY:
						if ( !gbOpened )
						{
                     MessageBox( hDlg,
                     "DVMCI must be opened before executing PLAY",
                     "DVMCI NOT OPENED",
                     MB_OK | MB_ICONEXCLAMATION );
							return TRUE;
						}
                  DvmciPlay();
                  return TRUE ;
				
/*             case IDN_PAUSE:
						if ( !gbOpened )
						{
                     MessageBox( hDlg,
                     "DVMCI must be opened before executing PAUSE",
                     "DVMCI NOT OPENED",
                     MB_OK | MB_ICONEXCLAMATION );
							return TRUE;
						}
                  DvmciPause();
                  return TRUE ;

             case IDN_SEEK:
						if ( !gbOpened )
						{
                     MessageBox( hDlg,
                     "DVMCI must be opened before executing SEEK",
                     "DVMCI NOT OPENED",
                     MB_OK | MB_ICONEXCLAMATION );
							return TRUE;
						}
                  DvmciSeek();
                  return TRUE ;

             case IDN_STOP:
						if ( !gbOpened )
						{
                     MessageBox( hDlg,
                     "DVMCI must be opened before executing STOP",
                     "DVMCI NOT OPENED",
                     MB_OK | MB_ICONEXCLAMATION );
							return TRUE;
						}
                  DvmciStop();
                  return TRUE ;
*/
             case IDN_QUIT:
                  if (gbOpened)
                  {
                     MessageBox( hDlg,
                     "Close DVMCI before exit",
                     "DVMCI NOT CLOSED",
                     MB_OK | MB_ICONEXCLAMATION );
                     return TRUE;
                  }
                  PostQuitMessage (0) ;
                  return TRUE ;

         }
         return TRUE ;

      case WM_DESTROY:
         if (gbOpened)
            {
            MessageBox( hDlg,
            "Close DVMCI before exit",
            "DVMCI NOT CLOSED",
            MB_OK | MB_ICONEXCLAMATION );
            DvmciClose();
            }
         PostQuitMessage (0) ;
         return TRUE ;

   }
   return DefWindowProc (hDlg, message, wParam, lParam) ;
}
