/*****************************************************************/
/*                          UTILS.C                              */
/*****************************************************************/
/*
*  By:		Michel Pelletier
*		Matrox Electronic Systems ltd.
*
*  Date:	May 4, 1993
*
*  Synopsys:	This file contains utility functions for the GRABTEST
*		program.
*
*  Copyright (C) 1993.  Matrox Electronic Systems, Ltd.
*  All rights reserved
*/
/*****************************************************************/

/************************/
/* Inclusion statements */
/************************/
#include <grabtest.h>

/*********************************/
/* Global and external variables */
/*********************************/
extern	LABEL 		label[];
extern	int		process_flag, grab_source, grab_destination, grabbing_mode;
extern	int		handle, OVRLocation;
extern	long		exposure, transfer;
extern	short		roix, roiy, interlace;
extern	signed long	blackref, whiteref;
extern	unsigned long	gain;

/*--------------------------------------------*/
/* This function is for stopping any on-going */
/* processing operation.                      */
/*--------------------------------------------*/
void StopTheProcess( void )
{
pchlprocess();
HostWait4Proc;
process_flag = OFF;
}

/*---------------------------------------------*/
/* This function is for starting the requested */
/* processing operation.                       */
/*-------------------------------------------*/
void StartTheProcess( void )
{
if( label[B_F9].log_state == ENABLED )
	{
	process_flag = ON;
	}
}

/*---------------------------------------------------------------*/
/* This function grabs the specified number of frames into the   */
/* Image-Series frame buffer.  The number of frames to grab is   */
/* specified with the 'loop_count' parameter.  If this parameter */
/* is equal to 0, grabbing will be done continuously.            */
/*---------------------------------------------------------------*/
void GrabImages( int loop_count )
{
pcslsync( I_PROC_CAMERA );
dislgain( gain );
distrefwhite( whiteref );
distrefblack( blackref );
if( label[B_F8].log_state == ENABLED )	/* Smoothing enabled */
	{
	pcstroisiz( min( roix, 1980 ), roiy );		/* Set ROI xsize to the maximum */
							/* allowablw xsize for a        */
							/* neighberhood operation.      */
	if( loop_count )
		{
		pcstcond( 0, I_FOR, (1 + interlace) * loop_count );
		}
	else
		{
		pcstcond( 0, I_FOREVER, 0 );
		}
	/*=============================*/
	/* Set up proper grabbing mode */
	/*=============================*/
	switch( grabbing_mode )
		{
		case NORMAL:
		break;

		case SOFTTRIG:
		distexposure( I_SOFTTRIG, exposure, transfer );
		break;

		case TTL_HARDTRIG:
		case OPTO_HARDTRIG:
		disngrab();
		break;
		}
	nbdornoise( grab_source, grab_destination, 5 );
	pcstroisiz( roix, roiy );			/* Restore ROI size */
	}
else							/* Smoothing disabled */
	{
	if( loop_count )
		{
		pcstcond( 0, I_FOR, (1 + interlace) * loop_count );
		}
	else
		{
		pcstcond( 0, I_FOREVER, 0 );
		}
	/*=============================*/
	/* Set up proper grabbing mode */
	/*=============================*/
	switch( grabbing_mode )
		{
		case NORMAL:
		break;

		case SOFTTRIG:
		distexposure( I_SOFTTRIG, exposure, transfer );
		break;

		case TTL_HARDTRIG:
		case OPTO_HARDTRIG:
		disngrab();
		break;
		}
	didograb( grab_source, grab_destination );
	}
HostWait4All;
}

/*****************************************************************************/
/* CtrlC_Handler()
* CtrlC_Handler is used to exit from the GRABTEST program when the <CTRL><C>
* combination is activated by the user.
*
* Designed by: Henry Hurdon      Date: Mar.  26, 1990
* Reviewed by: ................. Date: ..............
* Modified: Michel Pelletier Date: May 4, 1993
*
*/

void CtrlC_Handler( int signal_num )
{
/* ignore further signals */
signal( signal_num, SIG_IGN );

/* return system to original state */
DeinitMouse();
if( OVRLocation == IM_OVERLAY )
   {
   /******************************************************/
   /* Use Image-Shell graphics functions for drawing in  */
   /* the IM-1280 or IM-640 overlay frame buffer         */
   /******************************************************/
   }
else
   {
   /*****************************************************/
   /* Use Microsoft C graphics functions for drawing in */
   /* the VGA's frame buffer.                           */
   /*****************************************************/
   _setvideomode( _DEFAULTMODE );
   }
lsdcstrdmask( 0x3ff, 0x3ff, 0x3ff, 0, 0, 0 );
lsdcstvgamode( I_NOVGA );
iorlmemdevice( handle );
iocldevice( handle );
}


/*============================================*/
/* This function is for exiting from GRABTEST */
/*============================================*/
void Termination( void )
{
DeinitMouse();
if( OVRLocation == IM_OVERLAY )
   {
   /******************************************************/
   /* Use Image-Shell graphics functions for drawing in  */
   /* the IM-1280 or IM-640 overlay frame buffer         */
   /******************************************************/
   }
else
   {
   /*****************************************************/
   /* Use Microsoft C graphics functions for drawing in */
   /* the VGA's frame buffer.                           */
   /*****************************************************/
   _setvideomode( _DEFAULTMODE );
   }
lsdcstrdmask( 0x3ff, 0x3ff, 0x3ff, 0, 0, 0 );
lsdcstvgamode( I_NOVGA );
iorlmemdevice( handle );
iocldevice( handle );
exit( 0 );
}
                                                                                 