.AUTODEPEND

# Makefile to build Image-1280 DLL
# library made : image floating point , fpu.lib, fpu.dll

# Path for library
.PATH.dll = ..\..\library\bcdll
.PATH.lib = ..\..\library\bcdll

# Path for the sources
.PATH.c = ..\..\fpu

# Path for the include and lib files
LIB   = I:\BC3.1\LIB
INC   = I:\BC3.1\INCLUDE
CBINC = ..\..\include

# Path for object files
.PATH.obj = ..\..\obj\bcdll\fpu

#       *Translator Definitions*
CC = bcc +FPU.CFG
RC = rc
TASM = TASM
TLINK = tlink


# C compiler flags
CFLAGS =

#       *Implicit Rules*
.asm.obj:
    TASM -m1 -DPASCAL $<, $(.PATH.obj)\$&

.c.obj:
    $(CC) -c $(CFLAGS) -o$(.PATH.obj)\$& {$< }

.rc.res:
    $(RC) -r -I$(INC) {$< }

# objects modules for the image floating point library
FPUOBJ = dllshell.obj \
         cvfltint.obj \
         dofft1d.obj \
         dofft2d.obj \
         cvrecpol.obj \
         doarithm.obj \
         dfpersp.obj \
         dlfpucod.obj \
         dfgtran.obj \
         dogtran.obj \
         dopersp.obj \
         doptgtra.obj \
         pcfpufor.obj \
         v2mdid.obj \
         v2mdset.obj \
         v2mdorg.obj \
         v2mdrot.obj \
         arithcte.obj

#		*Explicit Rules*
fpu.dll: fpu.cfg fpu.res $(FPUOBJ)
  $(TLINK) /v/s/c/Twd/P-/C/L$(LIB) @&&|
c0ds.obj+
$(.PATH.obj)\dllshell.obj+
$(.PATH.obj)\cvfltint.obj+
$(.PATH.obj)\dofft1d.obj+
$(.PATH.obj)\dofft2d.obj+
$(.PATH.obj)\cvrecpol.obj+
$(.PATH.obj)\doarithm.obj+
$(.PATH.obj)\dfpersp.obj+
$(.PATH.obj)\dlfpucod.obj+
$(.PATH.obj)\dfgtran.obj+
$(.PATH.obj)\dogtran.obj+
$(.PATH.obj)\dopersp.obj+
$(.PATH.obj)\doptgtra.obj+
$(.PATH.obj)\pcfpufor.obj+
$(.PATH.obj)\v2mdid.obj+
$(.PATH.obj)\v2mdset.obj+
$(.PATH.obj)\v2mdorg.obj+
$(.PATH.obj)\v2mdrot.obj+
$(.PATH.obj)\arithcte.obj
$(.PATH.dll)\fpu.dll
fpu.map
import.lib+
$(.PATH.lib)\imdrv.lib+
cwc.lib+
mathwc.lib
fpu.def
|
  $(RC) -30 fpu.res $(.PATH.dll)\fpu.dll
  IMPLIB $(.PATH.lib)\fpu.LIB $(.PATH.dll)\fpu.DLL
  IMPDEF fpu.dex $(.PATH.dll)\fpu.dll
  TDSTRIP -s $(.PATH.dll)\fpu.DLL

dllshell.obj: .\dllshell.c
    $(CC) -c $(CFLAGS) -o$(.PATH.obj)\dllshell.obj dllshell.c

#       *Compiler Configuration File*
fpu.cfg: fpu.mak
  copy &&|
-w
-ms!
-v
-2
-G
-O
-p
-d
-WD
-I$(INC);$(CBINC)
-L$(LIB)
-DANSI;I_USE_ASM;IMDLL
-DI_WINDOWS
| fpu.cfg
