#
# make file to build the IM-1280 C-binding libraries under Microsoft C 5.1
#
# library made : fpu large model, fpu_l.lib

# Path for the destination libraries
LIBPATH = ..\..\library\msc

# Path for the sources
SRCPATH = ..\..\fpu

# Path for the include files
INC = ..\..\include

# Path for object files
OBJ = ..\..\obj\msc\fpu

# Librarie name
LIBNAME = fpu_l

# C compiler
CC = cl

# C compiler flags
CFLAGS = -c -Zp1 -AL -G2 /W3 /I$(INC)

# librarian
LIB = lib

# librarian flags
LFLAGS =

# objects modules for the image floating point library
FPUOBJ1 = $(OBJ)\cvfltint.obj \
          $(OBJ)\dofft1d.obj \
          $(OBJ)\dofft2d.obj \
          $(OBJ)\cvrecpol.obj \
          $(OBJ)\doarithm.obj \
          $(OBJ)\dfpersp.obj \
          $(OBJ)\dlfpucod.obj \
          $(OBJ)\dfgtran.obj \
          $(OBJ)\dogtran.obj \
          $(OBJ)\dopersp.obj

FPUOBJ2 = $(OBJ)\doptgtra.obj \
          $(OBJ)\pcfpufor.obj \
          $(OBJ)\v2mdid.obj \
          $(OBJ)\v2mdset.obj \
          $(OBJ)\v2mdorg.obj \
          $(OBJ)\v2mdrot.obj \
	  $(OBJ)\arithcte.obj

# make the fpu library
$(LIBPATH)\$(LIBNAME).lib : $(FPUOBJ1) $(FPUOBJ2)

$(OBJ)\CVFLTINT.obj : $(SRCPATH)\CVFLTINT.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOFFT1D.obj  : $(SRCPATH)\DOFFT1D.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOFFT2D.obj  : $(SRCPATH)\DOFFT2D.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\CVRECPOL.obj : $(SRCPATH)\CVRECPOL.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOARITHM.obj : $(SRCPATH)\DOARITHM.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DFPERSP.obj  : $(SRCPATH)\DFPERSP.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DLFPUCOD.obj : $(SRCPATH)\DLFPUCOD.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DFGTRAN.obj  : $(SRCPATH)\DFGTRAN.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOGTRAN.obj  : $(SRCPATH)\DOGTRAN.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOPERSP.obj  : $(SRCPATH)\DOPERSP.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\DOPTGTRA.obj : $(SRCPATH)\DOPTGTRA.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\PCFPUFOR.obj : $(SRCPATH)\PCFPUFOR.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\V2MDID.obj   : $(SRCPATH)\V2MDID.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\V2MDSET.obj  : $(SRCPATH)\V2MDSET.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\V2MDORG.obj  : $(SRCPATH)\V2MDORG.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\V2MDROT.obj  : $(SRCPATH)\V2MDROT.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;

$(OBJ)\ARITHCTE.obj  : $(SRCPATH)\ARITHCTE.c
	$(CC) $(CFLAGS) /Fo$(OBJ)\$*.obj $(SRCPATH)\$*.c
	$(LIB) $(LFLAGS) $(LIBPATH)\$(LIBNAME).lib -+$(OBJ)\$*.obj,,;


