	TITLE	GDT_BLD - 09/26/83 BUILD THE GDT
	.XLIST
	INCLUDE DSEG.SRC
	INCLUDE POSTEQU.SRC
	INCLUDE SYSDATA.INC
	INCLUDE SYSDATA.MAC
	INCLUDE IAPX286.MAC
	.LIST
INCLUDE SEGMENT.SRC

		ASSUME	CS:CODE
		ASSUME	SS:NOTHING
		ASSUME	DS:CODE
		ASSUME	ES:NOTHING

		PUBLIC	GDT_BLD

PAGE
;
;
;
;	THE FOLLOWING DATA DEFINES THE PRE-INITIALIZED GDT.
;	THESE MUST BE INITIALIZED IN THE ORDER IN WHICH THEY APPEAR
;	IN THE GDT_DEF STRUCTURE DEFINITION AS IT IS IN SYSDATA.INC.
;
;
;
GDT_DATA_START	LABEL	WORD
;
;
;		FIRST ENTRY UNUSABLE
;
	DESCR_DEF	SEG, 0, 0, 0, 0
;
;		THE GDT ITSELF
;
	DESCR_DEF	SEG, GDT_LEN, GDT_LOC, 0, CPL0_DATA_ACCESS
PAGE
;
;		THE SYSTEM IDT DESCRIPTOR
;
	DESCR_DEF	SEG, SYS_IDT_LEN, SYS_IDT_LOC, 0, CPL0_DATA_ACCESS
;
;		THE SYSTEM DATA AREA DESCRIPTOR
;
	DESCR_DEF	SEG, SDA_LEN, SDA_LOC, 0, CPL0_DATA_ACCESS
PAGE
;
;		COMPATIBLE MONOCHROME CRT
;
	DESCR_DEF	SEG, MCRT_SIZE, MCRT@_LO, MCRT@_HI, CPL0_DATA_ACCESS
;
;		COMPATIBLE COLOR CRT
;
	DESCR_DEF	SEG, CCRT_SIZE, CCRT@_LO, CCRT@_HI, CPL0_DATA_ACCESS
;
;		ENHANCED COLOR CRT - ONE ENTRY FOR EACK 64K
;
	DESCR_DEF	SEG, ECCRT_SIZE, ECCRT@_LO_LO, ECCRT@_LO_HI, CPL0_DATA_ACCESS
;
;		SECOND PART OF CRT
;
	DESCR_DEF	SEG, ECCRT_SIZE, ECCRT@_HI_LO, ECCRT@_HI_HI, CPL0_DATA_ACCESS
PAGE
;
;		CODE SEGMENT FOR POST CODE, SYSTEM IDT
;
	DESCR_DEF	SEG, MAX_SEG_LEN, CSEG@_LO, CSEG@_HI, CPL0_CODE_ACCESS
;
;		TEMPORARY DESCRIPTORS FOR ES, CS, SS, AND DS
;
	DESCR_DEF	SEG, MAX_SEG_LEN, NSEG@_LO, NSEG@_HI, CPL0_DATA_ACCESS
	DESCR_DEF	SEG, MAX_SEG_LEN, NSEG@_LO, NSEG@_HI, CPL0_DATA_ACCESS
	DESCR_DEF	SEG, MAX_SEG_LEN, NSEG@_LO, NSEG@_HI, CPL0_DATA_ACCESS
	DESCR_DEF	SEG, MAX_SEG_LEN, NSEG@_LO, NSEG@_HI, CPL0_DATA_ACCESS

; POST_TR
TR_LOC:
	DESCR_DEF	SEG, 800H, 0C000H, 0, FREE_TSS
; POST_TSS_PTR
	DESCR_DEF	SEG, 800H, TR_LOC, 0, CPL0_DATA_ACCESS
LDT_LOC:
; POST_LDTR
	DESCR_DEF	SEG, GDT_LEN, 0D000H, 0, LDT_DESC
; POST_LDT_PTR
	DESCR_DEF	SEG, GDT_LEN, LDT_LOC, 0, CPL0_DATA_ACCESS
PAGE
;
GDT_DATA_END	LABEL	WORD
;
;	END OF PRE-ALLOCATED GDT
;
GDT_BLD 	PROC	NEAR

	MOV	SI,OFFSET GDT_DATA_START    ; DS:SI --> GDT
	MOV	CX,(GDT_DATA_END-GDT_DATA_START)/2  ; NUMBER OF WORDS TO COPY
	REP	MOVSW		      ; COPY GDT INTO RAM

	RET	0


GDT_BLD 	ENDP

CODE		ENDS
		END
