
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. TalkDemo : Demonstriert die Sprachausgabe mit der Sound-Blaster-    }
{                  Karte.                                                   }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : TALKDEMO.PAS                                             }
{ entwickelt am  : 12.07.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.02                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM TalkDemo;

{$D-}                                        { keine Debugger-Informationen }
{$F-}                                        { FAR-Aufrufe sind nicht ntig }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

USES Crt, SBTalker;                                       { Units einbinden }

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

CONST
  Text = 'This is a text to speech demonstration with the Sound Blaster';

BEGIN
  ClrScr;                                              { Bildschirm lschen }
  WriteLn(' DATA BECKERs Sound Blaster Superbuch  *  TALKDEMO  *  (c) '+
    '1993 by Arthur Burda');
  WriteLn(''+
    '');
  IF NOT TalkerInstalled THEN            { Sprachtreiber nicht installiert? }
    BEGIN               { nein, Fehlermeldung ausgeben und Programm beenden }
      WriteLn;
      WriteLn('Fehler: Sprachtreiber ist nicht installiert.');
      WriteLn('        Rufen Sie SBTALKER /dBLASTER auf.');
      Halt;
    END;
  WriteLn('Text "', Text, '" wird nun');
  WriteLn('mit unterschiedlichen Sprachparametern gesprochen ...');
  WriteLn;
  TalkerSettings(0, 0, 9, 5, 5);
  TextToSpeech(Text);
  TalkerSettings(0, 1, 9, 5, 5);
  TextToSpeech(Text);
  WriteLn('Demo beendet. Drcken Sie nun eine Taste ...');
  REPEAT                       { warten, bis irgendeine Taste gedrckt wird }
  UNTIL KeyPressed;
END.
