
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. Samples  : Eine Demo zum Abspielen von Samples im VOC-Format. Es    }
{                  sind verschiedene Gerusche wie Hubschrauber, Vgel u.a. }
{                  Alles unter einer sehr komfortablen SAA-Benutzerober-    }
{                  flche im Grafikmodus.                                   }
{                                                                           }
{                  ANMERKUNG: Zum Abspielen der Samples wird das Programm   }
{                             PlayVOC1 aufgerufen. Es mu sich im gleichen  }
{                             Verzeichnis befinden wie dieses Programm.     }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : SAMPLES.PAS                                              }
{ entwickelt am  : 05.07.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.03                                                     }
{ Compiler       : Turbo bzw. Borland Pascal 7.0 (wegen SAA-Oberflche)     }
{===========================================================================}

PROGRAM Samples;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$B-}                         { Kurzschluverfahren fr boolesche Ausdrcke }
{$D-}                                        { keine Debugger-Informationen }
{$F+}                                                { FAR-Aufrufe erlauben }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

{$M 16384,65536,131072}         { Stack 16 KB, Heap min. 64 KB, max. 128 KB }

USES DOS, Objects, MGDrv, MGSysInt, MGEvents, MGSystem, MGViews, MGApp;

CONST
  SamplesPath = '\SBPROG\VOC';                       { Pfad fr die Samples }

  {-------------------------------------------------------------------------}
  { VOC-Dateien                                                             }
  {-------------------------------------------------------------------------}

  voc_CHOPPER = 'CHOPPER.VOC';
  voc_BIRDS   = 'BIRDS.VOC';
  voc_ARCTIC  = 'ARCTIC.VOC';
  voc_WATER   = 'WATER.VOC';

  {-------------------------------------------------------------------------}
  { Befehlskonstanten                                                       }
  {-------------------------------------------------------------------------}

  cm_CHOPPER = 100;
  cm_BIRDS   = 101;
  cm_ARCTIC  = 102;
  cm_WATER   = 103;

  {-------------------------------------------------------------------------}
  { Hilfekontext-Konstanten                                                 }
  {-------------------------------------------------------------------------}

  hc_CHOPPER = 100;
  hc_BIRDS   = 101;
  hc_ARCTIC  = 102;
  hc_WATER   = 103;

TYPE

  {=========================================================================}
  { PMyButton3D: Zeiger auf TMyButton3D                                     }
  {=========================================================================}
  { TMyButton3D: Ein spezialisierter Nachkomme eines 3D-Schalters. Von sei- }
  {              nem Vorgnger unterscheidet er sich dadurch, da eine Hand }
  {              als Maus-Cursor angezeigt wird, sobald sich die Maus in-   }
  {              nerhalb des Schalters befindet.                            }
  {=========================================================================}

  PMyButton3D = ^TMyButton3D;
  TMyButton3D = OBJECT(TMGButton3D)

    {=======================================================================}
    { Methode HandleEvent: Kmmert sich um die Ereignissteuerung.           }
    {=======================================================================}
    { Eingabe: Event = Ereignis                                             }
    { Ausgabe: Event (Erluterung s. Eingabe)                               }
    {-----------------------------------------------------------------------}

    PROCEDURE HandleEvent(VAR Event : TEvent); VIRTUAL;

  END;

  {=========================================================================}
  { TSamplesApp: Ein Nachfolger von TMGApplication (SAA-Applikation im Gra- }
  {              fikmodus)                                                  }
  {=========================================================================}

  TSamplesApp = OBJECT(TMGApplication)

    {=======================================================================}
    { Methode Init: Initialisiert das TSamplesApp-Objekt.                   }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    CONSTRUCTOR Init;

    {=======================================================================}
    { Methode GetCaption: Liefert einen Zeiger auf die Kopfzeile, in der    }
    {                     der Name des Programms steht.                     }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: Zeiger auf die Kopfzeile                                     }
    {-----------------------------------------------------------------------}

    FUNCTION GetCaption : PMGCaption; VIRTUAL;

    {=======================================================================}
    { Methode GetStatusLine: Liefert einen Zeiger auf die Statuszeile des   }
    {                        Programms zurck.                              }
    {=======================================================================}
    { Eingabe: keine                                                        }
    { Ausgabe: Zeiger auf die Statuszeile                                   }
    {-----------------------------------------------------------------------}

    FUNCTION GetStatusLine : PMGStatusLine; VIRTUAL;

    {=======================================================================}
    { Methode HandleEvent: Die SAA-Oberflche arbeitet ereignisgesteuert.   }
    {                      Diese Methode hat die Aufgabe die ankommenden    }
    {                      Befehlsereignisse zu verwalten.                  }
    {=======================================================================}
    { Eingabe: Event = Ereignis                                             }
    { Ausgabe: Event (Erluterung s. Eingabe)                               }
    {-----------------------------------------------------------------------}

    PROCEDURE HandleEvent(VAR Event : TEvent); VIRTUAL;

    {=======================================================================}
    { Methode Play: Spielt die angegebene VOC-Datei ab. Dazu wird das Prog- }
    {               ramm PlayVOC1 aufgerufen.                               }
    {=======================================================================}
    { Eingabe: FileName = Name der VOC-Datei                                }
    { Ausgabe: keine                                                        }
    {-----------------------------------------------------------------------}

    PROCEDURE Play(FileName : String);

  END;

VAR

  {-------------------------------------------------------------------------}
  { Zeiger auf den Schalter, in dem sich der Maus-Cursor befindet           }
  {-------------------------------------------------------------------------}

  MouseButton : Pointer;

{---------------------------------------------------------------------------}
{ Implementation von TMyButton3D                                            }
{---------------------------------------------------------------------------}

PROCEDURE TMyButton3D.HandleEvent(VAR Event : TEvent);

BEGIN
  IF Event.What IN [evMouseMove, evMouseAuto] THEN      { Maus in Bewegung? }
    BEGIN                                                              { ja }
      IF MouseInView(Rect, Event.Where) THEN   { Maus-Cursor im Schaltfeld? }
        BEGIN                                                          { ja }
          MouseButton := @Self;
          SVGAEvHandler^.DefMouseCursor(mcHand);     { Maus-Cursor als Hand }
        END
      ELSE                               { Maus-Cursor nicht im Schaltfeld? }
        IF MouseButton = @Self THEN
          BEGIN
            MouseButton := NIL;
            SVGAEvHandler^.DefMouseCursor(mcStandard);       { Pfeil-Cursor }
          END;
    END;
  INHERITED HandleEvent(Event);
END;

{---------------------------------------------------------------------------}
{ Implementation von TSamplesApp                                            }
{---------------------------------------------------------------------------}

CONSTRUCTOR TSamplesApp.Init;

VAR
  iRect    : TRect;                           { Rechteck auf dem Bildschirm }
  Button3D : PMyButton3D;                                 { ein 3D-Schalter }
  Count    : Word;                                             { ein Zhler }

BEGIN
  INHERITED Init(gm_EGAVGA_640x350x16, '');   { Init-Methode des Vorgngers }

  { Standard-Paletten umdefinieren }

  vpMenuItem := #7#11#0#14#8;
  vpButton3D := #7#11#5#3#9#6#0#14#8;
  vpMenuButton := #7#11#5#3#9#6#0#14#8;
  vpDesktop := #13;

  { Farbzuordnung festlegen }

  GrSystem^.SetPalette(3, 3);
  GrSystem^.SetPalette(5, 5);
  GrSystem^.SetPalette(6, 6);
  GrSystem^.SetPalette(9, 9);
  GrSystem^.SetPalette(11, 11);
  GrSystem^.SetPalette(13, 13);

  { Standard-Farbpalette ndern }

  GrSystem^.SetRGBPalette(3, 60, 60, 60);
  GrSystem^.SetRGBPalette(5, 54, 54, 54);
  GrSystem^.SetRGBPalette(6, 28, 28, 28);
  GrSystem^.SetRGBPalette(9, 24, 24, 24);
  GrSystem^.SetRGBPalette(11, 0, 30, 50);
  GrSystem^.SetRGBPalette(13, 0, 30, 30);

  { Schalter erzeugen und einbinden }

  iRect.Assign(200, 80, 400, 129);    { Bereich fr den Schalter festlegen }
  Button3D := New(PMyButton3D, Init(iRect, 4, cm_CHOPPER, '~Hubschrauber',
    TRUE));
  Button3D^.HelpCtx := hc_CHOPPER;     { dem Schalter Hilfekontext zuordnen }
  InsertView(Button3D);                      { Schalter in Desktop einfgen }
  iRect.Assign(200, 130, 400, 179);
  Button3D := New(PMyButton3D, Init(iRect, 4, cm_BIRDS, '~Vgel', TRUE));
  Button3D^.HelpCtx := hc_BIRDS;
  InsertView(Button3D);
  iRect.Assign(200, 180, 400, 229);
  Button3D := New(PMyButton3D, Init(iRect, 4, cm_ARCTIC, '~Arktis', TRUE));
  Button3D^.HelpCtx := hc_ARCTIC;
  InsertView(Button3D);
  iRect.Assign(200, 230, 400, 279);
  Button3D := New(PMyButton3D, Init(iRect, 4, cm_WATER, '~Wasser', TRUE));
  Button3D^.HelpCtx := hc_WATER;
  InsertView(Button3D);
END;

FUNCTION TSamplesApp.GetCaption : PMGCaption;

BEGIN
  GetCaption := New(PMGCaption, Init(
    'Sound Blaster Superbuch  *  SAMPLES  *  (c) 1993 by Arthur Burda',
    TRUE));
END;

FUNCTION TSamplesApp.GetStatusLine : PMGStatusLine;

BEGIN
  GetStatusLine := New(PMGStatusLine, Init(
    NewStatusItem(hcProgram, hcProgram, 'Programm ... Mit <ESC> '+
      'wechseln Sie zwischen Men und Schaltern.',
    NewStatusItem(hcQuitProgram, hcQuitProgram,
      'Beendet SAMPLES.',
    NewStatusItem(hc_CHOPPER, hc_Chopper, 'Gerusch eines fliegenden '+
      'Hubschraubers',
    NewStatusItem(hc_BIRDS, hc_BIRDS, 'Stimmen verschiedener Wasservgel',
    NewStatusItem(hc_ARCTIC, hc_ARCTIC, 'Der Wind in der Arktis',
    NewStatusItem(hc_WATER, hc_WATER, 'Gerusch der Wasserwellen in einem '+
      'Flu',
    NIL))))))));
END;

PROCEDURE TSamplesApp.HandleEvent(VAR Event : TEvent);

BEGIN
  INHERITED HandleEvent(Event);        { HandleEvent-Methode des Vorgngers }

  { Samples abspielen }

  CASE Event.What OF
    evCommand :
      CASE Event.Command OF
        cm_CHOPPER :
          Play(voc_CHOPPER);
        cm_BIRDS :
          Play(voc_BIRDS);
        cm_ARCTIC :
          Play(voc_ARCTIC);
        cm_WATER :
          Play(voc_WATER);
      END;
  END;
END;

PROCEDURE TSamplesApp.Play(FileName : String);

VAR
  GraphSystem : PMGSystem;             { Zeiger auf das Grafiksystem-Objekt }

BEGIN
  IF FileName <> '' THEN                             { Dateiname angegeben? }
    BEGIN                                                              { ja }
      DoneEvents;                       { Ereignisverwaltung deinstallieren }
      DoneMGSysError;                    { System-Fehlerberwachung beenden }
      Dispose(GrSystem, Done);         { Grafiksystem-Objekt deinstallieren }
      SwapVectors;             { Interrupt-Vektoren des Systems vertauschen }
      Exec(GetEnv('COMSPEC'),     { COMMAND-Befehl "PLAYVOC1 ..." ausfhren }
        '/C '+'PLAYVOC1 '+SamplesPath+'\'+FileName);
      SwapVectors;
      WriteLn;
      WriteLn('Bitte irgendeine Taste drcken ...');
      ReadLn;
      InitMGSysError;        { System-Fehlerberwachung wieder installieren }
      InitEvents;                  { Ereignisverwaltung wieder installieren }
      GraphSystem := New(PMGSystem,               { Grafikmodus einschalten }
        Init(gm_EGAVGA_640x350x16, ''));

      { Farbzuordnung festlegen }

      GrSystem^.SetPalette(3, 3);
      GrSystem^.SetPalette(5, 5);
      GrSystem^.SetPalette(6, 6);
      GrSystem^.SetPalette(9, 9);
      GrSystem^.SetPalette(11, 11);
      GrSystem^.SetPalette(13, 13);

      { Standard-Farbpalette ndern }

      GrSystem^.SetRGBPalette(3, 60, 60, 60);
      GrSystem^.SetRGBPalette(5, 54, 54, 54);
      GrSystem^.SetRGBPalette(6, 28, 28, 28);
      GrSystem^.SetRGBPalette(9, 24, 24, 24);
      GrSystem^.SetRGBPalette(11, 0, 30, 50);
      GrSystem^.SetRGBPalette(13, 0, 30, 30);

      Draw;                                      { Desktop wiederherstellen }
      IF SVGAEvHandler <> NIL THEN                      { Maus installiert? }
        SVGAevHandler^.ShowMouse;                       { ja, Maus anzeigen }
    END;
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

VAR
  SamplesApp : TSamplesApp;

BEGIN
  MouseButton := NIL;
  WITH SamplesApp DO
    BEGIN
      Init;                                       { Programm initialisieren }
      Run;                                               { Programm starten }
      Done;                                              { Programm beenden }
    END;
END.
