/* 2003.09.10
****************************************
**  Copyright  (C)  W.ch  1999-2003   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  DOS for PCI interface chip CH365  **
**  C, TC2.0                          **
****************************************

 PCI߽ӿоƬCH365DOSӿڿ     V1.1
 Ͼߺ޹˾  : W.ch 2003.09
 CH365-DOS  V1.1 ,    Support: IO/MEM/INT
 л: DOS
*/

#ifndef		_CH365_DOS_H
#define		_CH365_DOS_H


typedef		void			VOID;
typedef		unsigned char	UCHAR;
typedef		unsigned short	USHORT;
typedef		unsigned long	ULONG;

typedef		void			*PVOID;
typedef		unsigned char	*PUCHAR;
typedef		unsigned short	*PUSHORT;
typedef		unsigned long	*PULONG;

typedef		void			far	*FPVOID;
typedef		unsigned char	far	*FPUCHAR;
typedef		unsigned short	far	*FPUSHORT;
typedef		unsigned long	far	*FPULONG;

typedef		unsigned short	BOOL;

typedef		void	far	interrupt	( *PINTERRUPT_ROUTINE )( );

typedef		union	REGS	X86REG;
typedef		struct	SREGS	X86SREG;


#ifndef		TRUE
#define		TRUE			1
#endif

#ifndef		FALSE
#define		FALSE			0
#endif

#define		mOFFSET( s, m )			( (ULONG) & ( ( ( s * ) 0 ) -> m ) )	/* ȡṹԱƫƵַĺ */

#ifndef		max
#define		max( a, b )				( ( ( a ) > ( b ) ) ? ( a ) : ( b ) )	/* ϴֵ */
#endif

#ifndef		min
#define		min( a, b )				( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )	/* Сֵ */
#endif


typedef	struct	_PCI_CONFIG {					/* PCIÿռݽṹ */
	USHORT			mPcVendorId;				/* 00H Ӧ̱ʶ */
	USHORT			mPcDeviceId;				/* 02H 豸ʶ */
	USHORT			mPcCommandReg;				/* 04H Ĵ */
	USHORT			mPcStatusReg;				/* 06H ״̬Ĵ */
	UCHAR			mPcRevisionId;				/* 08H ޸ıʶ */
	UCHAR			mPcProgramIf;				/* 09H Ĵ̽ӿ */
	UCHAR			mPcSubClass;				/* 0AH  */
	UCHAR			mPcBaseClass;				/* 0BH  */
	UCHAR			mPcCacheLine;				/* 0CH г */
	UCHAR			mPcLatenTimer;				/* 0DH ӳټ */
	UCHAR			mPcHeaderType;				/* 0EH ͷ */
	UCHAR			mPcBistReg;					/* 0FH ںԲԼĴ */
	ULONG			mPcBaseAddr0;				/* 10H ַĴ0 */
	ULONG			mPcBaseAddr1;				/* 14H ַĴ1 */
	ULONG			mPcBaseAddr2;				/* 18H ַĴ2 */
	ULONG			mPcBaseAddr3;				/* 1CH ַĴ3 */
	ULONG			mPcBaseAddr4;				/* 20H ַĴ4 */
	ULONG			mPcBaseAddr5;				/* 24H ַĴ5 */
	ULONG			mPcCardCis;					/* 28H */
	USHORT			mPcSubSysVen;				/* 2CH ϵͳӦ̱ʶ */
	USHORT			mPcSubSysDev;				/* 2EH ϵͳ豸ʶ */
	ULONG			mPcExpansRom;				/* 30H չROMַĴ */
	UCHAR			mPcCapPtr;					/* 34H */
	UCHAR			mPcReserved1[3];			/* 35H */
	ULONG			mPcReserved2;				/* 38H */
	UCHAR			mPcInterLine;				/* 3CH ж߼Ĵ */
	UCHAR			mPcInterPin;				/* 3DH жżĴ */
	UCHAR			mPcMinGrant;				/* 3EH */
	UCHAR			mPcMaxLatency;				/* 3FH */
} mPCI_CONFIG, *mPPCI_CONFIG;

typedef	struct	_PCI_EXP_ROM {					/* PCIչROMݽṹ */
	UCHAR			mPerRomSig[4];				/* 00H PCIչROMǩַ'PCIR' */
	USHORT			mPerVendorId;				/* 04H Ӧ̱ʶ */
	USHORT			mPerDeviceId;				/* 06H 豸ʶ */
	USHORT			mPerVpdPtr;					/* 08H ҪƷָ */
	USHORT			mPerStrucLen;				/* 0AH PCIչROMݽṹĳ */
	UCHAR			mPerRevision;				/* 0CH PCIչROMݽṹ޸İ汾 */
	UCHAR			mPerProgramIf;				/* 0DH Ĵ̽ӿ */
	UCHAR			mPerSubClass;				/* 0EH  */
	UCHAR			mPerBaseClass;				/* 0FH  */
	USHORT			mPerImageLen;				/* 10H ӳ񳤶 */
	USHORT			mPerImageRev;				/* 12H ӳд/ݵ޸İ汾 */
	UCHAR			mPerCodeType;				/* 14H  */
	UCHAR			mPerIndicator;				/* 15H ӳָʾ־ */
	USHORT			mPerReserved;				/* 16H */
} mPCI_EXP_ROM, *mPPCI_EXP_ROM;

typedef	struct	_CH365_CFG_REG {				/* CH365оƬüĴ */
	mPCI_CONFIG		mCh365CfgPci;				/* 00H-3FH,64ֽΪ׼PCIÿռ */
	UCHAR			mCh365CfgCtrl;				/* 40H оƬƼĴ,5λֻ */
	UCHAR			mCh365CfgDin;				/* 41H 8λ˿,ֻ */
	UCHAR			mCh365CfgState;				/* 42H оƬ״̬Ĵ,ֻ */
	UCHAR			mCh365CfgResv;				/* 43H */
} mCH365_CFG_REG, *mPCH365_CFG_REG;

typedef	struct	_CH365_IO_REG {					/* CH365оƬI/Oռ */
	UCHAR			mCh365IoPort[0xf0];			/* 00H-EFH,240ֽΪ׼I/O˿ */
	UCHAR			mCh365MemAddrL;				/* F0H 洢ӿ: A7-A0ַ趨Ĵ */
	UCHAR			mCh365MemAddrH;				/* F1H 洢ӿ: A15-A8ַ趨Ĵ */
	UCHAR			mCh365IoResv2;				/* F2H */
	UCHAR			mCh365MemData;				/* F3H 洢ӿ: 洢ݴȡĴ */
	UCHAR			mCh365I2cData;				/* F4H I2Cнӿ: I2CݴȡĴ */
	UCHAR			mCh365I2cCtrl;				/* F5H I2Cнӿ: I2Cƺ״̬Ĵ */
	UCHAR			mCh365I2cAddr;				/* F6H I2Cнӿ: I2Cַ趨Ĵ */
	UCHAR			mCh365I2cDev;				/* F7H I2Cнӿ: I2C豸ַĴ */
	UCHAR			mCh365IoCtrl;				/* F8H оƬƼĴ,5λֻ */
	UCHAR			mCh365IoBuf;				/* F9H 뻺Ĵ */
	UCHAR			mCh365IoSpeed;				/* FAH дٶȿƼĴ */
	UCHAR			mCh365IoResv3;				/* FBH */
	UCHAR			mCh365IoTime;				/* FCH ӲѭĴ */
	UCHAR			mCh365IoResv4[3];			/* FDH */
} mCH365_IO_REG, *mPCH365_IO_REG;


#define		mCH365_MEM_BASE_AUTO	0xffffffff	/* Զ趨CH365Ĵ洢ַ */

#define		mCH365_INT_LINE_AUTO	0xffff		/* ԶCH365жϺ */

#define		mHARDWARE_INTERRUPT( i )	( ( i ) < 8 ? ( i ) + 8 : ( i ) + 0x68 )	/* Ӳжϵж */


/* Ĵλ */
#define		mBitAddr15Out			0x01		/* 趨A15ֵ,1*:high,0:low */
#define		mBitSysExtOut			0x02		/* 趨SYS_EXֵ,1:high,0*:low */
#define		mBitIntAction			0x04		/* 趨жϼ״̬,1:action,0*:inaction */
#define		mBitPciIdDef			0x01		/* ֻ,PCI豸ʶĵǰѡ,1*:default,0:external */
#define		mBitPortHit				0x04		/* ֻ,Ӳַܵ״̬,1:,0*: */
#define		mBitInterRom			0x10		/* ֻ,ڲMini-ROMܵ״̬,1:,0*: */
#define		mBitSysExtOe			0x40		/* ֻ,SYS_EX̬/ʹ,1*:,0: */
#define		mBitIntEnable			0x80		/* ֻ,жϹܵ״̬,1:,0*: */
#define		mBitI2cStatus			0x01		/* I2CӿڵĲƺ״̬,1:ʼ/ڲ,0*:/ */
#define		mBitI2cSclOut			0x80		/* ѡI2CӿڵSCL,1:SYS_EX,0*:A15 */
#define		mBitIoSpeed				0x07		/* 趨д,000-111,111*:210nS/240nS */
#define		mBitIoSpace				0x10		/* 趨д֮С,1:60nS,0*:30nS */
#define		mBitIoPrefetch			0x80		/* 趨洢ռԤȡλ,1:ʹ,0*:ֹ */


USHORT			CH365CheckDevice( );  /* CH365豸,⵽CH365򷵻PCIַ,/豸/ܺ,򷵻0 */


UCHAR			CH365ReadCfgByte(  /* ÿռȡһֽ,ضȡֽ */
	USHORT			iOffset );  /* ָƫƵַ */


VOID			CH365WriteCfgByte(  /* ÿռдһֽ */
	USHORT			iOffset,  /* ָƫƵַ */
	UCHAR			iByte );  /* дֽ */


USHORT			CH365ReadCfgWord(  /* ÿռȡһ,ضȡ */
	USHORT			iOffset );  /* ָƫƵַ */


VOID			CH365WriteCfgWord(  /* ÿռдһ */
	USHORT			iOffset,  /* ָƫƵַ */
	USHORT			iWord );  /* д */


mPCH365_IO_REG	CH365GetIoBaseAddr( );  /* ȡI/O˿ڵĻַ,I/O˿ڻַ */


BOOL			CH365SetIoBaseAddr(  /* 趨I/O˿ڵĻַ */
	mPCH365_IO_REG	iIoBaseAddr );  /* ָI/O˿ڻַ */


ULONG			CH365GetMemBaseAddr( );  /* ȡ洢Ļַ,ش洢ַ */


BOOL			CH365SetMemBaseAddr(  /* 趨洢Ļַ */
	ULONG			iMemBaseAddr );  /* ָ洢ַ,Ϊ0رմ洢,Ϊ-1Զ趨 */


USHORT			CH365GetIntLine( );  /* ȡжϺ,жϺ,Ϊ0Ч */


BOOL			CH365SetIntLine(  /* 趨жϺ */
	USHORT			iIntLine );  /* ָжϺ,Ϊ0رж,Ϊ-1ԶⲢ趨 */


BOOL			CH365SetIntRoutine(  /* 趨жϷ */
	PINTERRUPT_ROUTINE	iIntRoutine );  /* ָжϷ,ΪNULLȡжϷ,жʱøó */


UCHAR			CH365ReadI2C(  /* I2Cӿڶȡһֽ,ضȡֽ */
	UCHAR			iDevice,  /* 7λָI2C豸ַ */
	UCHAR			iAddr );  /* ָݵԪĵַ */


VOID			CH365WriteI2C(  /* I2Cӿдһֽ */
	UCHAR			iDevice,  /* 7λָI2C豸ַ */
	UCHAR			iAddr,  /* ָݵԪĵַ */
	UCHAR			iByte );  /* дֽ */


VOID			CH365DelayUS(  /* ʱָ΢ */
	ULONG			iDelay );  /* ָҪʱ΢,ʱС10ϴ */


#endif		/* _CH365_DOS_H */
