/*;CH372/CH375 USB device mode & external firmware
; U2(AT89C51) Program
;
; Website:  http://winchiphead.com
; Email:    tech@winchiphead.com
; Author:   W.ch 2003.12, 2005.03
;
;****************************************************************************
CH375 ⲿ̼ʽ
׼Ͷ˵2ļ򵥶д

*/

/* MCS-51ƬCԵʾ */
#pragma NOAREGS
#include <reg52.h>
#include "CH375INC.H"

typedef	union _REQUEST_PACK{
	unsigned char  buffer[8];
	struct{
		unsigned char	 bmReuestType;    	 //׼
		unsigned char	 bRequest;		   	//
		unsigned int     wValue;			//ѡ
		unsigned int     wIndx;				//
		unsigned int     wLength;				//ݳ
	}r;
} mREQUEST_PACKET,	*mpREQUEST_PACKET;

//豸
unsigned char  code DevDes[]={
						0x12			//С			
					  , 0x01			//DEVICE
					 , 0x10				//USB淶汾Ϣ
				     , 	0x01
					,   0xFF			//룬
					,  0x80				//	
					,   0x37			//Э
					,  0x08				//˵0ϢС
					,  0x48				//ID
					,   0x43
					,   0x37			//ƷID	
					,   0x55
					,   0x00			//豸汾Ϣ
					,   0x01
					,   0x00			//ֵ	
					,   0x00
					,   0x00
					,   0x01			//õĿ	
					,   00				//
					,   00
					,   00
					,	00
					,	00
					,	00
					};
//
unsigned char   code ConDes[]={			//
					  0x09					//С
					,  0x02					//CONFIG
					,  0x27					//ôݴС
					,  0x00					//
					,  0x01					//ӿ
					,  0x01					//ֵ
					,  0x00					//
					,  0x80					//Դ
					,  0x40					//ҪߵԴ
										//ӿ
					,  0x09					//С								
					,  0x04					//INTERFACE				
					,  0x00					//ʶ
					,  0x00					//ֵ
					,  0x03					//ֵ֧Ķ˵
					,  0xFF					//
					,  0x80					//
					,  0x37					//Э
					,  0x00					//
										//˵
					,  0x07					//С
					,  0x05					//ENDPOINT
					,  0x82					//˵Ŀ
					,  0x02					//ֵ֧Ĵ
					,  0x40					//ֵ֧ϢС
					,  0x00
					,  0x00					//
				
					,  0x07
					,  0x05
					,  0x02
					,  0x02
					,  0x40
					,  0x00
					,  0x00
					
					,  0x07
					,  0x05
					,  0x81
					,  0x03
					,  0x08
					,  0x00
					,  0x01

					,  0x07
					,  0x05
					,  0x01
					,  0x02
					,  0x08
					,  0x00
					,  0x00
				};		//
unsigned char  code LangDes[]={0x04,0x03,0x09,0x04};		//
unsigned char  code SerDes[]={0x12,0x03,'C',0,'H',0,'3',0,'7',0,'5',0,'U',0,'S',0,'B',0};		//ַ

unsigned char mVarSetupRequest;						//	;USB
unsigned short mVarSetupLength;					//		;ݳ
unsigned char  code * VarSetupDescr;						//	;ƫƵַ

unsigned char VarUsbAddress	;					//

bit CH375FLAGERR;						//0
bit CH375TRANSBIT;
bit	CH375CONFLAG;
					                     //ñ־

unsigned char volatile xdata CH375_CMD_PORT _at_ 0xBDF1;		/* CH375˿ڵI/Oַ */
unsigned char volatile xdata CH375_DAT_PORT _at_ 0xBCF0;		/* CH375ݶ˿ڵI/Oַ */

mREQUEST_PACKET  request;
sbit  CH375ACT  = P1^4;


/* ʱ2΢,ȷ */
void Delay1us(){
	;
}

void	Delay2us( )
{
	unsigned char i;
#define DELAY_START_VALUE	1  								/* ݵƬʱѡֵ,20MHzΪ0,30MHzΪ2 */
	for ( i=DELAY_START_VALUE; i!=0; i-- );
}

/* ʱ50,ȷ */
void	Delay50ms( )
{
	unsigned char i, j;
	for ( i=200; i!=0; i-- ) for ( j=250; j!=0; j-- );
}

/* PCĵֽǰ16λתΪC51ĸֽǰ */
//unsigned int	BIG_ENDIAN( unsigned int value )
//{
//	unsigned int  in, out;
//	in = value;
//	((unsigned char *)&out)[1] = ((unsigned char *)&in)[0];
//	((unsigned char *)&out)[0] = ((unsigned char *)&in)[1];
//	return( out );
//}

void CH375_WR_CMD_PORT( unsigned char cmd ) { 				 /* CH375˿д,ڲС4uS,ƬϿʱ */
	//delay2us();
	CH375_CMD_PORT=cmd;
	Delay2us( );
}

void CH375_WR_DAT_PORT( unsigned char dat ) { 				 /* CH375ݶ˿д,ڲС1.5uS,ƬϿʱ */
	CH375_DAT_PORT=dat;
	Delay1us();  											/* ΪMCS51Ƭʵʱ */
}

unsigned char CH375_RD_DAT_PORT() {  						/* CH375ݶ˿ڶ,ڲС1.5uS,ƬϿʱ */
	Delay1us( );  										/* ΪMCS51Ƭʵʱ */
	return( CH375_DAT_PORT );

}
/* CH375ʼӳ */
void	CH375_Init( )
{
/* USBģʽ, Ҫ */
	CH375_WR_CMD_PORT( CMD_SET_USB_MODE );
	CH375_WR_DAT_PORT( 1 );  									/* Ϊʹù̼USB豸ʽ */
	for ( ;; ) {  											/* ȴɹ,ͨҪȴ10uS-20uS */
		if ( CH375_RD_DAT_PORT( )==CMD_RET_SUCCESS ) break;
	}

/* ж,ٶCH375INT0 */
	IT0 = 0;  /* ⲿźΪ͵ƽ */
	IE0 = 0;  /* жϱ־ */
	EX0 = 1;  /* CH375ж */
}
//*********************************************************

//*********************************************************
//˵0ϴ
void mCh375Ep0Up(){
	unsigned char i,len;
	if(mVarSetupLength){												//ȲΪ0峤ȵ
		if(mVarSetupLength<=8){
			len=mVarSetupLength;
			mVarSetupLength=0;
        }	//С8Ҫĳ
		else{
			len=8;
			mVarSetupLength-=8;
		}							                        		//ȴ88ܳȼ8
	    CH375_WR_CMD_PORT(CMD_WR_USB_DATA3);						//д˵0
       	CH375_WR_DAT_PORT(len);										//д볤
    	for(i=0;i!=len;i++)
        CH375_WR_DAT_PORT(request.buffer[i]);	              		//ѭд
    }
	else{
		CH375_WR_CMD_PORT(CMD_WR_USB_DATA3);						//д˵0
		CH375_WR_DAT_PORT(0);					                   //ϴ0ݣһ״̬׶
	}
}


//*********************************************************

//Աϴ
void mCh375DesUp(){
	unsigned char k;        
	for (k=0; k!=8; k++ ) {
         request.buffer[k]=*VarSetupDescr;  								//θ8
         VarSetupDescr++;
    }
}

/* CH375жϷINT0,ʹüĴ1 */
void	mCH375Interrupt( ) interrupt 0 using 1
{
	unsigned char InterruptStatus;
	unsigned char length, c1, len;
	unsigned char   *pBuf;
	unsigned char   mBuf[64];
	CH375_WR_CMD_PORT(CMD_GET_STATUS);  									/* ȡж״̬ȡж */
	InterruptStatus =CH375_RD_DAT_PORT();  									/* ȡж״̬ */
	IE0 = 0;  																/* жϱ־,ӦINT0ж */
	switch(InterruptStatus){  // ж״̬
		case  USB_INT_EP2_OUT:  											// ˵´ɹ 
			pBuf=mBuf;																	//δ
			CH375_WR_CMD_PORT(CMD_RD_USB_DATA);									//
			length=CH375_RD_DAT_PORT();											//ȶǳ														
			for(len=0;len!=length;len++,pBuf++)*pBuf=CH375_RD_DAT_PORT();	//ݶ뵽			 
			pBuf=mBuf;
// ʾش
			CH375_WR_CMD_PORT(CMD_WR_USB_DATA7);								//дϴ˵
			CH375_WR_DAT_PORT(length);	
			for(len=0;len!=length;len++,pBuf++)CH375_WR_DAT_PORT(*pBuf);	//дϴ˵
			break;
		case   USB_INT_EP2_IN:												 //˵ϴɹ,δ
			CH375_WR_CMD_PORT (CMD_UNLOCK_USB);								//ͷŻ
			break;
		case   USB_INT_EP1_IN:	 											//ж϶˵ϴɹδ
			CH375_WR_CMD_PORT (CMD_UNLOCK_USB);								//ͷŻ
			break;
		case   USB_INT_EP1_OUT:	  											//ж϶˵´ɹδ
			CH375_WR_CMD_PORT(CMD_RD_USB_DATA);									//
			if(length=CH375_RD_DAT_PORT()){										//Ϊ0
				for(len=0;len!=length;len++)c1=CH375_RD_DAT_PORT();					//ȡ´
			}
//			CH375_WR_CMD_PORT (CMD_UNLOCK_USB);								//ͷŻ,ǰûCMD_RD_USB_DATAʹñ
			break;
		case   USB_INT_EP0_SETUP: 											//ƶ˵㽨ɹ
	    	CH375_WR_CMD_PORT(CMD_RD_USB_DATA);
			length=CH375_RD_DAT_PORT();
			for(len=0;len!=length;len++)request.buffer[len]=CH375_RD_DAT_PORT();  // ȡ
			mVarSetupRequest = 0xff;										//״̬
			CH375TRANSBIT = 0;												//־
			if(length==0x08){
			    mVarSetupLength=(request.buffer[6] | (unsigned short)request.buffer[7]<<8);							//ƴݳΪ128
				if( !(request.r.bmReuestType&0x80) ){									//ʾҪϴ
						CH375FLAGERR = 2;																	//ϴñ־
				}
				else CH375FLAGERR = 0;																//´־
				if((c1=request.r.bmReuestType)&0x40){         					 //δ
				}
				if((c1=request.r.bmReuestType)&0x20){          					//δ
				}
				if(!((c1=request.r.bmReuestType)&0x60)){          				//׼
					mVarSetupRequest=request.r.bRequest;							//ݴ׼
					switch(request.r.bRequest){  // ׼
						case DEF_USB_CLR_FEATURE:									//
							if((c1=request.r.bmReuestType&0x1F)==0X02){					//Ƕ˵㲻֧
								switch(request.buffer[4]){
									case 0x82:
										CH375_WR_CMD_PORT(CMD_SET_ENDP7);					//˵2ϴ
										CH375_WR_DAT_PORT(0x8E);                			//˵
										break;
									case 0x02:
										CH375_WR_CMD_PORT(CMD_SET_ENDP6);
										CH375_WR_DAT_PORT(0x80);							//˵2´
										break;
									case 0x81:
										CH375_WR_CMD_PORT(CMD_SET_ENDP5);					//˵1ϴ
										CH375_WR_DAT_PORT(0x8E);
										break;
									case 0x01:
										CH375_WR_CMD_PORT(CMD_SET_ENDP4);					//˵1´
										CH375_WR_DAT_PORT(0x80);
										break;
									default:
										break;
								}
							}
							else{
								CH375FLAGERR=1;								//ֵ֧ԣô־
							}
							break;
						case DEF_USB_GET_STATUS:								//״̬
							request.buffer[0]=0;
							request.buffer[1]=0;								//ϴ״̬
							break;
						case DEF_USB_SET_ADDRESS:								//õַ
							VarUsbAddress=request.buffer[2];					//ݴUSBĵַ
							break;
						case DEF_USB_GET_DESCR: 								//
							if(request.buffer[3]==1)							//豸ϴ
								VarSetupDescr=DevDes;
							else if(request.buffer[3]==2){		 					//ϴ
								if(mVarSetupLength > (ConDes[2] | (unsigned short)ConDes[3]<<8))
									mVarSetupLength = ConDes[2] | (unsigned short)ConDes[3]<<8;
								VarSetupDescr=ConDes;
							}
							else if(request.buffer[3]==3) {
								if ( request.buffer[2]== 0 ) VarSetupDescr=LangDes;
								else VarSetupDescr=SerDes; 						//ַ
							}
							mCh375DesUp();											//֧					          							
							break;
						case DEF_USB_GET_CONFIG:									//
							request.buffer[0]=0;									//û0
							if(CH375CONFLAG) request.buffer[0]=1;									//Ѿ1涨
							break;
						case DEF_USB_SET_CONFIG:                 					//
							CH375CONFLAG=0;
							CH375ACT=1;
							if ( request.buffer[2] != 0 ) {
								CH375CONFLAG=1;											//ñ־
								CH375ACT=0;												//ź
							}
							break;
						case DEF_USB_GET_INTERF:										//õӿ
							request.buffer[0]=1;									//ϴӿֻ֧һӿ
							break;
						default :
							CH375FLAGERR=1;											//ֵ֧ı׼
							break;
					}
				}
			}
			else {  //ֵ֧Ŀƴ䣬8ֽڵĿƴ
				CH375FLAGERR=1;
			}
			if(CH375FLAGERR==0) mCh375Ep0Up();										//ûд/ϴΪ0ϴΪ״̬
			else if( CH375FLAGERR == 2 ) {
				if( mVarSetupLength == 0 ){											//ϴ0
					CH375FLAGERR = 0;
					mCh375Ep0Up();	
				}
			}
			else{
				CH375_WR_CMD_PORT(CMD_SET_ENDP3);								//ö˵1ΪSTALLָʾһ
				CH375_WR_DAT_PORT(0x0F);
			}
			break;
		case   USB_INT_EP0_IN:													//ƶ˵ϴɹ
			if(mVarSetupRequest==DEF_USB_GET_DESCR){								//ϴ
				mCh375DesUp();
				mCh375Ep0Up();															
			}
			else if(mVarSetupRequest==DEF_USB_SET_ADDRESS){							//õַ
				CH375_WR_CMD_PORT(CMD_SET_USB_ADDR);
				CH375_WR_DAT_PORT(VarUsbAddress);								//USBַ,´USBַ
			}
			CH375_WR_CMD_PORT (CMD_UNLOCK_USB);								//ͷŻ
			break;
		case   USB_INT_EP0_OUT:													//ƶ˵´ɹ
			CH375_WR_CMD_PORT(CMD_RD_USB_DATA);									//
			if(length=CH375_RD_DAT_PORT()){										//Ϊ0
				mVarSetupLength -= length;
				for(len=0;len!=length;len++)c1=CH375_RD_DAT_PORT();					//ȡ´
				CH375TRANSBIT = 1;
			}
			if( CH375TRANSBIT ){											
				if( (length<8) || (mVarSetupLength == 0) ){
					CH375TRANSBIT = 0;
					CH375_WR_CMD_PORT(CMD_WR_USB_DATA3);						//д˵0
					CH375_WR_DAT_PORT(0);					                   //ϴ0ݣһ״̬׶
				}
			}
			break;
		default:
			if((InterruptStatus&0x03)==0x03){									//߸λ
				CH375FLAGERR=0;													//0
				CH375CONFLAG=0;													//0
				mVarSetupLength=0;
				CH375TRANSBIT = 0;
				CH375ACT=1;														//

			}
			else{																//֧
				;
			}
			CH375_WR_CMD_PORT (CMD_UNLOCK_USB);									//ͷŻ
			break;
	}
}

main( ) {
	Delay50ms( );	/* ʱȴCH375ʼ,ƬCH375ṩλź򲻱ʱ */
	CH375_Init( );  /* ʼCH375 */
    EA=1;
    while(1);		/*  */
}
