/*; CH375/CH372/CH451 EVT
; U2(AT89C51) Program
;
; Website:  http://winchiphead.com
; Email:    tech@winchiphead.com
; Author:   W.ch 2003.12
;
;****************************************************************************
*/

/* MCS-51ƬCԵʾ */

#include <reg52.h>
#include <string.h>
#include "..\..\MCU_IF1\MCS51C\CH375INC.H"

typedef	struct	_COMMAND_PACKET	{	/* Զṹ */
	unsigned char	mCommandCode;		/* ,Ķ */
	unsigned char	mCommandCodeNot;	/* ķ,У */
	union	{
		unsigned char	mParameter[5];	/*  */
		struct {
			unsigned char	mBufferID;  /* ʶ,MCS51Ƭ: 1-רùܼĴSFR, 2-ڲRAM, 3-ⲿRAM, ʵֻʾڲRAM */
			unsigned int	mBufferAddr;	/* дʼַ,ѰַΧ0000H-0FFFFH,ֽǰ */
			unsigned int	mLength;	/* ݿܳ,ֽǰ */
		} buf;
	} u;
}	mCOMMAND_PACKET,	*mpCOMMAND_PACKET;

#define		CONST_CMD_LEN		0x07	/* ĳ */
/* ݶͨ´ܵ(USB˵2OUT)´, Ϊ˷ֹ߻,
 ǿڼӦó뵥Ƭ֮Լ, ĳ7, ݿĳȿ϶7, 64,32
 , Լ, ֽ, ȵ
 Լ: 80H-0FFHͨ,ڸӦ
                   00H-7FHר,ԸӦر */
/* ͨ */
#define		DEF_CMD_GET_INFORM		0x90	/* ȡλ˵Ϣ,Ȳ64ַ,ַ00H */
#define		DEF_CMD_TEST_DATA		0x91	/* ,λPCȡ󷵻 */
#define		DEF_CMD_CLEAR_UP		0xA0	/* ϴݿ֮ǰͬ,ʵλϴ */
#define		DEF_CMD_UP_DATA			0xA1	/* λַָĻжȡݿ(ϴݿ) */
#define		DEF_CMD_DOWN_DATA		0xA2	/* λַָĻдݿ(´ݿ) */
/* ר */
#define		DEMO_CH451_CMD			0x56	/* PCCH451,ʾCH451Ĺ */
/* MCS51Ƭʹͨʱ,Ҫָʶ */
#define		ACCESS_MCS51_SFR		1		/* д51ƬSFR */
#define		ACCESS_MCS51_IRAM		2		/* д51ƬڲRAM */
#define		ACCESS_MCS51_XRAM		3		/* д51ƬⲿRAM */

unsigned char volatile xdata CH375_CMD_PORT _at_ 0xBDF1;		/* CH375˿ڵI/Oַ */
unsigned char volatile xdata CH375_DAT_PORT _at_ 0xBCF0;		/* CH375ݶ˿ڵI/Oַ */

/* йCH451Ķ,ʾӷʽ */
sbit   CH451_dclk=P1^7;      /* ʱӼ */
sbit   CH451_din=P1^6;	     /* ,CH451 */
sbit   CH451_load=P1^5;      /* ,Ӽ */
sbit   CH451_dout=P3^3;      /* INT1,жϺͼֵ,CH451 */
unsigned char CH451_KEY;				/* żжжȡļֵ */
unsigned char LAST_KEY;					/* ϴεļֵ */

mCOMMAND_PACKET	CMD_PKT;				/* ṹ */
unsigned char data *CurrentRamAddr;		/* ݿ鴫ʱ汻дĻʼַ */
unsigned char CurrentRamLen;			/* ݿ鴫ʱʣ೤ */
bit		FLAG_INT_WAIT;		/* жϵȴ־,1ָʾжCH375еȴ */
unsigned char CH451_CMD_H;	/* PCCH451ĸ4λ,Ϊ0FFHЧ */
unsigned char CH451_CMD_L;  /* PCCH451ĵ8λ */
unsigned char code InformString[16] = "CH375/CH451\x0";	/* Ϣַ */

/* ʱ2΢,ȷ */
void	Delay2us( )
{
	unsigned char i;
#define DELAY_START_VALUE	1  /* ݵƬʱѡֵ,20MHzΪ0,30MHzΪ2 */
	for ( i=DELAY_START_VALUE; i!=0; i-- );
}

/* ʱ50,ȷ */
void	Delay50ms( )
{
	unsigned char i, j;
	for ( i=200; i!=0; i-- ) for ( j=250; j!=0; j-- );
}

/* PCĵֽǰ16λתΪC51ĸֽǰ */
unsigned int	BIG_ENDIAN( unsigned int value )
{
	unsigned int  in, out;
	in = value;
	((unsigned char *)&out)[1] = ((unsigned char *)&in)[0];
	((unsigned char *)&out)[0] = ((unsigned char *)&in)[1];
	return( out );
}

/* CH375ʼӳ */
void	CH375_Init( )
{
	unsigned char i;
	FLAG_INT_WAIT = 0;  /* 巢жϵȴ־ */
/* CH375Ƿ,ѡ,ͨҪ */
#ifdef TEST_CH375_FIRST
	CH375_CMD_PORT = CMD_CHECK_EXIST;  /* CH375Ƿ */
	Delay2us( );  /* ʱƵʵ16MHzָʱ */
	CH375_DAT_PORT = 0x55;  /* д */
	Delay2us( );
	i = ~ 0x55;  /* Ӧǲȡ */
	if ( CH375_DAT_PORT != i ) {  /* CH375 */
		for ( i=80; i!=0; i-- ) {
			CH375_CMD_PORT = CMD_RESET_ALL;  /* ظ,ִӲλ */
			Delay2us( );
		}
		CH375_CMD_PORT = 0;
		Delay50ms( );  /* ʱ50ms */
	}
#endif
#ifdef USE_MY_USB_ID
/* ⲿԶUSB豸VIDPID,ѡ,ִиʹĬϵVIDPID */
	CH375_CMD_PORT = CMD_SET_USB_ID;  /* ⲿԶUSB豸VIDPID,ѡ */
	Delay2us( );  /* ʱƵʵ16MHzָʱ */
	CH375_DAT_PORT = (unsigned char)MY_USB_VENDOR_ID;  /* д볧IDĵֽ */
	CH375_DAT_PORT = (unsigned char)(MY_USB_VENDOR_ID>>8);  /* д볧IDĸֽ */
	CH375_DAT_PORT = (unsigned char)MY_USB_DEVICE_ID;  /* д豸IDĵֽ */
	CH375_DAT_PORT = (unsigned char)(MY_USB_DEVICE_ID>>8);  /* д豸IDĸֽ */
	Delay2us( );
#endif
/* USBģʽ, Ҫ */
	CH375_CMD_PORT = CMD_SET_USB_MODE;
	Delay2us( );  /* ʱƵʵ16MHzָʱ */
	CH375_DAT_PORT = 2;  /* Ϊʹù̼USB豸ʽ */
	for ( i=100; i!=0; i-- ) {  /* ȴɹ,ͨҪȴ10uS-20uS */
		if ( CH375_DAT_PORT==CMD_RET_SUCCESS ) break;
	}
/*	if ( i==0 ) { CH372/CH375Ӳ }; */
/* ж,ٶCH375INT0 */
	IT0 = 0;  /* ⲿźΪ͵ƽ */
	IE0 = 0;  /* жϱ־ */
	EX0 = 1;  /* CH375ж */
}

/* ϴ */
void	LoadUpData( unsigned char data *Buf, unsigned char Len )
{
	unsigned char i;
	CH375_CMD_PORT = CMD_WR_USB_DATA7;  /* USB˵2ķͻдݿ */
	Delay2us( );  /* ʱƵʵ16MHzָʱ */
	CH375_DAT_PORT = Len;  /* дݳ */
	for ( i=0; i<Len; i++ ) CH375_DAT_PORT = Buf[i];  /*  */
}

/* CH375жϷINT0,ʹüĴ1 */
void	mCH375Interrupt( ) interrupt 0 using 1
{
	unsigned char InterruptStatus;
	unsigned char length, c1, len1, len2, i;
#define		cmd_buf		((unsigned char data *)(&CMD_PKT))
	CH375_CMD_PORT = CMD_GET_STATUS;  /* ȡж״̬ȡж */
	Delay2us( );  /* ʱƵʵ16MHzָʱ */
	InterruptStatus = CH375_DAT_PORT;  /* ȡж״̬ */
	IE0 = 0;  /* жϱ־,ӦINT0ж */
	if ( InterruptStatus == USB_INT_EP2_OUT ) {  /* ˵´ɹ */
		CH375_CMD_PORT = CMD_RD_USB_DATA;  /* ӵǰUSBжϵĶ˵㻺ȡݿ,ͷŻ */
		Delay2us( );  /* ʱƵʵ16MHzָʱ */
		length = CH375_DAT_PORT;  /* ȶȡݳ */
		if ( length == CONST_CMD_LEN ) {  /* 鳤CONST_CMD_LEN, */
/* ͨUSBյ,CONST_CMD_LEN,ֽΪ,ΪѡĲ,ṹɵƬͼӦò֮ж */
			for ( i=0; i<CONST_CMD_LEN; i++ ) cmd_buf[i] = CH375_DAT_PORT;  /*  */
			if ( CMD_PKT.mCommandCode != (unsigned char)( ~ CMD_PKT.mCommandCodeNot ) ) return;  /* У */
			switch ( CMD_PKT.mCommandCode ) {  /* ,switchöif/else */
				case DEF_CMD_GET_INFORM:  /* ȡλ˵Ϣ,Ȳ64ַ,ַ00H */
					CH375_CMD_PORT = CMD_WR_USB_DATA7;  /* USB˵2ķͻдݿ */
					Delay2us( );  /* ʱƵʵ16MHzָʱ */
					CH375_DAT_PORT = 16;  /* дݳ */
					for ( i=0; i<16; i++ ) CH375_DAT_PORT = InformString[i];  /*  */
					break;
				case DEF_CMD_TEST_DATA:  /* ,λPCȡ󷵻 */
					CH375_CMD_PORT = CMD_WR_USB_DATA7;  /* USB˵2ķͻдݿ */
					Delay2us( );  /* ʱƵʵ16MHzָʱ */
					CH375_DAT_PORT = CONST_CMD_LEN;  /* дݳ */
					for ( i=0; i<CONST_CMD_LEN; i++ ) CH375_DAT_PORT = ~ cmd_buf[i];  /* ,ȡ󷵻,ɼӦóǷȷ */
					break;
				case DEF_CMD_CLEAR_UP:  /* ϴݿ֮ǰͬ,ʵλϴ */
/* ϴݿ֮ǰͬ,ʵõƬϴ
; һνϴʱ,ǰϴ,ôпϴ,ڵڶϴǰҪϴ */
					CH375_CMD_PORT = CMD_SET_ENDP7;  /* USB˵2IN,Ҳϴ˵ */
					Delay2us( );  /* ʱƵʵ16MHzָʱ */
					CH375_DAT_PORT = 0x0e;  /* ͬλ,USB˵2INæ,NAK */
					break;
				case DEF_CMD_UP_DATA:  /* λַָĻжȡݿ(ϴݿ) */
/* ϴݿ, ʵֻʾڲRAM */
/*					switch ( CMD_PKT.u.buf.mBufferID ) {
						case ACCESS_MCS51_SFR:  д51ƬSFR
						case ACCESS_MCS51_IRAM:  д51ƬڲRAM
						case ACCESS_MCS51_XRAM:  д51ƬⲿRAM
					} */
					CurrentRamAddr = (unsigned char)BIG_ENDIAN( CMD_PKT.u.buf.mBufferAddr );  /* ʼַ,ڲRAMֻõ8λַ */
					CurrentRamLen = (unsigned char)BIG_ENDIAN( CMD_PKT.u.buf.mLength );  /* ݿ鳤,ڲRAMܳȲܳ256 */
					len1 = CurrentRamLen >= CH375_MAX_DATA_LEN ? CH375_MAX_DATA_LEN : CurrentRamLen;  /* ϴ,׼һ */
					LoadUpData( CurrentRamAddr, len1);  /* ϴ */
					CurrentRamLen -= len1;
					CurrentRamAddr += len1;
					break;
				case DEF_CMD_DOWN_DATA:  /* λַָĻдݿ(´ݿ) */
/* ´ݿ, ʵֻʾⲿRAM */
					CurrentRamAddr = BIG_ENDIAN( CMD_PKT.u.buf.mBufferAddr );  /* ʼַ */
					CurrentRamLen = BIG_ENDIAN( CMD_PKT.u.buf.mLength );  /* ݿ鳤 */
					break;
				case DEMO_CH451_CMD:  /* PCCH451,ʾCH451Ĺ */
/*; Ϊ˷ֹCH375жϷеCH451_READִCH451_WRITE
; ڴ˱CH451ڿʱCH451 */
					CH451_CMD_L = CMD_PKT.u.mParameter[1];  /* 8λ */
					CH451_CMD_H = CMD_PKT.u.mParameter[2];  /* 4λ */
					break;
				default:
					break;
			}
		}
		else if ( length == 0 ) return;  /* Ϊ0,ûֱ˳,ĳЩӦҲԽ0Ϊһ */
		else {  /*  */
/* ´ݿ,ÿݵĳȲ64ֽ,ܳ150ֽ,1͵264ֽ,3ʣ೤22ֽ
; Ϊ˽ݿֿ,ʣ೤ȲܵCONST_CMD_LEN,ݵİ취ͬ */
			if ( CMD_PKT.mCommandCode == DEF_CMD_DOWN_DATA ) {  /* λַָĻдݿ(´ݿ) */
/* ´ݿ,ÿݵĳȲ64ֽ,ʾûⲿRAM,ⲿRAMЧʺܵ,ڲRAMʾ */
				CurrentRamLen -= length;
				while ( length-- ) {
					*CurrentRamAddr = CH375_DAT_PORT;
					CurrentRamAddr ++;
				}
			}
			else {  /* δ */
				while ( length -- ) c1 = CH375_DAT_PORT;  /*  */
			}
		}
	}
	else if ( InterruptStatus == USB_INT_EP2_IN ) {  /* ݷͳɹ */
		if ( CMD_PKT.mCommandCode == DEF_CMD_UP_DATA ) {  /* λַָĻжȡݿ(ϴݿ) */
			len2 = CurrentRamLen >= CH375_MAX_DATA_LEN ? CH375_MAX_DATA_LEN : CurrentRamLen;  /* ϴ,׼ */
			LoadUpData( CurrentRamAddr, len2 );  /* ϴ */
			CurrentRamLen -= len2;
			CurrentRamAddr += len2;
		}
/* յϴɹжϺ,˳֮ǰUSB,Աշ */
		CH375_CMD_PORT = CMD_UNLOCK_USB;  /* ͷŵǰUSB */
	}
	else if ( InterruptStatus == USB_INT_EP1_IN ) {  /* жݷͳɹ */
		CH375_CMD_PORT = CMD_UNLOCK_USB;  /* ͷŵǰUSB */
		FLAG_INT_WAIT = 0;  /* 巢жϵȴ־,֪ͨӦóԼж */
	}
	else {  /* ù̼USBʽ²Ӧóж״̬ */
	}
}

/* ϴжӳ(ͨж϶˵ϴ),ѡӳ */
void	LoadIntData( unsigned char c1, unsigned char c2 )
{
	unsigned int i;
	for ( i=1000; i!=0; i-- ) {  /* ȴж,ΪPCÿ1Ͷȡж,ȴ1 */
		if ( FLAG_INT_WAIT == 0 ) break;  /* ǰжѾPCȡ */
	}
/* δ,߼еӦóδ,ֳʱ,򲻳1жݾӦñPCȡ */
	EX0 = 0;  /* Ϊ˷ֹ;ж϶˳,Ƚֹж */
	CH375_CMD_PORT = CMD_WR_USB_DATA5;  /* USB˵1ķͻдݿ */
	Delay2us( );
	CH375_DAT_PORT = 2;  /* ݳ */
/* Ȼÿοϴ8ֽ, Ǳڼж, ÿֻҪֽ */
	FLAG_INT_WAIT = 1;  /* жϵȴ־ */
	CH375_DAT_PORT = c1;  /* ж1 */
	CH375_DAT_PORT = c2;  /* ж2 */
	EX0 = 1;  /* ж */
}

/* CH451ʼӳ */
void	CH451_Init( )
{
	CH451_din=0;         /* ȵͺ,ѡ4 */
	CH451_din=1;
	IT1 =0;  /* ⲿźΪ͵ƽ */
	IE1 =0;  /* жϱ־ */
	EX1 =1;  /* ж */
}

/* CH451ӳ */
/* һ޷ͱ洢12ֽڵ */
void	CH451_Write( unsigned int command )
{
  unsigned char i;
  EX1 = 0;  /* ֹж */
  CH451_load=0;  /* ʼ */
  for( i=0; i<12; i++ ) {  /* 12λ,λǰ */
    CH451_din = command & 1;
    CH451_dclk = 0;
    command >>= 1;
    CH451_dclk = 1;  /* Ч,ʱ֪ͨCH451λ */
  }
  CH451_load = 1;  /* ,֪ͨCH451 */
  EX1 = 1;  /* ж */
}

/* ȡCH451ֵӳ */
unsigned char CH451_Read( )
{
  unsigned char i;
  unsigned char command, keycode;
  EX1 = 0;  /* ֹж */
  command=0x07;  /* 451,ֻҪ4λ,8λʡȥ */
  CH451_load=0;  /* ʼ */
  for( i=0; i<4; i++ ){  /* 4λ,λǰ */
    CH451_din = command & 1;
    CH451_dclk = 0;
    command >>= 1;
    CH451_dclk = 1;  /* Ч,ʱ֪ͨCH451λ */
  }
  CH451_load = 1;  /* ,֪ͨCH451 */
  keycode=0;
  for( i=0; i<7; i++ ){  /* ֵ,7λ */
    keycode<<=1;  /* keycode,λǰ,λں */
    keycode|=CH451_dout;  /* ӸߵͶ451 */
    CH451_dclk=0; /* ʱ֪ͨCH451һλ */
    CH451_dclk=1;
  }
  IE1=0;  /* жϱ־,ǶȡʱDOUT͵ƽ */
  EX1=1;
  return( keycode );  /* ؼֵ */
}

/* CH451жϷINT1,ʹüĴ1 */
void	mCH451Interrupt( ) interrupt 2 using 1
{
  unsigned char i, command;
  command=0x07;  /* 451,ֻҪ4λ,8λʡȥ */
  CH451_load=0;  /* ʼ */
  for( i=0; i<4; i++ ){  /* 4λ,λǰ */
    CH451_din = command & 1;
    CH451_dclk = 0;
    command >>= 1;
    CH451_dclk = 1;  /* Ч,ʱ֪ͨCH451λ */
  }
  CH451_load = 1;  /* ,֪ͨCH451 */
  CH451_KEY=0;
  for( i=0; i<7; i++ ){  /* ֵ,7λ */
    CH451_KEY<<=1;  /* ,λǰ,λں */
    CH451_KEY|=CH451_dout;  /* ӸߵͶ451 */
    CH451_dclk=0; /* ʱ֪ͨCH451һλ */
    CH451_dclk=1;
  }
  IE1=0;  /* жϱ־ */
}

/* ɵƬʾ,ȴ,Ȼԭʾ,ټϰֵ */
void	DEMO_CH451_ONLY( )
{
	unsigned char key;
	CH451_Write( 0x0f00 | 0x17 );  /* 1ܼ'H' */
	CH451_Write( 0x0e00 | 0x0e );  /* 1ܼ'E' */
	CH451_Write( 0x0d00 | 0x18 );  /* 1ܼ'L' */
	CH451_Write( 0x0c00 | 0x19 );  /* 1ܼ'P' */
	CH451_Write( 0x0b00 | 0x10 );  /* 1ܼ' ' */
	CH451_Write( 0x0a00 | 0x14 );  /* 1ܼ'[' */
	CH451_Write( 0x0900 | 0x88 );  /* 1ܼ'8.' */
	CH451_Write( 0x0800 | 0x15 );  /* 1ܼ']' */
	CH451_Write( 0x0600 | 0x30 );  /* 3͵4˸ */
	while ( 1 ) {  /* ʾΪʾ, */
		if ( CH451_KEY != 0xff ) {  /* ⵽µİ,ʾʾֵ */
			key = CH451_KEY;
			CH451_KEY = 0xff;  /* ȡֵԭֵ */
			CH451_Write( 0x0300 );  /* һλ */
			CH451_Write( 0x0300 );  /* һλ */
			key &= 0x3f;     /* ֵ0-63 */
			CH451_Write( 0x0900 | ( key / 10 ) );  /* 7ʾֵʮλ */
			CH451_Write( 0x0800 | ( key % 10 ) );  /* 8ʾֵĸλ */
		}
	}
}

/* PCͨUSBʾCH451Ĺ,֤USBͨѶ */
void	DEMO_USB( )
{
	unsigned int  ch451cmd;
	TR0 = 1;  /* ɶʱ0ɼֵα */
	CH451_CMD_H = 0xff;  /* CH451 */
	while ( 1 ) {  /* ָʼѭ,ȴPCв */
		if ( CH451_CMD_H == 0xff ) {  /* ûCH451, ¼ⰴ״̬ */
/*    LAST_KEYCH451_KEY,0FFHûм */
/*    CH451_KEYΪЧֵǼհ, ߶ЧֵͬѾ֪ͨ */
			if ( LAST_KEY == 0xff ) {  /* δ»Ѱµδ֪ͨPC */
				if ( CH451_KEY != 0xff && CH451_KEY >= 0x40 ) {  /* ⵽µļ,Чж,֪ͨPCӦò */
					LAST_KEY = CH451_KEY;
/* 趨ж01H,֪ͨPCӦò,Ѱ, жݵĴֽھǼ,PCӦòֱӻȡֵ,ٶȡ */
					LoadIntData( 1, LAST_KEY );  /* ϴж,ڼж,ÿֻҪֽ */
				}
			}
			else {	/* Ѿ²Ѿ֪ͨPC,Լⰴͷ */
				CH451_KEY = CH451_Read( );  /* ¶ȡһЧļֵ */
				if ( CH451_KEY != LAST_KEY ) {  /* ֵͬ,ѾͷŻ¼,ͬ,˵Ȼûͷ */
/* 趨ж02H,֪ͨPCӦò,ͷ, жݵĴֽھǼ,PCӦòֱӻȡֵ */
					LoadIntData( 2, LAST_KEY ); /* ϴж */
					LAST_KEY = 0xff;  /* ѾͷźŸPC */
				}
			}
		}
		else {  /* CH375жϷнյPCCH451 */
/* PCCH451,еCH451_READܻᱻCH375ĸȼж,ԲCH375жϷִ */
			ch451cmd = ( (unsigned int)CH451_CMD_H << 8 ) + CH451_CMD_L;  /* 4λ8λ */
			CH451_CMD_H = 0xff;  /* ԭ,ֹط */
			CH451_Write( ch451cmd );  /* CH451 */
		}
	}
}

main( ) {
	Delay50ms( );	/* ʱȴCH375ʼ,ƬCH375ṩλź򲻱ʱ */
	CH375_Init( );  /* ʼCH375 */
	CH451_Init( );  /* ʼCH451 */
/* CH451ʾͼɨ */
	CH451_Write( 0x0403 );  /* ϵͳ,ʹʾ,ʹܼ̹ */
	CH451_Write( 0x058C );  /* ʾ,BCD뷽ʽ,12 */
/* CH451̹ǰĴпܲж,Ҫٴȡж */
	IE1 = 0;
	CH451_KEY = 0xff;  /* ,ʹܼǰ,CH451DOUT */
	LAST_KEY = 0xff;  /* пܱжINT1,Ҫ */
	EA = 1;  /* ж */
/* P2ĵ5ź͵6֮϶·ɵƬʾ,PCͨUSBƽʾ */
	if ( T1 ) DEMO_USB( );  /* T1,P3.5ΪĬϵĸߵƽ,PCͨUSBʾ */
	else DEMO_CH451_ONLY( );  /* ɵƬʾ,ȴ,Ȼԭʾ,ټϰֵ */
}
