/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Interface for CH375 **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* CH375 ļϵͳӿ */
/* ֧: FAT12/FAT16/FAT32 */

/* MCS-51ƬCԵUļдʾ, 89C52߸ռĵƬ */
/* ʾADCģɼݱ浽UļMY_ADC.TXT */
/* CH375INT#Ųòѯʽ, ݸƷʽΪ"DPTRP2+R0",ٶ,ǲڴXRAMĵƬ,
   V1.6ϰ汾CH375ӳ,ΪλдUļ,дٶȽֽģʽ,
   ģʽΪλ,ҪݵӦ,ֽģʽ,
   ʾģʽ´,ͬʱ˲ͽϸٶ,ҪļݻFILE_DATA_BUF */


/* C51   CH375HFT.C */
/* LX51  CH375HFT.OBJ , CH375HF4.LIB    CH375HF4CH375HF6Ϳ֧FAT32 */
/* OHX51 CH375HFT */

#include <reg52.h>
#include <stdio.h>
#include <string.h>

/* ¶ϸ˵뿴CH375HF6.Hļ */
#define LIB_CFG_DISK_IO			3		/* ̶дݵĸƷʽ,1Ϊ"DPTR",2Ϊ"˫DPTR",3Ϊ"DPTRP2+R0" */
#define LIB_CFG_FILE_IO			3		/* ļдݵĸƷʽ,0Ϊ"ⲿӳ",1Ϊ"DPTR",2Ϊ"˫DPTR",3Ϊ"DPTRP2+R0" */
#define LIB_CFG_INT_EN			0		/* CH375INT#ӷʽ,0Ϊ"ѯʽ",1Ϊ"жϷʽ" */
/*#define LIB_CFG_FILE_IO_DEFAULT	1*/		/* ʹCH375HF6.HṩĬ"ⲿӳ" */
/*#define LIB_CFG_UPD_SIZE		1*/		/* ݺǷԶļ: 0Ϊ"",1Ϊ"Զ" */
/* Ĭ,/ֽΪ0ôCH375FileWrite/CH375ByteWriteֻдݶ޸ļ,
   ҪÿдݺԶ޸/ļ,ôʹȫֱCH375LibConfigλ4Ϊ1,
   ʱ䲻дӦøļ,ֹͻȻϵǰдļȲ,
   ȷͻȻϵߺܿݲд򲻱ظļ,ٶȲU(Uڲڴ,Ƶд) */

#define CH375_CMD_PORT_ADDR		0xBDF1	/* CH375˿ڵI/Oַ */
#define CH375_DAT_PORT_ADDR		0xBCF0	/* CH375ݶ˿ڵI/Oַ */
/* 62256ṩ32KBRAMΪ: 0000H-01FFHΪ̶д, 0200H-7FFFHΪļݻ */
#define	DISK_BASE_BUF_ADDR		0x0000	/* ⲿRAMĴݻʼַ,ӸõԪʼĻΪSECTOR_SIZE */
#define DISK_BASE_BUF_LEN		4096	/* ĬϵĴݻСΪ512ֽ,ѡΪ20484096֧ĳЩU,Ϊ0ֹ.Hļж建ӦópDISK_BASE_BUFָ */
/* ҪôݻԽԼRAM,ôɽDISK_BASE_BUF_LENΪ0Խֹ.Hļж建,ӦóڵCH375Init֮ǰõĻʼַpDISK_BASE_BUF */
#define FILE_DATA_BUF_ADDR		0x1000	/* ⲿRAMļݻʼַ,ȲСһζдݳ */
/* ʾõ62256ֻ32Kֽ,CH375ӳ512ֽ,ⲿRAMʣ೤Ϊ32256ֽ */
#define FILE_DATA_BUF_LEN		0x3E00	/* ⲿRAMļݻ,ȲСһζдݳ,ҪС0x400 */
/* ׼ʹ˫д,ôҪFILE_DATA_BUF_LEN,ڲַָ,CH375FileReadXCH375FileRead,CH375FileWriteXCH375FileWrite */

#define CH375_INT_WIRE			INT0	/* P3.2, INT0, CH375жINT#,CH375INT#,ڲѯж״̬ */

#define NO_DEFAULT_CH375_F_ENUM		1		/* δCH375FileEnumerʽֹԽԼ */
#define NO_DEFAULT_CH375_F_QUERY	1		/* δCH375FileQueryʽֹԽԼ */

#include "..\CH375HF6.H"				/* Ҫ֧FAT32,ôѡCH375HF4.H */

/* P1.4һLEDڼʾĽ,͵ƽLED,U̲ */
sbit P1_4  = P1^4;
#define LED_OUT_INIT( )		{ P1_4 = 1; }	/* P1.4 ߵƽ */
#define LED_OUT_ACT( )		{ P1_4 = 0; }	/* P1.4 ͵ƽLEDʾ */
#define LED_OUT_INACT( )	{ P1_4 = 1; }	/* P1.4 ͵ƽLEDʾ */
sbit P1_5  = P1^5;
/* P1.5һLEDڼʾĽ,͵ƽLED,U̲ʱ */
#define LED_RUN_ACT( )		{ P1_5 = 0; }	/* P1.5 ͵ƽLEDʾ */
#define LED_RUN_INACT( )	{ P1_5 = 1; }	/* P1.5 ͵ƽLEDʾ */
sbit P1_6  = P1^6;
/* P1.6һLEDڼʾĽ,͵ƽLED,Uдʱ */
#define LED_WR_ACT( )		{ P1_6 = 0; }	/* P1.6 ͵ƽLEDʾ */
#define LED_WR_INACT( )		{ P1_6 = 1; }	/* P1.6 ͵ƽLEDʾ */

/* ԺΪλʱ,ȷ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* ռַƵڲRAM,ַ */
UINT8	mCopyCodeStringToIRAM( UINT8 idata *iDestination, UINT8 code *iSource )
{
	UINT8	i = 0;
	while ( *iDestination = *iSource ) {
		iDestination ++;
		iSource ++;
		i ++;
	}
	return( i );
}

/* ״̬,ʾ벢ͣ */
void	mStopIfError( UINT8 iError )
{
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
	printf( "Error: %02X\n", (UINT16)iError );  /* ʾ */
	while ( 1 ) {
		LED_OUT_ACT( );  /* LED˸ */
		mDelaymS( 200 );
		LED_OUT_INACT( );
		mDelaymS( 200 );
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x21;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

UINT16	total;	/* ¼ǰFILE_DATA_BUFеݳ */

/* ׼дU̵ݽмл,ϳɴݿʱͨCH375дU */
/* ĺô: ٶ(ΪݿдʱЧʸ), U(Uڲڴ,Ƶд) */
void	mFlushBufferToDisk( UINT8 force )
/* force = 0 Զˢ(黺еݳ,д,ʱڻ), force != 0 ǿˢ(ܻежٶд,ͨϵͳػǰӦǿд) */
{
	UINT8	i;
	UINT32	NewSize;
	if ( force ) {  /* ǿˢ */
		mCmdParam.Write.mSectorCount = ( total + CH375vSectorSize - 1 ) / CH375vSectorSize;  /* еֽתΪ(CH375vSectorSize),ȼCH375vSectorSize-1ȷдͷ */
		i = CH375FileWrite( );  /* Ϊλļд,д뻺е,ͷ */
		mStopIfError( i );
/* ЩUܻ̿Ҫдݺȴһܼ,,ĳЩUзݶʧ,ÿдݺʱټ */
		mDelaymS( 1 );  /* дʱ,ѡ,U̲Ҫ */
		memcpy( FILE_DATA_BUF+0, FILE_DATA_BUF+(total & ~ ( CH375vSectorSize - 1 ) ), total & ( CH375vSectorSize - 1 ) );  /* ղдU̵ͷݸƵͷ */
		total &= CH375vSectorSize - 1;  /* ֻʣ¸ղдU̵ͷ,ڻΪ˷Ժ׷ */
		if ( total ) NewSize = CH375vFileSize - CH375vSectorSize + total;  /* Ϊλ,ͷ,ļ(Чݵĳ) */
		else NewSize = CH375vFileSize;  /* Ϊλ,ûͷ,ļCH375vSectorSizeı */
		mCmdParam.Modify.mFileSize = NewSize;   /* : µļ,ģʽ漰ͷݲԶ³ */
		mCmdParam.Modify.mFileAttr = 0xff;  /* : µļ,Ϊ0FFH޸ */
		mCmdParam.Modify.mFileTime = 0xffff;  /* : µļʱ,Ϊ0FFH޸ */
		mCmdParam.Modify.mFileDate = 0xffff;  /* : µļ,Ϊ0FFH޸ */
		i = CH375FileModify( );   /* ޸ĵǰļϢ,޸ļ */
		mStopIfError( i );
		printf( "Current file size is %ld\n", CH375vFileSize );
		mCmdParam.Locate.mSectorOffset = 0xffffffff;  /* Ƶļβ,Ϊλ,Իļβͷ */
		i = CH375FileLocate( );  /* »صԭļβ,дݽβͷ,ͷһݸڻ, */
		mStopIfError( i );
	}
	else if ( total >= FILE_DATA_BUF_LEN - CH375vSectorSize ) {  /* еݿҪ,ӦȽеԭдU */
		mCmdParam.Write.mSectorCount = total / CH375vSectorSize;  /* еֽתΪ(CH375vSectorSize),ͷȲ */
/* ʹCH375FileWriteX()CH375FileWrite()жݻʼַ,
		mCmdParam.WriteX.mDataBuffer = 0x4600;  4600HʼĻед
		i = CH375FileWriteX();   ָ4600Hед뵽ļ */
		i = CH375FileWrite( );  /* Ϊλļд,д뻺е,ͷ */
		mStopIfError( i );
		memcpy( FILE_DATA_BUF+0, FILE_DATA_BUF+(total & ~ ( CH375vSectorSize - 1 ) ), total & ( CH375vSectorSize - 1 ) );  /* ղδдU̵ͷݸƵͷ */
		total &= CH375vSectorSize - 1;  /* ֻʣ¸ղδдU̵ͷ */
/*		mCmdParam.Write.mSectorCount = 0;  ȫֱCH375LibConfigλ4Ϊ0,ָд0,ˢļĳ
		CH375FileWrite( );  Ϊλļд,Ϊ0д,ֻڸļĳ,׶дݺ,ְ취ļ */
	}
}

main( ) {
	UINT8	i, month, date, hour;
	UINT16	year, adc;
	LED_OUT_INIT( );
	LED_OUT_ACT( );  /* LEDһʾ */
	mDelaymS( 100 );  /* ʱ100 */
	LED_OUT_INACT( );
	mInitSTDIO( );  /* Ϊüͨڼʾ */
	printf( "Start\n" );

#if DISK_BASE_BUF_LEN == 0
	pDISK_BASE_BUF = &my_buffer[0];  /* .HļжCH375רû,ûָָӦóĻںԽԼRAM */
#endif

	i = CH375LibInit( );  /* ʼCH375CH375оƬ,ɹ0 */
	mStopIfError( i );
/* ·ʼ */

	while ( 1 ) {
		printf( "Wait Udisk\n" );
//		while ( CH375DiskStatus != DISK_CONNECT ) xQueryInterrupt( );  /* ѯCH375жϲж״̬,ȴU̲ */
		while ( CH375DiskStatus < DISK_CONNECT ) {  /* ѯCH375жϲж״̬,ȴU̲ */
			if ( CH375DiskConnect( ) == ERR_SUCCESS ) break;  /* 豸򷵻سɹ,CH375DiskConnectͬʱȫֱCH375DiskStatus */
			mDelaymS( 100 );
		}
		LED_OUT_ACT( );  /* LED */
		mDelaymS( 200 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */

/* UǷ׼,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 5; i ++ ) {  /* еUǷδ׼,Ա */
			mDelaymS( 100 );
			printf( "Ready ?\n" );
			if ( CH375DiskReady( ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
#if DISK_BASE_BUF_LEN
		if ( DISK_BASE_BUF_LEN < CH375vSectorSize ) {  /* ݻǷ㹻,CH375vSectorSizeU̵ʵС */
			printf( "Too large sector size\n" );
			while ( CH375DiskConnect( ) == ERR_SUCCESS ) mDelaymS( 100 );
			continue;
		}
#endif
/* ѯ */
		printf( "DiskSize\n" );
		i = CH375DiskSize( );  
		mStopIfError( i );
		printf( "TotalSize = %u MB \n", (unsigned int)( mCmdParam.DiskSize.mDiskSizeSec * (CH375vSectorSize/512) / 2048 ) );  // ʾΪMBΪλ
		// ԭ㷽 (unsigned int)( mCmdParam.DiskSize.mDiskSizeSec * CH375vSectorSize / 1000000 ) пǰ˺, ޸ĳʽ
		LED_RUN_ACT( );  /* ʼU */

/* MY_ADC.TXTļѾݵβ,½ļ */
		printf( "Open\n" );
		mCopyCodeStringToIRAM( mCmdParam.Open.mPathName, "/MY_ADC.TXT" );  /* ļ,ļڸĿ¼ */
		i = CH375FileOpen( );  /* ļ */
		if ( i == ERR_SUCCESS ) {  /* ļڲѾ,ƶļָ뵽βԱ */
			printf( "File size = %ld\n", CH375vFileSize );  /* V1.5ӳڳɹļ,ȫֱCH375vFileSizeļǰ */
			printf( "Locate tail\n" );
			mCmdParam.Locate.mSectorOffset = 0xffffffff;  /* Ƶļβ,CH375ӳڲǽļȰCH375vSectorSizeȡ */
			i = CH375FileLocate( );  /* ΪλƵļβ,ļβвһͷ򱻺,ôͷݽܱдݸ */
			mStopIfError( i );
			total = CH375vFileSize & ( CH375vSectorSize - 1 );  /* ϴαļʱβͷ,ôȡͷֽ,ȵ */
			printf( "Read last tail = %d Bytes\n", total );
			CH375vFileSize += CH375vSectorSize - 1;  /* Ϊؽļһ1,Աһеͷ */
			mCmdParam.Read.mSectorCount = 1;  /* ȡļβͷ,Ϊļ,ôļȰCH375vSectorSizeȡ,βͷ޷ */
/* ʹCH375FileReadX()CH375FileRead()жݻʼַ,
			mCmdParam.ReadX.mDataBuffer = 0x2C00;  ݷŵ2C00HʼĻ
			i = CH375FileReadX();   ļжȡָ,ʼַΪ2C00H */
			i = CH375FileRead( );  /* ļȡβͷ,ԭβûͷ,ôʲôҲ,ʱmCmdParam.Read.mSectorCountΪʵʶ */
			mStopIfError( i );
			CH375vFileSize -= CH375vSectorSize - 1;  /* ָļ */
			mCmdParam.Locate.mSectorOffset = 0xffffffff;  /* Ƶļβ,Ϊλ,Իļβͷ */
			i = CH375FileLocate( );  /* »صԭļβ,дݽԭβͷ,ԭͷݸղѾڴ, */
			mStopIfError( i );
		}
		else if ( i == ERR_MISS_FILE ) {  /* ûҵļ,½ļ */
			LED_WR_ACT( );  /* д */
			printf( "Create\n" );
//			mCopyCodeStringToIRAM( mCmdParam.Create.mPathName, "/MY_ADC.TXT" );  /* ļ,ļڸĿ¼,ղѾṩCH375FileOpen */
			i = CH375FileCreate( );  /* ½ļ,ļѾɾ½ */
			mStopIfError( i );
			total = 0;  /* ǰûͷ */
		}
		else mStopIfError( i );  /* ļʱ */
		LED_WR_ACT( );  /* д */
		printf( "Write begin\n" );
		total += sprintf( FILE_DATA_BUF + total, "ڱ֮ǰ,ļݵĳ %ld ֽ\xd\xa", CH375vFileSize );  /* ӵβ,ۼƻڵݳ */
		mFlushBufferToDisk( 0 );  /* Զˢ»,黺Ƿ,д */
		printf( "Write ADC data\n" );
		TR0=1;  /* öʱ0ļֵADC */
		for ( month = 1; month != 12; month ++ ) {  /* Ϊ԰ûʵʱʱоƬ,ѭʽģ· */
			for ( date = 1; date != 30; date ++ ) {  /* Ϊ԰ûʵʱʱоƬ,ѭʽģ */
				year = 2004;  /* ٶΪ2004 */
				hour = TL1 & 0x1F;  /* Ϊ԰ûʵʱʱоƬ,öʱ1ļʾ */
/*				adc = get_adc_data( ); */
				adc = ( (UINT16)TH0 << 8 ) | TL0;  /* Ϊ԰ûADC,öʱ0ļADCʾ */
				total += sprintf( FILE_DATA_BUF + total, "Year=%04d, Month=%02d, Date=%02d, Hour=%02d, ADC_data=%u\xd\xa", year, (UINT16)month, (UINT16)date, (UINT16)hour, adc );  /* ݸʽΪһַ */
				if ( month == 6 && ( date & 0x0F ) == 0 ) mFlushBufferToDisk( 1 );  /* ǿˢ»,ǿˢ»,ͻȻϵԼݶʧ */
				else mFlushBufferToDisk( 0 );  /* Զˢ»,黺Ƿ,д */
				printf( "Current total is %d\n", total );  /* ڼؼ */
			}
		}
		printf( "Write end\n" );
		total += sprintf( FILE_DATA_BUF + total, " ********************************* " );  /* ӵβ,ۼƻڵݳ */
		total += sprintf( FILE_DATA_BUF + total, "εADCݵ˽,򼴽˳\xd\xa" );  /* ӵβ,ۼƻڵݳ */
		mFlushBufferToDisk( 1 );  /* ǿˢ»,ΪϵͳҪ˳,Աǿˢ */
		printf( "Close\n" );
		mCmdParam.Close.mUpdateLen = 0;  /* Ϊǿˢ»ʱѾļ,ﲻҪԶļ */
		i = CH375FileClose( );  /* رļ */
		mStopIfError( i );
		LED_WR_INACT( );
		LED_RUN_INACT( );
		printf( "Take out\n" );
//		while ( CH375DiskStatus != DISK_DISCONNECT ) xQueryInterrupt( );  /* ѯCH375жϲж״̬,ȴṴγ */
		while ( CH375DiskStatus >= DISK_CONNECT ) {  /* ѯCH375жϲж״̬,ȴṴγ */
			if ( CH375DiskConnect( ) != ERR_SUCCESS ) break;
			mDelaymS( 100 );
		}
		LED_OUT_INACT( );  /* LED */
		mDelaymS( 200 );
	}
}
