/*
****************************************
**  Copyright  (C)  W.ch  1999-2007   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Module      @CH375  **
****************************************
*/
/* CH375 ļϵͳӿģ */
/* ֧: FAT12/FAT16/FAT32 */
/* UļдģCͷļ */

#ifndef __CH375HM_H__
#define __CH375HM_H__

#define CH375HM_VER				0x30	/* ǰģ汾 */

/* ********************************************************************************************************************* */
/* صĲ״̬ */
/* ¼֪ͨ״̬,⵽ǰUѾӻѾϿ,Ϊ״̬ */
#define	ERR_USB_CONNECT			0x15	/* ⵽USB豸¼,Ѿ */
#define ERR_DISK_DISCON			0x82	/* ⵽USB豸¼,ѾϿ,ߴδ */
/* 0XHUSB豸ʽĲ״̬,CH375,USB豸ģʽж״̬ */
#define	ERR_USB_DAT_DOWN		0x02	/* USB豸ģʽ: ´ɹ,λ´Ѿģ */
#define	ERR_USB_DAT_UP			0x0A	/* USB豸ģʽ: ϴɹ,ģеϴѾλȡ */
/* ǽ׶Ե״̬,ݽ,յĲ״̬ */
#define	USB_INT_DISK_READ		0x1D	/* USB洢ݿ,ֻCMD_FileRead,ݶ */
#define	USB_INT_DISK_WRITE		0x1E	/* USB洢дݿ,ֻCMD_FileWrite,д */
#define	USB_INT_DISK_RETRY		0xEE	/* USB洢дݿʧ,ֻCMD_FileReadCMD_FileRead,ʧ */
/* USB_INT_DISK_RETRY״̬Ҫû˳ظļݻָ,Ա·ͻ߽ļ,
   USB_INT_DISK_RETRY״̬֮û˳յֽڵ,Ҳһ16λ,ָҪظָֽ,ʱֽǰ,Сʱֽǰ */
/* ״̬ */
#define ERR_SUCCESS				0x00	/* ɹ */
#define ERR_CH375_ERROR			0x81	/* CH375Ӳ,ҪλCH375 */
#define ERR_STATUS_ERR			0x83	/* ״̬,ӻ߶Ͽ */
#define ERR_MBR_ERROR			0x91	/* ̵¼Ч,ܴδδʽ */
#define ERR_TYPE_ERROR			0x92	/* ̷Ͳ֧,ֻ֧FAT12/FAT16/BigDOS/FAT32,Ҫɴ̹· */
#define ERR_BPB_ERROR			0xA1	/* δʽ,߲,ҪWINDOWSĬϲ¸ʽ */
#define ERR_TOO_LARGE			0xA2	/* ̷ʽ4GB,250GB,ҪWINDOWSĬϲ¸ʽ */
#define ERR_FAT_ERROR			0xA3	/* ̵ļϵͳ֧,ֻ֧FAT12/FAT16/FAT32,ҪWINDOWSĬϲ¸ʽ */
#define ERR_DISK_FULL			0xB1	/* ļ̫,ʣռ̫ٻѾû,Ҫ */
#define ERR_FDT_OVER			0xB2	/* Ŀ¼ļ̫,ûпеĿ¼,FAT12/FAT16Ŀ¼µļӦ500,Ҫ */
#define ERR_MISS_DIR			0xB3	/* ָ·ĳĿ¼ûҵ,Ŀ¼ƴ */
#define ERR_FILE_CLOSE			0xB4	/* ļѾر,Ҫʹ,Ӧ´ļ */
#define ERR_OPEN_DIR			0x41	/* ָ·Ŀ¼ */
#define ERR_MISS_FILE			0x42	/* ָ·ļûҵ,ļƴ */
#define ERR_FOUND_NAME			0x43	/* ͨƥļ,ļ·,Ҫʹ,Ӧô򿪸ļ */
#define	ERR_USB_DISK_ERR		0x1F	/* USB洢ʧ,ڳʼʱUSB洢֧,ڶдпǴ𻵻ѾϿ */
/* δ,ԷCMD_QueryStatusѯģ״̬ */

/* ********************************************************************************************************************* */
/* ̼ļ״̬,CMD_PARAM.Status.mDiskStatus */
#define DISK_UNKNOWN			0x00	/* δʼ,δ֪״̬ */
#define DISK_DISCONNECT			0x01	/* ûӻѾϿ */
#define DISK_CONNECT			0x02	/* Ѿ,δʼ޷ʶô */
#define DISK_MOUNTED			0x03	/* Ѿʼɹ,δļϵͳļϵͳ֧ */
#define DISK_READY				0x10	/* Ѿ̵ļϵͳܹ֧ */
#define DISK_OPEN_ROOT			0x12	/* Ѿ򿪸Ŀ¼,ģʽ,ֻΪλдĿ¼,ʹúر,עFAT12/FAT16Ŀ¼ǹ̶ */
#define DISK_OPEN_DIR			0x13	/* ѾĿ¼,ģʽ,ֻΪλдĿ¼ */
#define DISK_OPEN_FILE			0x14	/* Ѿļ,ģʽ,Ϊλݶд */
#define DISK_OPEN_FILE_B		0x15	/* Ѿļ,ֽģʽ,ֽΪλݶд */

/* ********************************************************************************************************************* */
/* FATͱ־,CMD_PARAM.Query.mDiskFat */
#define DISK_FS_UNKNOWN			0		/* δ֪ļϵͳ */
#define DISK_FAT12				1		/* FAT12ļϵͳ */
#define DISK_FAT16				2		/* FAT16ļϵͳ */
#define DISK_FAT32				3		/* FAT32ļϵͳ */

/* ********************************************************************************************************************* */
/* ļ,CMD_PARAM.Modify.mFileAttr */
#define ATTR_READ_ONLY			0x01	/* ļΪֻ */
#define ATTR_HIDDEN				0x02	/* ļΪ */
#define ATTR_SYSTEM				0x04	/* ļΪϵͳ */
#define ATTR_VOLUME_ID			0x08	/*  */
#define ATTR_DIRECTORY			0x10	/* Ŀ¼ */
#define ATTR_ARCHIVE			0x20	/* ļΪ浵 */
#define ATTR_LONG_NAME			( ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_VOLUME_ID )
/* ļ unsigned char */
/* bit0 bit1 bit2 bit3 bit4 bit5 bit6 bit7 */
/*  ֻ      ϵ      Ŀ      δ   */
/*        ͳ      ¼               */
/* ļʱ unsigned short,CMD_PARAM.Modify.mFileTime */
/* Time = (Hour<<11) + (Minute<<5) + (Second>>1) */
#define MAKE_FILE_TIME( h, m, s )	( (h<<11) + (m<<5) + (s>>1) )	/* ָʱļʱ */
/* ļ unsigned short,CMD_PARAM.Modify.mFileDate */
/* Date = ((Year-1980)<<9) + (Month<<5) + Day */
#define MAKE_FILE_DATE( y, m, d )	( ((y-1980)<<9) + (m<<5) + d )	/* ָյļ */

/* ********************************************************************************************************************* */
/* ļ,CMD_PARAM.?.mPathName */
#define PATH_WILDCARD_CHAR		0x2A	/* ·ͨ '*' */
#define PATH_SEPAR_CHAR1		0x5C	/* ·ķָ '\' */
#define PATH_SEPAR_CHAR2		0x2F	/* ·ķָ '/' */
#ifndef MAX_PATH_LEN
#define MAX_PATH_LEN			65		/* ·,бָܷСԼ·00H,ڷʽֵΪ62 */
#endif
#if		MAX_PATH_LEN		>	65
#undef	MAX_PATH_LEN
#define MAX_PATH_LEN			65
#endif
#ifndef MAX_BYTE_IO
#define MAX_BYTE_IO				( MAX_PATH_LEN - 1 )	/* ֽΪλζдļʱ󳤶,óȿԷֶζд,ڷʽֵΪ61 */
#endif
#if		MAX_BYTE_IO			>	64
#undef	MAX_BYTE_IO
#define	MAX_BYTE_IO				64
#endif

/* ********************************************************************************************************************* */
/* ⲿ */
#define	CMD_QueryStatus			0x60	/* ѯǰģ״̬ */
#define	CMD_DiskQuery			0x61	/* ѯϢ */
#define	CMD_FileEnumer			0x63	/* öļ,ļ */
#define	CMD_FileOpen			0x64	/* ļ */
#define	CMD_FileCreate			0x65	/* ½ļ,ļѾɾ½ */
#define	CMD_FileErase			0x66	/* ɾļر */
#define	CMD_FileClose			0x67	/* رյǰļ */
#define	CMD_FileQuery			0x68	/* ѯǰļϢ */
#define	CMD_FileModify			0x69	/* ѯ޸ĵǰļϢ */
#define	CMD_FileLocate			0x6A	/* ƶǰļָ */
#define	CMD_FileRead			0x6B	/* ӵǰļȡ */
#define	CMD_FileWrite			0x6C	/* ǰļд */
#define	CMD_ByteLocate			0x7A	/* ֽΪλƶǰļָ */
#define	CMD_ByteRead			0x7B	/* ֽΪλӵǰļȡݿ */
#define	CMD_ByteWrite			0x7C	/* ֽΪλǰļдݿ */
#define	CMD_BulkOnlyCmd			0x70	/* ִлBulkOnlyЭ */
#define	CMD_DiskReady			0x71	/* ѯǷ׼ */
#define	CMD_DiskSize			0x72	/* ѯ */
#define	CMD_FileDirInfo			0x75	/* ȡǰѴļĿ¼Ϣ */
#define	CMD_DirCreate			0x76	/* ½Ŀ¼,Ŀ¼ѾֱӴ */
#define	CMD_FileReadLast		0x77	/* ӵǰļβȡһȵ */
#define	CMD_SetFileSize			0x78	/* ޸ģϵͳӳļȱ */
#define	CMD_StreamRead			0x7E	/* ģʽļ,ִֻ֧,ֻ֧ı */
#define	CMD_StreamWrite			0x7F	/* ģʽдļ,ִֻ֧,ֻ֧ı */
/* USB豸ʽ */
#define	CMD_SetUsbId			0x12	/* USB豸ģʽ: USB豸ĳVIDͲƷPID */
#define	CMD_SetUsbMode			0x15	/* USB豸ģʽ: USB/豸ģʽ,ִֻ֧ */
#define	CMD_ReadUsbData			0x28	/* USB豸ģʽ: ģ´˵ȡݿ */
#define	CMD_WriteUsbData		0x2B	/* USB豸ģʽ: ģϴ˵дݿ */
/*  */
#define	CMD_GetVer				0x0A	/* ȡǰģİ汾 */
#define	CMD_ResetInit			0x0B	/* λ³ʼCH375Լģ */
#define	CMD_BaudRate			0xA5	/* ôͨѶ */
#define	CMD_SetupModule			0xA6	/* ģ */
#define	CMD_DirectWrCmd			0xB9	/* ֱӴݸCH375,д */
#define	CMD_DirectRdDat			0xB5	/* ֱӴݸCH375, */
#define	CMD_DirectWrDat			0xB6	/* ֱӴݸCH375,д */
#define	CMD_GetStringSN			0xA0	/* ȡƷкַ */

/* ********************************************************************************************************************* */
/* ⲿ */
typedef union _CMD_PARAM {
	struct {
		unsigned char	mBuffer[ MAX_PATH_LEN ];
	} Other;
	struct {
		unsigned long	mDiskSizeSec;			/* : ̵ */
		unsigned long	mTotalSector;			/* : ǰ߼̵ */
		unsigned long	mFreeSector;			/* : ǰ߼̵ʣ */
		unsigned char	mDiskFat;				/* : ǰ߼̵FAT */
	} Query;									/* CMD_DiskQuery, ѯϢ */
	struct {
		unsigned char	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Open;										/* CMD_FileOpen, ļ */
	struct {
		unsigned char	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ(ͨ*)...,ö], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILE*",00H */
	} Enumer;									/* CMD_FileEnumer, öļ,ļ */
	struct {
		unsigned char	mUpdateLen;				/* : Ƿ³: 0ֹ,1 */
	} Close;									/* CMD_FileClose, رյǰļ */
	struct {
		unsigned char	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Create;									/* CMD_FileCreate, ½ļ,ļѾɾ½ */
	struct {
		unsigned char	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Erase;									/* CMD_FileErase, ɾļر */
	struct {
		unsigned long	mFileSize;				/* : µļ,Ϊ0FFFFFFFFH޸, : ԭ */
		unsigned short	mFileDate;				/* : µļ,Ϊ0FFFFH޸, : ԭ */
		unsigned short	mFileTime;				/* : µļʱ,Ϊ0FFFFH޸, : ԭʱ */
		unsigned char	mFileAttr;				/* : µļ,Ϊ0FFH޸, : ԭ */
	} Modify;									/* CMD_FileQuery, ѯǰļϢ; CMD_FileModify, ѯ޸ĵǰļϢ */
	struct {
		unsigned long	mSectorOffset;			/* : ƫ,0ƶļͷ,0FFFFFFFFHƶļβ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
	} Locate;									/* CMD_FileLocate, ƶǰļָ */
	struct {
		unsigned char	mSectorCount;			/* : ȡ, : ʵʶȡ */
	} Read;										/* CMD_FileRead, ӵǰļȡ */
	struct {
		unsigned char	mSectorCount;			/* : д, : ʵд */
	} Write;									/* CMD_FileWrite, ǰļд */
	struct {
		unsigned long	mDiskSizeSec;			/* : ̵ */
	} DiskSize;									/* CMD_DiskSize, ѯ */
	struct {
		unsigned long	mByteOffset;			/* : ֽΪλƫ, ֽΪλļָ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
	} ByteLocate;								/* CMD_ByteLocate, ֽΪλƶǰļָ */
	struct {
		unsigned char	mByteCount;				/* : ׼ȡֽ,ôMAX_BYTE_IO, : ʵʶֽ */
		unsigned char	mByteBuffer[ MAX_BYTE_IO ];	/* : ݿ */
	} ByteRead;									/* CMD_ByteRead, ֽΪλӵǰļȡݿ */
	struct {
		unsigned char	mByteCount;				/* : ׼дֽ,ôMAX_BYTE_IO,Ϊ0ˢļȶд,Ϊ0дݵˢļ, : ʵдֽ */
		unsigned char	mByteBuffer[ MAX_BYTE_IO ];	/* : ׼дݿ */
	} ByteWrite;								/* CMD_ByteWrite, ֽΪλǰļдݿ */
	union {
		struct {
			unsigned long	mCBW_Sig;
			unsigned long	mCBW_Tag;
			unsigned char	mCBW_DataLen;		/* : ݴ䳤,Чֵ0255 */
			unsigned char	mCBW_DataLen1;
			unsigned char	mCBW_DataLen2;
			unsigned char	mCBW_DataLen3;
			unsigned char	mCBW_Flag;			/* : ䷽ȱ־ */
			unsigned char	mCBW_LUN;
			unsigned char	mCBW_CB_Len;		/* : ĳ,Чֵ116 */
			unsigned char	mCBW_CB_Buf[1];		/* : ,ûΪ16ֽ */
		} mCBW;									/* BulkOnlyЭ, CBWṹ */
		struct {
			unsigned long	mCSW_Sig;
			unsigned long	mCSW_Tag;
			unsigned long	mCSW_Residue;		/* : ʣݳ */
			unsigned char	mCSW_Status;		/* : ִн״̬ */
			unsigned char	mReserved;
		} mCSW;									/* BulkOnlyЭ״̬, CSWṹ */
	} BOC;										/* CMD_BulkOnlyCmd, ִлBulkOnlyЭ, ݴôDISK_BASE_BUF */
	struct {
		unsigned char	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} DirCreate;								/* CMD_DirCreate, ½Ŀ¼,Ŀ¼ѾֱӴ */
	struct {
		unsigned char	mSectorCount;			/* : ʵʶȡ,Ϊ1Ѿȡ,Ϊ0û(ļ512ı) */
	} ReadLast;									/* CMD_FileReadLast, ӵǰļβȡһȵ */
	struct {
		unsigned char	mAccessMode;			/* : ȡʽ, 0=ȡļĿ¼Ϣ,0F0H=д/ļĿ¼Ϣ,ֵЧ */
		unsigned char	mReserved[3];
		struct {								/* ýṹеĳԱ붼С˸ʽ,ⲿƬǴ˸ʽ,ôҪдС˸ʽת */
			unsigned char	DIR_Name[11];		/* 00H,ļ,11ֽ,㴦ո */
			unsigned char	DIR_Attr;			/* 0BH,ļ,ο˵ */
/* bit0  bit1  bit2  bit3  bit4  bit5  bit6 bit7 */
/* ֻ    ϵͳ    Ŀ¼  浵  δ    */
			unsigned char	DIR_NTRes;			/* 0CH */
			unsigned char	DIR_CrtTimeTenth;	/* 0DH,ļʱ,0.1뵥λ */
			unsigned short	DIR_CrtTime;		/* 0EH,ļʱ,οǰĺMAKE_FILE_TIME,С˸ʽ */
			unsigned short	DIR_CrtDate;		/* 10H,ļ,οǰĺMAKE_FILE_DATE,С˸ʽ */
			unsigned short	DIR_LstAccDate;		/* 12H,һδȡ,οǰĺMAKE_FILE_DATE,С˸ʽ */
			unsigned short	DIR_FstClusHI;		/* 14H */
			unsigned short	DIR_WrtTime;		/* 16H,ļ޸ʱ,ο˵ǰĺMAKE_FILE_TIME,С˸ʽ */
/* ļʱ UINT16: Time = (Hour<<11) + (Minute<<5) + (Second>>1) */
			unsigned short	DIR_WrtDate;		/* 18H,ļ޸,ο˵ǰĺMAKE_FILE_DATE,С˸ʽ */
/* ļ UINT16: Date = ((Year-1980)<<9) + (Month<<5) + Day */
			unsigned short	DIR_FstClusLO;		/* 1AH */
			unsigned long	DIR_FileSize;		/* 1CH,ļ,С˸ʽ */
		} mDir;									/* 20H */
	} FileDirInfo;								/* CMD_FileDirInfo, ȡǰѴļĿ¼Ϣ */
	struct {
		unsigned char	mLastStatus;			/* : ϴεĲ״̬ */
		unsigned char	mDiskStatus;			/* : ̼ļ״̬ */
		unsigned char	mIntStatus;				/* : CH375ж״̬ */
		unsigned char	reserved;
		unsigned long	mFileSize;				/* : ǰļĳ */
		unsigned long	mCurrentOffset;			/* : ǰļָ,ǰдλõֽƫ */
	} Status;									/* CMD_QueryStatus, ѯǰģ״̬ */
	struct {
		unsigned long	mFileSize;				/* : ָµļȱ,ֻ޸ӳı,ֻڸļȺӰʵļ */
	} SetFileSize;								/* CMD_SetFileSize, ޸ģϵͳӳļȱ */
	struct {
		unsigned char	mFileLibVer;			/* : ӳİ汾 */
		unsigned char	mModuleVer;				/* : ģİ汾 */
		unsigned char	mUsbIcVer;				/* : USBоƬ汾:10H-CH375S,2xH-CH375A */
	} GetVer;									/* CMD_GetVer, ȡǰģİ汾 */
	struct {
		unsigned char	mDivisor;				/* : ͨѶʳ */
	} BaudRate;									/* CMD_BaudRate, ôͨѶ */
	struct {
		unsigned char	mSetup;					/* : ģֵ */
/* λ7λ6: ֽ˳: 00-ֵǰʽ, 01-С˸ʽLITTLE_ENDIAN, 10-ô˸ʽBIG_ENDIAN, 11-/ֵǰʽ */
/* λ4: ļдݺԶļ(CH375LibConfigλ4):0ֹ,1 */
/* λ0: ʱѯU״̬Զж֪ͨ:0ֹ,1 */
	} Setup;									/* CMD_SetupModule, ģ */
	struct {
		unsigned char	mData;					/* ߷: ֽ */
	} Direct;									/* CMD_DirectWrCmd, ֱӴݸCH375,д; CMD_DirectRdDat, ֱӴݸCH375,; CMD_DirectWrDat, ֱӴݸCH375,д */
	struct {
		unsigned char	mStringSN[16];			/* : Ʒкַ */
	} GetSN;									/* CMD_GetStringSN, ȡƷкַ */
	struct {
		unsigned char	mVidLow;				/* : IDֽ */
		unsigned char	mVidHigh;				/* : IDֽ */
		unsigned char	mPidLow;				/* : ƷIDֽ */
		unsigned char	mPidHigh;				/* : ƷIDֽ */
	} SetUsbId;									/* CMD_SetUsbId, USB豸ģʽ: USB豸ĳVIDͲƷPID */
	struct {
		unsigned char	mUsbMode;				/* : ģʽ, 0=, 2=USB豸ģʽ, 6=USBģʽ */
	} SetUsbMode;								/* CMD_SetUsbMode, USB豸ģʽ: USB/豸ģʽ,ִֻ֧ */
	struct {
		unsigned char	mByteCount;				/* : ֽ */
		unsigned char	mByteBuffer[ MAX_BYTE_IO ];	/* : ݿ */
	} ReadUsbData;								/* CMD_ReadUsbData, USB豸ģʽ: ģ´˵ȡݿ */
	struct {
		unsigned char	mByteCount;				/* : ׼дֽ,ôMAX_BYTE_IO,ôCH375_MAX_DATA_LEN */
		unsigned char	mByteBuffer[ MAX_BYTE_IO ];	/* : ׼дݿ */
	} WriteUsbData;								/* CMD_WriteUsbData, USB豸ģʽ: ģϴ˵дݿ */
} CMD_PARAM;

/* ********************************************************************************************************************* */
/* CH421AоƬĿռ䶨 */
#define	PARA_COMMAND_ADDR		0x40	/* ĵԪַ,õԪΪ,õԪɵƬڲǰ,ģڲɺ,ѯõԪɴѯINT# */
#define	PARA_STATUS_ADDR		0x41	/* ״̬ĵԪַ,õԪΪ״̬ */
#define	PARA_CMD_LEN_ADDR		0x42	/* ȵĵԪַ,õԪ7λΪĳ,λ֪ͨģ,Ϊ1򼤻/,Ϊ0/Ӧ */
#define	PARA_STS_LEN_ADDR		0x43	/* ״̬ȵĵԪַ,õԪ7λΪĳ */
#define	PARA_CMD_BIT_ACT		0x80	/* ȵλ,֪ͨģ,/ */
#define	PARA_CMD_BIT_INACT		0x00	/* ȵλ,֪ͨģ,/Ӧ */
#define	PARA_BUFFER_ADDR		0x00	/* ʼԪַ,ӸõԪʼ64ֽΪݻ */

/* ********************************************************************************************************************* */
/* ߴڵͬ,ͬSTA#ŵ½ؽͬ */
#define	SER_SYNC_CODE1			0x57	/* ĵ1ͬ */
#define	SER_SYNC_CODE2			0xAB	/* ĵ2ͬ */

/* ********************************************************************************************************************* */
/* ģʽдļ,ִֻ֧,ֻ֧ı,Ĭļ"/ģ.TXT" */
#define	SER_STREAM_END			0x1A	/* ģʽļд: */
#define	SER_STREAM_ERROR		0x15	/* ģʽļд: */
#define	SER_STREAM_ACK			0x06	/* ģʽļд:Ӧ */
#define	SER_STREAM_FLUSH		0x00	/* ģʽļд:ˢ */

/* ********************************************************************************************************************* */
/* ģԤ˵,ڹ */
/* ռ3F00Hʼ4ֽڱ"$HMS",˵ԤЧ */
/* ռ3F08Hֽǹģʽ: */
/*                              λ7: ֽ˳: 0-СLITTLE_ENDIAN,1-BIG_ENDIAN */
/*                              λ6: ,Ϊ0 */
/*                              λ5: ʱѯU״̬Զж֪ͨ:0ֹ,1 */
/*                              λ4: ļдݺԶļ:0ֹ,1 */
/*                              λ3: ,Ϊ0 */
/*                              λ2: Źʹ/ڳʱʹ: 0-ֹʱ, 1-ʱ */
/*                              λ1λ0: ӿڷʽ: 00-8λ, 01-רýӿ/I2CSPI,10-4+1ƴ,11-3ƴ */
/* ռ3F09HֽǴͨѶʳ */
/* ռ3F10Hʼ16ֽǲƷкַ */

/* ********************************************************************************************************************* */

#endif
