#include "stdafx.h"

char szWinName[] = "Glide Screen";
HWND masterhWnd;
HWND glhWnd;
HDC glhdc;
HGLRC	hglrc;
extern HINSTANCE hinstDLL;

int resWidth, resHeight;

BOOL ChangeResolution(unsigned int width, unsigned int height)
{ 
   DEVMODE devMode; 
   devMode.dmSize = sizeof(DEVMODE);
   devMode.dmBitsPerPel = 32;//3dfx only supports 16bit
   devMode.dmPelsWidth = width;
   devMode.dmPelsHeight = height;
   devMode.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;

   int modeSwitch = ChangeDisplaySettings(&devMode, 0); 
   if(modeSwitch != DISP_CHANGE_SUCCESSFUL)
   {
      switch(modeSwitch)
      {
      case DISP_CHANGE_RESTART:
         MessageBox(GetFocus(), "You must change your desktop to 16bit color (Hicolor) and then restart", "Win95/non-16bit color Init Error", MB_ICONERROR); 
         return FALSE;
         break;
      case DISP_CHANGE_BADMODE:
         MessageBox(GetFocus(), "The video mode is not supported", "Initialization Error", MB_ICONERROR); 
         return FALSE;
         break;
      case DISP_CHANGE_FAILED:
         MessageBox(GetFocus(), "Hardware failed to change resolution", "Initialization Error", MB_ICONERROR);
         return FALSE;
         break;
      }
   }

   return TRUE; 
}

BOOL setupPixelFormat(HDC hdc)
{
	PIXELFORMATDESCRIPTOR pfd = {  
		sizeof(PIXELFORMATDESCRIPTOR),  // size of this pfd  
		1,								// version number 
		PFD_SUPPORT_OPENGL |		// support OpenGL 
      PFD_DRAW_TO_WINDOW |
		PFD_DOUBLEBUFFER,			// double buffered 
		PFD_TYPE_RGBA,				// RGBA type 
		16,							// 16-bit color depth
		0, 0, 0, 0, 0, 0,			// color bits ignored
		0,								// no alpha buffer
		0,								// shift bit ignored
		0,								// no accumulation buffer
		0, 0, 0, 0,					// accum bits ignored
		24,							// 16-bit z-buffer
		0,								// no stencil buffer 
		0,                      // no auxiliary buffer 
		PFD_MAIN_PLANE,			// main layer 
		0,								// reserved 
		0, 0, 0						// layer masks ignored 
		}; 

	int pixelformat = ChoosePixelFormat(hdc, &pfd);

	if(pixelformat == 0)
	{
		LPVOID lpMsgBuf;
 
		FormatMessage(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
			NULL,
			GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL);

		// Display the string.
		MessageBox(NULL, (LPTSTR) lpMsgBuf, "ChoosePixelFormat failed GetLastError", MB_OK|MB_ICONINFORMATION);

		// Free the buffer.
		LocalFree(lpMsgBuf);

		return FALSE;
	}

	if(pfd.dwFlags & PFD_NEED_PALETTE)
	{
		MessageBox(NULL, "Needs palette", "Error", MB_OK);
		return FALSE;
	}

	if(SetPixelFormat(hdc, pixelformat, &pfd) == FALSE)
	{
		LPVOID lpMsgBuf;
 
		FormatMessage( 
		    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
			NULL,
			GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL);

		// Display the string.
		MessageBox(NULL, (char*)lpMsgBuf, "SetPixelFormat failed GetLastError", MB_OK|MB_ICONINFORMATION);

		// Free the buffer.
		LocalFree(lpMsgBuf);

		//MessageBox(NULL, "SetPixelFormat failed", "Error", MB_OK);
		return FALSE;
	}

	return TRUE;
}

LRESULT CALLBACK WindowFunc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
   switch(msg)
   {
   case WM_CREATE:
	   return 0;
      break;	
   case WM_DESTROY:
   case WM_CLOSE:
   case WM_QUIT:
      ChangeDisplaySettings(NULL, NULL);
		if(hglrc) wglDeleteContext(hglrc);
		if(glhdc) ReleaseDC(glhWnd, glhdc);
		hglrc = 0;
		glhdc = 0;
		DestroyWindow(glhWnd);
      PostQuitMessage(0);
      return 0;
      break;
   default:
      PostMessage(masterhWnd, msg, wParam, lParam);
      break;
   }
   return DefWindowProc(hWnd, msg, wParam, lParam);
}

HWND openWindow(void)
{
   HWND hWnd;
	WNDCLASSEX wcl;

	wcl.cbSize = sizeof(WNDCLASSEX); 

	wcl.hInstance = hinstDLL;						// handle to this instance
	wcl.lpszClassName = szWinName;					// window class name
	wcl.lpfnWndProc = WindowFunc;					// window function
	wcl.style = CS_OWNDC;									// default style

	wcl.hIcon = LoadIcon(NULL, IDI_APPLICATION);	// large icon
	wcl.hIconSm = LoadIcon(NULL, IDI_WINLOGO);		// small icon
	wcl.hCursor = LoadCursor(NULL, IDC_ARROW);		// cursor style

	wcl.lpszMenuName = NULL;						// no menu
	wcl.cbClsExtra = 0;								// no extra
	wcl.cbWndExtra = 0;								// information needed

	wcl.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH); 

	if(!RegisterClassEx(&wcl)) return 0;

	hWnd = CreateWindow(
		szWinName,					// name of window class
		"GlideGL64",				// title
		WS_POPUP,               // window style
		0,						   	// X coordinate - let Windows decide
		0,						   	// Y coordinate - let Windows decide
		resWidth,				   // width
		resHeight,   				// height
		NULL,     			      // no parent window
		NULL, 
		hinstDLL,					// handle of this instance of the program
		NULL					   	// no additional arguments
	);

	ShowCursor(FALSE);
   ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);

	return hWnd;
}

extern "C" __declspec(dllexport)
FxBool grSstWinOpen(FxU32 hwnd,
                    GrScreenResolution_t screen_resolution,
                    GrScreenRefresh_t    refresh_rate,
                    GrColorFormat_t      color_format,
                    GrOriginLocation_t   origin_location,
                    int                  nColBuffers,
                    int                  nAuxBuffers)
{
   if(//screen_resolution != GR_RESOLUTION_640x480 ||
      refresh_rate != GR_REFRESH_60Hz ||
      color_format != GR_COLORFORMAT_ABGR ||
      origin_location != GR_ORIGIN_LOWER_LEFT ||
	   nColBuffers != 2 ||
	   nAuxBuffers != 1)
   {
      MessageBox(NULL, "grSstWinOpen different", "Notice", MB_APPLMODAL);
      return FXFALSE;
   }

   switch(screen_resolution)
   {
   case GR_RESOLUTION_512x384:
      resWidth = 512;
      resHeight = 384;
      break;
   case GR_RESOLUTION_640x480:
      resWidth = 640;
      resHeight = 480;
      break;
   case GR_RESOLUTION_800x600:
      resWidth = 800;
      resHeight = 600;
      break;
   case GR_RESOLUTION_1024x768:
      resWidth = 1024;
      resHeight = 768;
      break;
   }

   if(!hwnd) masterhWnd = GetActiveWindow();
	else masterhWnd = (HWND)hwnd;

	if(!masterhWnd)
   {
      MessageBox(NULL, "grSstWinOpen Error", "Notice", MB_APPLMODAL);
      return FXFALSE;
   }
	
	//if(!ChangeResolution(resWidth, resHeight)) return FXFALSE;
   glhWnd = openWindow();
   glhdc = GetDC(glhWnd);
   if(!setupPixelFormat(glhdc))
   {
      MessageBox(NULL, "fail", "Notice", MB_APPLMODAL);
      return FXFALSE;
   }
   ReleaseDC(glhWnd, glhdc);
   glhdc = GetDC(glhWnd);
	hglrc = wglCreateContext(glhdc);
	wglMakeCurrent(glhdc, hglrc);
	BringWindowToTop(glhWnd);

   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glTranslatef(resWidth/-2.0f, resHeight/-2.0f, 0);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glScalef(2.0f/resWidth, 2.0f/resHeight, 1.0f);

   return FXTRUE;
}
