////////////////////////////////////////////////////////////////////////////////
// This in Not GlideSDK header file. Only for GL2Ideal.

#ifndef GLIDE_H_
#define GLIDE_H_


////////////////////////////////////////////////////////////////////////////////

#define FXTRUE			1
#define FXFALSE			0
#define FX_ENTRY		extern
#define FX_CALL			__stdcall
#define GLIDE_NUM_TMU	2
#define GR_FOG_TABLE_SIZE		64

#define GR_MIPMAPLEVELMASK_EVEN	(1<<0)
#define GR_MIPMAPLEVELMASK_ODD	(1<<1)
#define GR_MIPMAPLEVELMASK_BOTH	(GR_MIPMAPLEVELMASK_EVEN | GR_MIPMAPLEVELMASK_ODD)
#define GR_CONTROL_ACTIVATE		1
#define GR_SSTTYPE_VOODOO		0


////////////////////////////////////////////////////////////////////////////////
// basic types

typedef unsigned char	FxU8;
typedef unsigned short	FxU16;
typedef unsigned long	FxU32;
typedef signed char		FxI8;
typedef signed short	FxI16;
typedef signed long		FxI32;
typedef int				FxBool;
typedef float			FxFloat;
typedef double			FxDouble;

////////////////////////////////////////////////////////////////////////////////
// types and defines

typedef void GrSstPerfStats_t;
typedef FxI32 GrChromakeyMode_t;
typedef FxI32 GrChipID_t;
typedef FxU32 GrLock_t;
typedef FxI32 GrLfbWriteMode_t;
typedef FxU32 GrLfbSrcFmt_t;
typedef FxI32 GrPassthruMode_t;
typedef FxU32 GrHint_t;
typedef FxU32 GrSTWHint_t;
typedef FxU32 GrControl_t;

typedef FxU8 GrFog_t;
typedef FxU8 GrAlpha_t;
typedef FxU32 GrColor_t;
typedef FxU32 GrMipMapId_t;
typedef FxU32 GrTexTable_t;
typedef FxU32 GrNCCTable_t;
typedef FxU32 GrTexBaseRange_t;


typedef FxI32 GrCombineFunction_t;
#define GR_COMBINE_FUNCTION_ZERO		0x0
#define GR_COMBINE_FUNCTION_NONE		GR_COMBINE_FUNCTION_ZERO
#define GR_COMBINE_FUNCTION_LOCAL		0x1
#define GR_COMBINE_FUNCTION_LOCAL_ALPHA 0x2
#define GR_COMBINE_FUNCTION_SCALE_OTHER 0x3
#define GR_COMBINE_FUNCTION_BLEND_OTHER GR_COMBINE_FUNCTION_SCALE_OTHER
#define GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL		0x4
#define GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL_ALPHA	0x5 
#define GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL		0x6
#define GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL	0x7
#define GR_COMBINE_FUNCTION_BLEND				GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL
#define GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL_ALPHA		0x8
#define GR_COMBINE_FUNCTION_SCALE_MINUS_LOCAL_ADD_LOCAL			0x9
#define GR_COMBINE_FUNCTION_BLEND_LOCAL			GR_COMBINE_FUNCTION_SCALE_MINUS_LOCAL_ADD_LOCAL
#define GR_COMBINE_FUNCTION_SCALE_MINUS_LOCAL_ADD_LOCAL_ALPHA	0x10

typedef FxI32 GrCombineFactor_t;
#define GR_COMBINE_FACTOR_ZERO			0x0
#define GR_COMBINE_FACTOR_NONE			GR_COMBINE_FACTOR_ZERO
#define GR_COMBINE_FACTOR_LOCAL			0x1
#define GR_COMBINE_FACTOR_OTHER_ALPHA	0x2
#define GR_COMBINE_FACTOR_LOCAL_ALPHA	0x3
#define GR_COMBINE_FACTOR_TEXTURE_ALPHA 0x4
#define GR_COMBINE_FACTOR_TEXTURE_RGB	0x5
#define GR_COMBINE_FACTOR_DETAIL_FACTOR GR_COMBINE_FACTOR_TEXTURE_ALPHA
#define GR_COMBINE_FACTOR_LOD_FRACTION	0x5
#define GR_COMBINE_FACTOR_ONE			0x8
#define GR_COMBINE_FACTOR_ONE_MINUS_LOCAL				0x9
#define GR_COMBINE_FACTOR_ONE_MINUS_OTHER_ALPHA			0xa
#define GR_COMBINE_FACTOR_ONE_MINUS_LOCAL_ALPHA			0xb
#define GR_COMBINE_FACTOR_ONE_MINUS_TEXTURE_ALPHA		0xc
#define GR_COMBINE_FACTOR_ONE_MINUS_DETAIL_FACTOR		GR_COMBINE_FACTOR_ONE_MINUS_TEXTURE_ALPHA
#define GR_COMBINE_FACTOR_ONE_MINUS_LOD_FRACTION		0xd

typedef FxI32 GrCombineLocal_t;
#define GR_COMBINE_LOCAL_ITERATED	0x0
#define GR_COMBINE_LOCAL_CONSTANT	0x1
#define GR_COMBINE_LOCAL_NONE		GR_COMBINE_LOCAL_CONSTANT
#define GR_COMBINE_LOCAL_DEPTH		0x2

typedef FxI32 GrCombineOther_t;
#define GR_COMBINE_OTHER_ITERATED	0x0
#define GR_COMBINE_OTHER_TEXTURE	0x1
#define GR_COMBINE_OTHER_CONSTANT	0x2
#define GR_COMBINE_OTHER_NONE		GR_COMBINE_OTHER_CONSTANT


typedef FxI32 GrAlphaSource_t;
#define GR_ALPHASOURCE_CC_ALPHA			0x0
#define GR_ALPHASOURCE_ITERATED_ALPHA	0x1
#define GR_ALPHASOURCE_TEXTURE_ALPHA	0x2
#define GR_ALPHASOURCE_TEXTURE_ALPHA_TIMES_ITERATED_ALPHA	0x3


typedef FxI32 GrColorCombineFnc_t;
#define GR_COLORCOMBINE_ZERO	0x0
#define GR_COLORCOMBINE_CCRGB	0x1
#define GR_COLORCOMBINE_ITRGB	0x2
#define GR_COLORCOMBINE_ITRGB_DELTA0	0x3
#define GR_COLORCOMBINE_DECAL_TEXTURE	0x4
#define GR_COLORCOMBINE_TEXTURE_TIMES_CCRGB				0x5
#define GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB				0x6
#define GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB_DELTA0		0x7
#define GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB_ADD_ALPHA	0x8
#define GR_COLORCOMBINE_TEXTURE_TIMES_ALPHA				0x9
#define GR_COLORCOMBINE_TEXTURE_TIMES_ALPHA_ADD_ITRGB	0xa
#define GR_COLORCOMBINE_TEXTURE_ADD_ITRGB		0xb
#define GR_COLORCOMBINE_TEXTURE_SUB_ITRGB		0xc
#define GR_COLORCOMBINE_CCRGB_BLEND_ITRGB_ON_TEXALPHA	0xd
#define GR_COLORCOMBINE_DIFF_SPEC_A				0xe
#define GR_COLORCOMBINE_DIFF_SPEC_B				0xf
#define GR_COLORCOMBINE_ONE						0x10

typedef FxI32 GrAlphaBlendFnc_t;
#define GR_BLEND_ZERO			0x0
#define GR_BLEND_SRC_ALPHA		0x1
#define GR_BLEND_SRC_COLOR		0x2
#define GR_BLEND_DST_COLOR		GR_BLEND_SRC_COLOR
#define GR_BLEND_DST_ALPHA		0x3 
#define GR_BLEND_ONE			0x4
#define GR_BLEND_ONE_MINUS_SRC_ALPHA	0x5
#define GR_BLEND_ONE_MINUS_SRC_COLOR	0x6
#define GR_BLEND_ONE_MINUS_DST_COLOR	GR_BLEND_ONE_MINUS_SRC_COLOR 
#define GR_BLEND_ONE_MINUS_DST_ALPHA	0x7
#define GR_BLEND_RESERVED_8		0x8
#define GR_BLEND_RESERVED_9		0x9
#define GR_BLEND_RESERVED_A		0xa
#define GR_BLEND_RESERVED_B		0xb
#define GR_BLEND_RESERVED_C		0xc
#define GR_BLEND_RESERVED_D		0xd
#define GR_BLEND_RESERVED_E		0xe
#define GR_BLEND_ALPHA_SATURATE	0xf
#define GR_BLEND_PREFOG_COLOR GR_BLEND_ALPHA_SATURATE

typedef FxI32 GrAspectRatio_t;
#define GR_ASPECT_8x1	0x0
#define GR_ASPECT_4x1	0x1
#define GR_ASPECT_2x1	0x2
#define GR_ASPECT_1x1	0x3
#define GR_ASPECT_1x2	0x4
#define GR_ASPECT_1x4	0x5
#define GR_ASPECT_1x8	0x6

typedef FxI32 GrBuffer_t;
#define GR_BUFFER_FRONTBUFFER	0x0
#define GR_BUFFER_BACKBUFFER	0x1
#define GR_BUFFER_AUXBUFFER		0x2
#define GR_BUFFER_DEPTHBUFFER	0x3
#define GR_BUFFER_ALPHABUFFER	0x4
#define GR_BUFFER_TRIPLEBUFFER	0x5

typedef FxI32 GrCmpFnc_t;
#define GR_CMP_NEVER	0x0
#define GR_CMP_LESS		0x1
#define GR_CMP_EQUAL	0x2
#define GR_CMP_LEQUAL	0x3
#define GR_CMP_GREATER	0x4
#define GR_CMP_NOTEQUAL	0x5
#define GR_CMP_GEQUAL	0x6
#define GR_CMP_ALWAYS	0x7

typedef FxI32 GrColorFormat_t;
#define GR_COLORFORMAT_ARGB	0x0
#define GR_COLORFORMAT_ABGR	0x1
#define GR_COLORFORMAT_RGBA	0x2
#define GR_COLORFORMAT_BGRA	0x3

typedef FxI32 GrCullMode_t;
#define GR_CULL_DISABLE			0x0
#define GR_CULL_NEGATIVE		0x1
#define GR_CULL_POSITIVE		0x2

typedef FxI32 GrDepthBufferMode_t;
#define GR_DEPTHBUFFER_DISABLE					0x0
#define GR_DEPTHBUFFER_ZBUFFER					0x1
#define GR_DEPTHBUFFER_WBUFFER					0x2
#define GR_DEPTHBUFFER_ZBUFFER_COMPARE_TO_BIAS	0x3
#define GR_DEPTHBUFFER_WBUFFER_COMPARE_TO_BIAS	0x4

typedef FxI32 GrDitherMode_t;
#define GR_DITHER_DISABLE		0x0
#define GR_DITHER_2x2			0x1
#define GR_DITHER_4x4			0x2

typedef FxI32 GrFogMode_t;
#define GR_FOG_DISABLE					0x0
#define GR_FOG_WITH_ITERATED_ALPHA		0x1
#define GR_FOG_WITH_TABLE				0x2
#define GR_FOG_WITH_ITERATED_Z			0x3
#define GR_FOG_MULT2					0x100
#define GR_FOG_ADD2						0x200

typedef FxI32 GrOriginLocation_t;
#define GR_ORIGIN_UPPER_LEFT	0x0
#define GR_ORIGIN_LOWER_LEFT	0x1
#define GR_ORIGIN_ANY			0xff


typedef FxI32 GrScreenRefresh_t;
typedef FxI32 GrScreenResolution_t;
#define GR_RESOLUTION_320x200	0x0
#define GR_RESOLUTION_320x240	0x1
#define GR_RESOLUTION_400x256	0x2
#define GR_RESOLUTION_512x384	0x3
#define GR_RESOLUTION_640x200	0x4
#define GR_RESOLUTION_640x350	0x5
#define GR_RESOLUTION_640x400	0x6
#define GR_RESOLUTION_640x480	0x7
#define GR_RESOLUTION_800x600	0x8
#define GR_RESOLUTION_960x720	0x9
#define GR_RESOLUTION_856x480	0xa
#define GR_RESOLUTION_512x256	0xb
#define GR_RESOLUTION_1024x768	0xc
#define GR_RESOLUTION_1280x1024	0xd
#define GR_RESOLUTION_1600x1200	0xe
#define GR_RESOLUTION_400x300	0xf
#define GR_RESOLUTION_NONE		0xff


typedef FxI32 GrMipMapMode_t;
#define GR_MIPMAP_DISABLE				0x0
#define GR_MIPMAP_NEAREST				0x1
#define GR_MIPMAP_NEAREST_DITHER		0x2

typedef FxI32 GrSmoothingMode_t;
#define GR_SMOOTHING_DISABLE			0x0
#define GR_SMOOTHING_ENABLE				0x1

typedef FxI32 GrTextureClampMode_t;
#define GR_TEXTURECLAMP_WRAP			0x0
#define GR_TEXTURECLAMP_CLAMP			0x1

typedef FxI32 GrTextureCombineFnc_t;
#define GR_TEXTURECOMBINE_ZERO			0x0
#define GR_TEXTURECOMBINE_DECAL			0x1
#define GR_TEXTURECOMBINE_OTHER			0x2
#define GR_TEXTURECOMBINE_ADD			0x3
#define GR_TEXTURECOMBINE_MULTIPLY		0x4
#define GR_TEXTURECOMBINE_SUBTRACT		0x5
#define GR_TEXTURECOMBINE_DETAIL		0x6
#define GR_TEXTURECOMBINE_DETAIL_OTHER	0x7
#define GR_TEXTURECOMBINE_TRILINEAR_ODD	0x8
#define GR_TEXTURECOMBINE_TRILINEAR_EVEN		0x9
#define GR_TEXTURECOMBINE_ONE			0xa

typedef FxI32 GrTextureFilterMode_t;
#define GR_TEXTUREFILTER_POINT_SAMPLED	0x0
#define GR_TEXTUREFILTER_BILINEAR		0x1

typedef FxI32 GrTextureFormat_t;
#define GR_TEXFMT_8BIT					0x0
#define GR_TEXFMT_RGB_332				GR_TEXFMT_8BIT
#define GR_TEXFMT_YIQ_422				0x1
#define GR_TEXFMT_ALPHA_8				0x2
#define GR_TEXFMT_INTENSITY_8			0x3
#define GR_TEXFMT_ALPHA_INTENSITY_44	0x4
#define GR_TEXFMT_P_8					0x5
#define GR_TEXFMT_RSVD0					0x6
#define GR_TEXFMT_RSVD1					0x7
#define GR_TEXFMT_16BIT					0x8
#define GR_TEXFMT_ARGB_8332				GR_TEXFMT_16BIT
#define GR_TEXFMT_AYIQ_8422				0x9
#define GR_TEXFMT_RGB_565				0xa
#define GR_TEXFMT_ARGB_1555				0xb
#define GR_TEXFMT_ARGB_4444				0xc
#define GR_TEXFMT_ALPHA_INTENSITY_88	0xd
#define GR_TEXFMT_AP_88					0xe
#define GR_TEXFMT_RSVD2					0xf

typedef FxI32 GrLOD_t;
#define GR_LOD_256		0x0
#define GR_LOD_128		0x1
#define GR_LOD_64		0x2
#define GR_LOD_32		0x3
#define GR_LOD_16		0x4
#define GR_LOD_8		0x5
#define GR_LOD_4		0x6
#define GR_LOD_2		0x7
#define GR_LOD_1		0x8

////////////////////////////////////////////////////////////////////////////////
// vertex structs

typedef struct {
	float			sow;
	float			tow;
	float			oow;
} GrTmuVertex;

typedef struct {
	float			x, y, z;
	float			r, g, b;
	float			ooz;
	float			a;
	float			oow;
	GrTmuVertex	tmuvtx[GLIDE_NUM_TMU];
} GrVertex;

////////////////////////////////////////////////////////////////////////////////
// config structs

typedef struct GrTMUConfig_St {
	int			tmuRev;
	int			tmuRam;
} GrTMUConfig_t;

typedef struct GrVoodooConfig_St {
	int			fbRam;
	int			fbiRev;
	int			nTexelfx;
	FxBool		sliDetect;
	GrTMUConfig_t		tmuConfig[GLIDE_NUM_TMU];
} GrVoodooConfig_t;
typedef GrVoodooConfig_t	GrVoodoo2Config_t;

typedef struct GrSst96Config_St {
	int			fbRam;
	int			nTexelfx;
	GrTMUConfig_t		tmuConfig;
} GrSst96Config_t;

typedef struct GrAT3DConfig_St {
	int			rev;
} GrAT3DConfig_t;

typedef struct {
	int num_sst;
	struct {
		int		type;
		union SstBoard_u {
			GrVoodooConfig_t	VoodooConfig;
			GrSst96Config_t		SST96Config;
			GrAT3DConfig_t		AT3DConfig;
			GrVoodoo2Config_t	Voodoo2Config;
		} sstBoard;
	} SSTs[4];
} GrHwConfiguration;

////////////////////////////////////////////////////////////////////////////////
// misc structs

typedef struct { int _none; } NONE_t;
typedef NONE_t	GrMipMapInfo;
typedef NONE_t	GrLfbInfo_t;
typedef NONE_t	GrState;

typedef struct {
	GrLOD_t				smallLod;
	GrLOD_t				largeLod;
	GrAspectRatio_t		aspectRatio;
	GrTextureFormat_t	format;
	void				*data;
} GrTexInfo;


////////////////////////////////////////////////////////////////////////////////
// 3DF texture file structs
typedef struct
{
	FxU32				width, height;
	int					small_lod, large_lod;
	GrAspectRatio_t		aspect_ratio;
	GrTextureFormat_t	format;
} Gu3dfHeader;

typedef struct
{
	FxU8		yRGB[16];
	FxI16		iRGB[4][3];
	FxI16		qRGB[4][3];
	FxU32		packed_data[12];
} GuNccTable;

typedef struct {
	FxU32		data[256];
} GuTexPalette;

typedef union {
	GuNccTable			nccTable;
	GuTexPalette		palette;
} GuTexTable;

typedef struct
{
	Gu3dfHeader	header;
	GuTexTable	table;
	void		*data;
	FxU32		mem_required;
} Gu3dfInfo;

////////////////////////////////////////////////////////////////////////////////

#endif /* GLIDE_H_ */
