#include <windows.h>
#include <stdlib.h>		// for _itoa()
#include "resource.h"

#include "../glid3d.h"
#define pszSection		"Misc"
static char		pszProfileName[260];
static char		prof_buf[32];
#define SetPrivateProfileInt(s,e,i,p) WritePrivateProfileString(s, e, _itoa(i, prof_buf, 10), p)

BOOL g_gr_bUseTexEnvAdd;
BOOL g_gr_bUseTexEnvCombine;
BOOL g_gr_bUseTexEnvCombine4;
BOOL g_gr_bFullScreen;
INT g_gr_glHint;
BOOL g_gr_nWinCustom;
INT g_gr_nWinWidth;
INT g_gr_nWinHeight;
INT g_gr_fogMode;
INT g_gr_fogFactor;
INT g_gr_fix1;

////////////////////////////////////////////////////////////////////////////////
void ReadCfg()
{
	g_gr_bFullScreen = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FULLSCREEN, TRUE, pszProfileName);
	g_gr_fogMode = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FOG_MODE, 1, pszProfileName);
	g_gr_nWinCustom = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_WIN_CUSTOM, 0, pszProfileName);
	g_gr_nWinWidth = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_WIN_WIDTH, 640, pszProfileName);
	g_gr_nWinHeight = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_WIN_HEIGHT, 480, pszProfileName);
	g_gr_glHint = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_GL_HINT, 0, pszProfileName);
	g_gr_fix1 = GetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FIX1, 0, pszProfileName);
}
void WriteCfg()
{
	SetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FULLSCREEN,g_gr_bFullScreen, pszProfileName);
	SetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FOG_MODE, g_gr_fogMode, pszProfileName);
	SetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_WIN_CUSTOM, g_gr_nWinCustom, pszProfileName);
	SetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_WIN_WIDTH, g_gr_nWinWidth, pszProfileName);
	SetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_WIN_HEIGHT, g_gr_nWinHeight, pszProfileName);
	SetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_GL_HINT, g_gr_glHint, pszProfileName);
	SetPrivateProfileInt(pszSection, GLID3DPROF_VIDEO_FIX1, g_gr_fix1, pszProfileName);
}

////////////////////////////////////////////////////////////////////////////////
void InitDlg(HWND hWnd)
{
	SendMessage(GetDlgItem(hWnd, IDC_HINTS), CB_ADDSTRING, 0, (long)"Fastest");
	SendMessage(GetDlgItem(hWnd, IDC_HINTS), CB_ADDSTRING, 0, (long)"Don't care");
	SendMessage(GetDlgItem(hWnd, IDC_HINTS), CB_ADDSTRING, 0, (long)"Nicest");
}
void SetModify(HWND hWnd, bool flg = true)
{
	static bool modify;

	modify = flg;
	EnableWindow(GetDlgItem(hWnd, ID_APPLY), modify);
}
void EnableItem(HWND hWnd)
{
	EnableWindow(GetDlgItem(hWnd, IDC_RES_X), g_gr_nWinCustom);
	EnableWindow(GetDlgItem(hWnd, IDC_RES_Y), g_gr_nWinCustom);
}
void SetParams(HWND hWnd)
{
	SetDlgItemInt(hWnd, IDC_RES_X, g_gr_nWinWidth, 0);
	SetDlgItemInt(hWnd, IDC_RES_Y, g_gr_nWinHeight, 0);
	SendMessage(GetDlgItem(hWnd, IDC_FULLSCREEN), BM_SETCHECK, g_gr_bFullScreen, 0);
	SendMessage(GetDlgItem(hWnd, IDC_FOG), BM_SETCHECK, g_gr_fogMode, 0);
	SendMessage(GetDlgItem(hWnd, IDC_RESOLUTION), BM_SETCHECK, g_gr_nWinCustom, 0);
	SendMessage(GetDlgItem(hWnd, IDC_HINTS), CB_SETCURSEL, g_gr_glHint, 0);
	SendMessage(GetDlgItem(hWnd, IDC_FIX1), BM_SETCHECK, g_gr_fix1, 0);

	EnableItem(hWnd);
}
void GetParams(HWND hWnd)
{
	BOOL	in;
	g_gr_bFullScreen = SendMessage(GetDlgItem(hWnd, IDC_FULLSCREEN), BM_GETCHECK, 0, 0);
	g_gr_fogMode = SendMessage(GetDlgItem(hWnd, IDC_FOG), BM_GETCHECK, 0, 0);
	g_gr_nWinCustom = SendMessage(GetDlgItem(hWnd, IDC_RESOLUTION), BM_GETCHECK, 0, 0);
	g_gr_nWinWidth = GetDlgItemInt(hWnd, IDC_RES_X, &in, 0);
	g_gr_nWinHeight = GetDlgItemInt(hWnd, IDC_RES_Y, &in, 0);
	g_gr_glHint = SendMessage(GetDlgItem(hWnd, IDC_HINTS), CB_GETCURSEL, 0, 0);
	g_gr_fix1 = SendMessage(GetDlgItem(hWnd, IDC_FIX1), BM_GETCHECK, 0, 0);
	if(g_gr_nWinWidth <= 0)
		g_gr_nWinWidth = 640;
	if(g_gr_nWinHeight <= 0)
		g_gr_nWinHeight = 480;
}

////////////////////////////////////////////////////////////////////////////////
#include <GL/gl.h>
static void SetInfoStr(HWND hWnd)
{
	HWND	hWndGL = CreateWindowEx (WS_EX_TOPMOST, "STATIC", "", WS_CHILD | WS_VISIBLE,
									 0, 0, 1, 1, hWnd, 0, 0, 0);
	HDC		hDC = GetDC(hWndGL);
	
	PIXELFORMATDESCRIPTOR pfd;
	memset (&pfd, 0, sizeof (pfd));
	pfd.nSize = sizeof (pfd);
	pfd.nVersion = 1;
	pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL;
	pfd.iPixelType = PFD_TYPE_RGBA;
	pfd.cColorBits = 16;
	pfd.cDepthBits = 16;
	int	pf = ChoosePixelFormat(hDC, &pfd);
	SetPixelFormat(hDC, pf, &pfd);
	
	HGLRC	glRC = wglCreateContext(hDC);
	wglMakeCurrent(hDC, glRC);


	char	str[65536] = "", *p;
	if((p = (char*)glGetString(GL_VENDOR))){
		strcat(str,     "[Vendor]     ");
		strcat(str, p);
	}
	if((p = (char*)glGetString(GL_RENDERER))){
		strcat(str, "\r\n[Renderer]   ");
		strcat(str, p);
	}
	if((p = (char*)glGetString(GL_VERSION))){
		strcat(str, "\r\n[Version]    ");
		strcat(str, p);
	}
	if((p = (char*)glGetString(GL_EXTENSIONS))){
		strcat(str, "\r\n[Extensions]\r\n");
		char	*ext = str + strlen(str);
		*ext++ = ' ';
		for( ; *p ; ++p){
			if(*p == ' '){
				*ext++ = '\r';
				*ext++ = '\n';
				*ext++ = ' ';
			}else
				*ext++ = *p;
		}
		*p = 0;
	}

	wglMakeCurrent(NULL, NULL);
	wglDeleteContext(glRC);
	ReleaseDC(hWndGL, hDC);
	DestroyWindow(hWndGL);

	SetDlgItemText(hWnd, IDC_EDIT, str);
}
static BOOL CALLBACK InfoDlgProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)
{
	switch(wMsg) {
	case WM_INITDIALOG:
		SetInfoStr(hWnd);
		return TRUE;
	case WM_COMMAND:
		if(wParam == IDOK || wParam == IDCANCEL)
			EndDialog(hWnd, TRUE);
		break;
	}
	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
static BOOL CALLBACK DlgProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)
{
	switch(wMsg) {
	case WM_INITDIALOG:
		InitDlg(hWnd);
		ReadCfg();
		SetParams(hWnd);
		SetModify(hWnd, false);
		return TRUE;
	case WM_COMMAND:
		if(HIWORD(wParam) == BN_CLICKED){
			switch(LOWORD(wParam)){
			case ID_INFO:
				DialogBox(0, "info", hWnd, InfoDlgProc);
			case IDOK:
			case IDCANCEL:
			case ID_APPLY:
				break;
			case ID_RESET:
				g_gr_bFullScreen = TRUE;
				g_gr_fogMode = 1;
				g_gr_nWinCustom = 0;
				g_gr_nWinWidth = 640;
				g_gr_nWinHeight = 480;
				g_gr_glHint = 0;
				g_gr_fix1 = 0;
				SetParams(hWnd);
				//SetModify(hWnd); //this is done via EN_CHANGE
				break;
			case IDC_RESOLUTION:
				GetParams(hWnd);
				EnableItem(hWnd);
			default:			// fall through
				SetModify(hWnd);
				break;
			};
		}
		else if(HIWORD(wParam) == EN_CHANGE || HIWORD(wParam) == CBN_SELCHANGE){
			SetModify(hWnd);
		}

		if(wParam == IDOK || wParam == ID_APPLY){
			GetParams(hWnd);
			WriteCfg();
			SetModify(hWnd, false);
		}
		if(wParam == IDOK || wParam == IDCANCEL)
			EndDialog(hWnd, TRUE);
		break;
	}
	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpszCmdLine, int iCmdShow)
{
	GetSystemDirectory(pszProfileName, sizeof(pszProfileName));
	if(pszProfileName[lstrlen(pszProfileName) - 1] != '\\')
		lstrcat(pszProfileName, "\\");
	lstrcat(pszProfileName, GLID3D_PROFILENAME);

	DialogBox(hInst, "dlg", NULL, DlgProc);

	return TRUE;
}
