/////////////////////////////////////////////////////////////////////////////
// GliD3D_linearframebuffer.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "GliD3D.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY FxBool FX_CALL
  grLfbLock (GrLock_t type, GrBuffer_t buffer, GrLfbWriteMode_t writeMode,
	GrOriginLocation_t origin, FxBool pixelPipeline,
	GrLfbInfo_t * info)
{
	TRACEFUNCTION ("grLfbLock");

	return FXTRUE;
}

FX_ENTRY FxBool FX_CALL
  grLfbUnlock (GrLock_t type, GrBuffer_t buffer)
{
	TRACEFUNCTION ("grLfbUnlock");

	return FXTRUE;
}

FX_ENTRY void FX_CALL grLfbConstantAlpha (GrAlpha_t alpha)
{
	TRACEFUNCTION ("grLfbConstantAlpha");
}

FX_ENTRY void FX_CALL grLfbConstantDepth (FxU16 depth)
{
	TRACEFUNCTION ("grLfbConstantDepth");
}

FX_ENTRY void FX_CALL grLfbWriteColorSwizzle (FxBool swizzleBytes, FxBool swapWords)
{
	TRACEFUNCTION ("grLfbWriteColorSwizzle");
}

FX_ENTRY void FX_CALL grLfbWriteColorFormat (GrColorFormat_t colorFormat)
{
	TRACEFUNCTION ("grLfbWriteColorFormat");
}

FX_ENTRY FxBool FX_CALL grLfbWriteRegion (GrBuffer_t dst_buffer, FxU32
	dst_x, FxU32 dst_y, GrLfbSrcFmt_t src_format, FxU32 src_width, FxU32 src_height,
	FxI32 src_stride, void *src_data)

{
	TRACEFUNCTION ("grLfbWriteRegion");

	return FXFALSE;
}

FX_ENTRY FxBool FX_CALL
  grLfbReadRegion (GrBuffer_t src_buffer,
	FxU32 src_x, FxU32 src_y,
	FxU32 src_width, FxU32 src_height,
	FxU32 dst_stride, void *dst_data)
{
	TRACEFUNCTION ("grLfbReadRegion");

	HDC			hdcMem = CreateCompatibleDC(g_gr_hDC);
	HBITMAP		hBMP = CreateCompatibleBitmap(g_gr_hDC, src_width, src_height);
	HBITMAP		hOld = (HBITMAP)SelectObject(hdcMem, hBMP);

	static BITMAPINFO	bi;
	bi.bmiHeader.biSize = sizeof(bi.bmiHeader);
	bi.bmiHeader.biWidth = src_width;
	bi.bmiHeader.biHeight = src_height;
	bi.bmiHeader.biPlanes = 1;
	bi.bmiHeader.biBitCount = 16;
	bi.bmiHeader.biCompression = BI_BITFIELDS;
	bi.bmiColors[0].rgbBlue = 0x1f;
	bi.bmiColors[1].rgbGreen = 0x3f;
	bi.bmiColors[2].rgbRed = 0x1f;

	if((int)src_width == g_gr_nWinWidth && (int)src_height == g_gr_nWinHeight){
		BitBlt(hdcMem, 0, 0, src_width, src_height, g_gr_hDC, src_x, src_y, SRCCOPY);
	}else{
		SetStretchBltMode(hdcMem, HALFTONE); // This does not work in win95/98.
		SetBrushOrgEx(hdcMem, 0, 0, 0);
		StretchBlt(hdcMem, 0, 0, src_width, src_height, g_gr_hDC, src_x *src_width/g_gr_nWinWidth,
				   src_y *src_height/g_gr_nWinHeight, g_gr_nWinWidth, g_gr_nWinHeight, SRCCOPY);
	}
	SelectObject(hdcMem, hOld);
	for(unsigned long	y = 0; y < src_height; ++y){
		unsigned short	*dest = (unsigned short*)dst_data + dst_stride/sizeof(*dest)*(src_height-1 - y);
		GetDIBits(hdcMem, hBMP, y, 1, dest, &bi, DIB_RGB_COLORS);
	}
	DeleteObject(hBMP);
	DeleteObject(hdcMem);
	
	return FXTRUE;
}

/////////////////////////////////////////////////////////////////////////////
