#ifndef _SD_H_
#define _SD_H_

#include <stdbool.h>
#include <stdint.h>

#define SD_BLOCK_SIZE		512

union SdFlags {
	struct {
		uint8_t inited			: 1;
		uint8_t v2				: 1;
		uint8_t HC				: 1;
		uint8_t SD				: 1;
		uint8_t RO				: 1;
		uint8_t cmd23supported	: 1;
		uint8_t hasDiscard		: 1;
	};
	uint8_t value;
};

struct SD {		//should be zero inited
	uint32_t numSec;
	union SdFlags flags;
	uint8_t mid;
	uint16_t oid;
	uint32_t snum;
	
	uint32_t numSecLeft;		//for long operation

	bool fast;
};



bool sdCardInit(struct SD *sd);
uint32_t sdGetNumSecs(struct SD *sd);

bool sdPostSleepCidReread(struct SD *sd);

bool sdSecRead(struct SD *sd, uint32_t sec, uint8_t *dst);
bool sdSecWrite(struct SD *sd, uint32_t sec, const uint8_t *src);

bool sdReadStart(struct SD *sd, uint32_t sec, uint32_t numSec);	//if numSec is nonzero, card will be advised to expect that many blocks
bool sdReadNext(struct SD *sd, uint8_t *dst);
bool sdReadStop(struct SD *sd);

bool sdWriteStart(struct SD *sd, uint32_t sec, uint32_t numSec);	//if numSec is nonzero, card will be advised to expect that many blocks
bool sdWriteNext(struct SD *sd, const uint8_t *dst);
bool sdWriteStop(struct SD *sd);

void sdGetInfo(struct SD *sd, uint8_t *midP, uint16_t *oidP, uint32_t *snumP);
uint8_t sdGetFlags(struct SD *sd);

bool sdTrim(struct SD *sd, uint32_t firstBlock, uint32_t numBlocks);


#endif
