#include <stdbool.h>
#include "util.h"


static bool mSeIsLe = false;

static void writeLE(void* dst, uint32_t val, uint32_t bytes)
{
	uint8_t *dstP = (uint8_t*)dst;
	
	while(bytes--) {
		*dstP++ = val;
		val >>= 8;
	}
}

static uint32_t readLE(const void *pP, uint32_t bytes)
{
	const uint8_t *p = (const uint8_t*)pP;
	uint32_t i, v = 0;
	
	for (i = 0; i < bytes; i++)
		v = (v << 8) + p[bytes - i - 1];
	
	return v;
}

void writeLE32(uint32_t *dst, uint32_t val)
{
	writeLE(dst, val, sizeof(uint32_t));
}

void writeLE24(uint8_t *dst, uint32_t val)
{
	writeLE(dst, val, 3);
}

void writeLE16(uint16_t *dst, uint16_t val)
{
	writeLE(dst, val, sizeof(uint16_t));
}

uint32_t readLE32(const uint32_t *p)
{
	return readLE(p, sizeof(uint32_t));
}

uint32_t readLE24(const uint8_t *p)
{
	return readLE(p, 3);
}

uint16_t readLE16(const uint16_t *p)
{
	return readLE(p, sizeof(uint16_t));
}

static void writeBE(void* dst, uint32_t val, uint32_t bytes)
{
	uint8_t *dstP = (uint8_t*)dst;
	
	while(bytes) {
		bytes--;
		dstP[bytes] = val;
		val >>= 8;
	}
}

static uint32_t readBE(const void *pP, uint32_t bytes)
{
	const uint8_t *srcP = (uint8_t*)pP;
	uint32_t ret = 0;
	
	while(bytes--) {
		ret = (ret << 8) + *srcP++;
	}

	return ret;
}

void writeBE32(uint32_t *dst, uint32_t val)
{
	writeBE(dst, val, sizeof(uint32_t));
}

void writeBE24(uint8_t *dst, uint32_t val)
{
	writeBE(dst, val, 3);
}

void writeBE16(uint16_t *dst, uint16_t val)
{
	writeBE(dst, val, sizeof(uint16_t));
}

uint32_t readBE32(const uint32_t *p)
{
	return readBE(p, sizeof(uint32_t));
}

uint32_t readBE24(const uint8_t *p)
{
	return readBE(p, 3);
}

uint16_t readBE16(const uint16_t *p)
{
	return readBE(p, sizeof(uint16_t));
}

void seSetLittleEndian(bool little)		//else big
{
	mSeIsLe = little;
}

void writeSE32(uint32_t *dst, uint32_t val)
{
	return mSeIsLe ? writeLE32(dst, val) : writeBE32(dst, val);
}

void writeSE24(uint8_t *dst, uint32_t val)
{
	return mSeIsLe ? writeLE24(dst, val) : writeBE24(dst, val);
}

void writeSE16(uint16_t *dst, uint16_t val)
{
	return mSeIsLe ? writeLE16(dst, val) : writeBE16(dst, val);
}

uint32_t readSE32(const uint32_t *p)
{
	return mSeIsLe ? readLE32(p) : readBE32(p);
}

uint32_t readSE24(const uint8_t *p)
{
	return mSeIsLe ? readLE24(p) : readBE24(p);
}

uint16_t readSE16(const uint16_t *p)
{
	return mSeIsLe ? readLE16(p) : readBE16(p);
}
