#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <stdio.h>
#include "parsePrcPdb.h"
#include "util.h"



static void usage(const char* me)
{
	fprintf(stderr, "USAGE: %s file.prc\n", me);
	
	
	exit(-1);
}

static void exportRec(const struct PalmRec *rec)
{
	char name[32];
	FILE *f;
	
	sprintf(name, "rec_%06x_%02x.bin", rec->uniq, rec->attrs);
	f = fopen(name, "wb");
	if (!f) {
		
		fprintf(stderr, "cannot open '%s'\n", name);
		abort();
	}
	
	if (rec->buf.sz != fwrite(rec->buf.data, 1, rec->buf.sz, f)) {
		
		fprintf(stderr, "cannot write '%s'\n", name);
		abort();
	}
	
	fprintf(stderr, " exported '%s' (%u bytes)\n", name, rec->buf.sz);
	fclose(f);
}

static void exportRes(const struct PalmRes *res)
{
	uint32_t typ = res->type;
	char name[16];
	FILE *f;
	
	if (!(typ & 0xff000000) || !(typ & 0xff0000) || !(typ & 0xff00) || !(typ & 0xff)) {
		
		fprintf(stderr, "res with type 0x%08x cannot be exported\n", typ);
		abort();
	}
	sprintf(name, "%c%c%c%c%04x.bin", (typ >> 24) & 0xff, (typ >> 16) & 0xff, (typ >> 8) & 0xff, (typ >> 0) & 0xff, res->id);
	f = fopen(name, "wb");
	if (!f) {
		
		fprintf(stderr, "cannot open '%s'\n", name);
		abort();
	}
	
	if (res->buf.sz != fwrite(res->buf.data, 1, res->buf.sz, f)) {
		
		fprintf(stderr, "cannot write '%s'\n", name);
		abort();
	}
	
	fprintf(stderr, " exported '%s' (%u bytes)\n", name, res->buf.sz);
	fclose(f);
}

int main(int argc, char** argv)
{
	const char* self = *argv++;
	struct PalmDb *db;
	uint_fast16_t i;
	
	if (argc != 2 || !(db = parsePrcPdb(argv[0])))
		usage(self);
	
	if (db->isPrc) {
		
		for (i = 0; i < db->numChildren; i++)
			exportRes(&db->res[i]);
	}
	else {
		
		for (i = 0; i < db->numChildren; i++)
			exportRec(&db->rec[i]);
	}
	
	freePrcPdb(db);
	
	return 0;
}
