#ifndef _PARSE_PRC_PDB_H_
#define _PARSE_PRC_PDB_H_

#include <stdbool.h>
#include <stdint.h>

#define PALM_DB_ATTR_RES_DB					0x0001	// is PRC? (else PDB)
#define PALM_DB_ATTR_READONLY				0x0002
#define PALM_DB_ATTR_APP_INFO_DIRTY			0x0004
#define PALM_DB_ATTR_DO_BACKUP				0x0008
#define PALM_DB_ATTR_OK_TO_UPDATE			0x0010
#define PALM_DB_ATTR_RESET_AFTER_INSTALL	0x0020
#define PALM_DB_ATTR_BEAM_DISALLOWED		0x0040
#define PALM_DB_ATTR_IS_FILE_STREAM			0x0080
#define PALM_DB_ATTR_HIDDED					0x0100
#define PALM_DB_ATTR_LAUNCHABLE_DATA		0x0200
#define PALM_DB_ATTR_RECYCLABLE				0x0400
#define PALM_DB_ATTR_BUNDLE					0x0800
#define PALM_DB_ATTR_OPEN					0x8000



struct Buffer {
	void *data;
	uint32_t sz;
};

struct PalmRes {
	uint32_t type;
	uint16_t id;
	struct Buffer buf;
};

struct PalmRec {
	uint32_t uniq;	//only 24 bits significant
	uint8_t attrs;
	struct Buffer buf;
};

struct PalmDb {
	char					name[33 /* to make sure it is terminated */];
	uint16_t				attributes;
	uint16_t				version;
	uint32_t				creationDate;
	uint32_t				modificationDate;
	uint32_t				lastBackupDate;
	uint32_t				modificationNumber;
	struct Buffer			appInfo;
	struct Buffer			sortInfo;
	uint32_t				type;
	uint32_t				creator;
	uint32_t				uniqueIDSeed;
	
	bool					isPrc;			//set for resource DBs, clear for record DBs
	
	uint32_t				numChildren;	//how many rec/res entries follow
	
	union {
		struct PalmRec		*rec;
		struct PalmRes		*res;
	};
};

struct PalmDb *createPrcPdb(const char *name, uint16_t attr, uint16_t ver, uint32_t datCr, uint32_t datMod, uint32_t datBck, uint32_t modNum, uint32_t type, uint32_t crid, uint32_t uniqDbSeed);
struct PalmDb *appendRes(struct PalmDb *db, uint32_t type, uint16_t id, struct Buffer* buf);
struct PalmDb *appendRec(struct PalmDb *db, uint8_t attr, uint32_t uniqId, struct Buffer* buf);
bool writePrcPdb(const struct PalmDb *db, const char *name);

struct PalmDb *parsePrcPdb(const char *path);
void freePrcPdb(struct PalmDb *fil);

#endif
