#!/bin/bash

function check4cc {
	LEN=$(echo -n "$1" | wc | awk '{print $3}')
	
	if [ "$LEN" -ne 4 ] ; then
	    echo "$2($1) looks invalid ($LEN chars long)" >&2
		exit 1
	fi
}

function fourCCtoHex {
	echo -n "$1" | od -tx1 | grep "0000000" | awk '{print "0x"$2$3$4$5}'
}

function parsedesc {

	LINES=( $( sed 's/#.*//g' < $1 | sed 's/[[:space:]]*//g' | awk NF ) )
	
	if [ "${#LINES[@]}" -lt 10 ] ; then
	    echo "module descriptor missing data (too short)" >&2
		exit 1
	fi
	
	MAIN_ENTRY=${LINES[0]}
	CRID=${LINES[1]}
	TYPE=${LINES[2]}
	MODID=${LINES[3]}
	RES_CODE=${LINES[4]}
	RES_DATA=${LINES[5]}
	RES_INFO=${LINES[6]}
	RES_IDX=${LINES[7]}
	MOD_VER=${LINES[8]}
	MOD_FLAGS=${LINES[9]}
	ENTRIES=(${LINES[@]:10})
	NUM_ENTRIES=${#ENTRIES[@]}
	
	check4cc "$CRID" "db creator"
	check4cc "$TYPE" "db type"
	check4cc "$RES_CODE" "code res type"
	check4cc "$RES_DATA" "data res type"
	check4cc "$RES_INFO" "info res type"
	
	CRID_V=$(fourCCtoHex $CRID)
	TYPE_V=$(fourCCtoHex $TYPE)
	RES_CODE_V=$(fourCCtoHex $RES_CODE)
	RES_DATA_V=$(fourCCtoHex $RES_DATA)
	RES_INFO_V=$(fourCCtoHex $RES_INFO)
}

function commonentry {
	
	if [ "$1" = "v6m" ]
	then
		echo "Emitting for ARMv6M" >&2
		NEED_TRAMPOLINES=yes
		INSTRSET="basic"
	elif [ "$1" = "v7m" ]
	then
		echo "Emitting for ARMv7M" >&2
		INSTRSET="full"
	elif [ "$1" = "v8m-base" ]
	then
		echo "Emitting for ARMv8M Base" >&2
		INSTRSET="basic_plus"
	elif [ "$1" = "v8m" ]
	then
		echo "Emitting for ARMv8M+Extension" >&2
		INSTRSET="full"
	elif [ "$1" = "v4" ]
	then
		echo "Emitting for ARMv4T+" >&2
		INSTRSET="v4"
	else
		echo "Unknown architecture requested '$1'" >&2
		exit 1
	fi
		
	parsedesc $2
	
	echo "Library info:" >&2
	echo "	Main Entry:     $MAIN_ENTRY" >&2
	echo "	Num Entries:    $NUM_ENTRIES" >&2
	echo "	ModuleId:       $MODID" >&2
	echo "	Type:           $TYPE ($TYPE_V)" >&2
	echo "	Creator:        $CRID ($CRID_V)" >&2
	echo "	Module Code:    {$RES_CODE($RES_CODE_V),$RES_DATA($RES_DATA_V),$RES_INFO($RES_INFO_V)} @ $RES_IDX" >&2
	echo "	Module Ver:     $MOD_VER" >&2
	echo "	Module Flags:   $MOD_FLAGS" >&2
}