#!/bin/bash

DIR="${BASH_SOURCE%/*}"
if [[ ! -d "$DIR" ]]; then DIR="$PWD"; fi
. "$DIR/util.sh"

if [ "$#" -ne 2 ] ; then
    echo "Illegal number of parameters" >&2
	exit 1
fi

NEED_TRAMPOLINES=no

commonentry $1 $2

echo ".syntax unified"

echo ".macro entrypt name"
if [ "$NEED_TRAMPOLINES" = "yes" ]
then
	echo "	B tramp_\name"
	echo "	nop"
	
elif [ "$INSTRSET" = "v4" ]
then
	echo "	B \name"
else
	echo "	B.W \name"
fi
echo ".endm"

if [ "$NEED_TRAMPOLINES" = "yes" ]
then
	echo ".macro tramp name"
	echo "tramp_\name:"
	echo "	push {r0, lr}"
	echo "	ldr r0, L_loc_\name"
	echo "  add r0, pc"
	echo "	str r0, [sp, #4]"
	echo "L_loc_ofst_\name:"
	echo "	pop {r0, pc}"
	echo ".endm"
	
	echo ".macro tramp_loc name"
	echo "L_loc_\name:"
	echo "  .word \name - L_loc_ofst_\name"
	echo ".endm"
fi

echo ".section .text.vectors"
echo ".func vecs"
echo ".globl vecs"
echo "vecs:"
echo "	entrypt $MAIN_ENTRY"
printf "	.word  %-16s //exported funcs offset\n" "0x24"
printf "	.word  %-16s //module id\n" "$MODID"
printf "	.word  %-16s //version\n" "$MOD_VER"
printf "	.word  %-16s //num exported funcs\n" "$NUM_ENTRIES"
printf "	.word  %-16s //db type ($TYPE)\n" "$TYPE_V"
printf "	.word  %-16s //db creator ($CRID)\n" "$CRID_V"
printf "	.word  %-16s //res type ($RES_CODE)\n" "$RES_CODE_V"
printf "	.hword %-16s //res id\n" "$RES_IDX"
printf "	.hword %-16s //flags\n" "$MOD_FLAGS"

for entrypt in "${ENTRIES[@]}"; do
    echo "	entrypt impl_$entrypt"
done

if [ "$NEED_TRAMPOLINES" = "yes" ]
then
	echo "	tramp $MAIN_ENTRY"
	for entrypt in "${ENTRIES[@]}"; do
	    echo "	tramp impl_$entrypt"
	done
	echo "	.balign 4"
	echo "	tramp_loc $MAIN_ENTRY"
	for entrypt in "${ENTRIES[@]}"; do
	    echo "	tramp_loc impl_$entrypt"
	done
fi

echo ".endfunc"