#define _ASSEMBLY
#define MY_LIB_ID 0x9F4
#define LIB_SLOT_IN_GLOBALS 0x10
.syntax unified
.globl SysLinkerStub  //required to exist
.type LinkerStubCall_v4, %function
.globl LinkerStubCall_v4
.weak LinkerStubCall_v4
.section .text.LinkerStubCall_v4
.balign 4 //life is easier when aligned to a 4-byte-boundary :)
.func
LinkerStubCall_v4:
	STMFD           SP!, {R0-R3,LR}
	ADR             R1, 1f
1:
	STMFD           SP!, {PC}
	LDMFD           SP!, {R2}
	SUB             R2, R2, R1
	ADD             R2, R2, #0x14
	LDR             R1, [SP,#0x18]
	SUB             R1, R1, R2
	STR             R1, [SP,#0x18]
	LDR             R0, [R1,#8]
	MOV             R3, #0x1000
	SUB             R3, R3, #1
	AND             R0, R0, R3
	LDR             R2, [R9]
	LDR             R2, [R2, #0 + MY_LIB_ID]
	ADD             R2, R2, R0
	LDR             R0, [R1,#4]
	AND             R1, R0, R3
	MOV             R1, R1,LSR#2
	LDR             R0, [SP,#0x14]
	BL              SysLinkerStub
	LDMFD           SP!, {R0-R3,LR}
	LDMFD           SP!, {R12}
	LDMFD           SP!, {R12}
	MOV             PC, R12
.endfunc
.type Llib_load_stub, %function
.section .text.Llib_load_stub
.balign 4 //life is easier when aligned to a 4-byte-boundary :)
.func
Llib_load_stub:
	ADR    R12, 1f
	STMFD  SP!, {R12}
	B      LinkerStubCall_v4
	.balign 4 // the data needs to be word-aligned
1:
	.word 0x6c696272 // type (libr)
	.word 0x7374444d // creator (stDM)
	.word 1
	.word 12
	.word 0x616d6464 // res type for data (amdd)
	.word 0x616d6469 // res type for info (amdi)
	.word 0x616d6463 // res type for code (amdc)
	.hword 0 // res id for data
	.hword 0 // res id for info
	.hword 0 // res id for code
	.hword 0 // reserved
.endfunc
.macro libentry name idx
	.type \name, %function
	.globl \name
	.section .text.\name
	.balign 4 //life is easier when aligned to a 4-byte-boundary :)
	.func
	\name:
		ldr   r12, [r9]
		ldr   r12, [r12, #0 + MY_LIB_ID]
		ldr   r12, [r12, #0 + LIB_SLOT_IN_GLOBALS]
		cmp   r12, #0
		addne pc,  r12, #4 * \idx
		stmfd sp!, {pc}
		b     Llib_load_stub
	.endfunc
.endm
libentry DmaLibGetInfo 0
libentry DmaLibStreamReserve 1
libentry DmaLibStreamRelease 2
libentry DmaLibStreamSetIrqHandler 3
libentry DmaLibStreamSetIrqState 4
libentry DmaLibStreamConfigure 5
libentry DmaLibStreamSetEnabled 6
libentry DmaLibStreamSetPeriphAddr 7
libentry DmaLibStreamSetMemAddr 8
libentry DmaLibStreamGetItemsLeftToTransfer 9
libentry DmaLibStreamGetCurrentTargetBuffer 10
libentry DmaLibStreamGetEnabled 11
