#include "sdUtil.h"


uint_fast8_t sdPrvR1toSpiR1(uint32_t r1)
{
	//masks that, if matched, with sd's r1 set the bit in spi r1
	static const uint32_t masks[] = {
		0x00000000,
		0x00002000,
		0x00400000,
		0x00800000,
		0x10000000,
		0x60000000,
		0x8e000000,
		0x01398008,
	};
	uint_fast8_t ret = 0, i;
	
	for (i = 0; i < 8; i++) {
		
		if (r1 & masks[i])
			ret |= 1 << i;
	}
	
	switch ((r1 >> 9) & 0x0f) {
		case 0:
		case 8 ... 15:		//idle, disabled, undefined state sall reported as "idle"
			ret |= 0x01;
			break;
			
		case 1 ... 7:
			break;
		
		default:
			__builtin_unreachable();
	}
	
	return ret;
}