/*
	(c) 2021 Dmitry Grinberg   https://dmitry.gr
	Non-commercial use only OR licensing@dmitry.gr
*/

#ifndef _SD_H_
#define _SD_H_

#include <stdbool.h>
#include <stdint.h>

#define SD_BLOCK_SIZE		512

struct SD;

union SdFlags {
	struct {
		uint8_t inited			: 1;
		uint8_t v2				: 1;
		uint8_t HC				: 1;
		uint8_t SD				: 1;
		uint8_t RO				: 1;
		uint8_t cmd23supported	: 1;
		uint8_t hasDiscard		: 1;
		uint8_t sdioIface		: 1;
	};
	uint8_t value;
};

#define STRUCT_SD_SIZE			16			//in words


bool sdCardInit(struct SD *sd, uint8_t buf[static 64]);
uint32_t sdGetNumSecs(struct SD *sd);

bool sdSecRead(struct SD *sd, uint32_t sec, uint8_t *dst);
bool sdSecWrite(struct SD *sd, uint32_t sec, const uint8_t *src);

bool sdReadStart(struct SD *sd, uint32_t sec, uint32_t numSec);	//if numSec is nonzero, card will be advised to expect that many blocks
bool sdReadNext(struct SD *sd, uint8_t *dst);
bool sdReadStop(struct SD *sd);

bool sdWriteStart(struct SD *sd, uint32_t sec, uint32_t numSec);	//if numSec is nonzero, card will be advised to expect that many blocks
bool sdWriteNext(struct SD *sd, const uint8_t *src);
bool sdWriteStop(struct SD *sd);

void sdGetInfo(struct SD *sd, uint8_t *midP, uint16_t *oidP, uint32_t *snumP);
uint8_t sdGetFlags(struct SD *sd);

bool sdTrim(struct SD *sd, uint32_t firstBlock, uint32_t numBlocks);

void sdReportLastError(struct SD *sd);

//these are basically forwarders to SdHw
uint32_t sdPrvGetMaxSectorsAtOnce(struct SD *sd);
bool sdIsCardLockSwitchOn(struct SD *sd);
bool sdIsCardInserted(struct SD *sd);
void sdCardPower(struct SD *sd, bool on);
void sdShutdown(struct SD *sd);
void sdSleep(struct SD *sd);
void sdWake(struct SD *sd);



#endif
