#ifndef _NAND_H_
#define _NAND_H_

#include <stdbool.h>
#include <stdint.h>
#include "../LibFTL/nand.h"

void nandFillSpec(struct NandSpec *spec);

bool nandInit(void);
void nandSleep(void);
void nandWake(void);
void nandDeinit(void);

bool nandBlockErase(uint32_t firstPageNum);

int_fast8_t nandPageReadPartial(uint32_t pageNum, void *data, uint32_t ofst, uint32_t len, bool withEcc);
bool nandPageWritePartial(uint32_t pageNum, const void *data, uint32_t ofst, uint32_t len, bool withEcc);		//aligned data please!

bool nandReadUid(uint8_t uid[static 16]);

#endif
