#ifndef _SBAR_H_
#define _SBAR_H_


#include <stdbool.h>
#include "palmosInternal.h"


#define SBAR_STATE_UP				0	//yes dia yes sbar
#define SBAR_STATE_JUST_SBAR		1	//no dia, yes sbar
#define SBAR_STATE_FULLSCREEN		2	//no dia no sbar
#define SBAR_STATE_NUMBER			4	//number of states

#define SBAR_NOTIF_SPACING_H		1
#define SBAR_NOTIF_SPACING_V		0


bool sbarPrvInit(bool isOS50, bool isGarnet);			//init sbar. return true to continue install. return false to cancel

void sbarPrvNotifTapped(void* notifHandle);



//PINS 1.0:
uint16_t sbarFrmGetDIAPolicyAttr(struct PalmForm* form);
Err sbarFrmSetDIAPolicyAttr(struct PalmForm* form, uint16_t policy);
uint16_t sbarPINGetInputAreaState(void);
uint16_t sbarPINGetInputTriggerState(void);
Err sbarPINSetInputAreaState(uint16_t state);
Err sbarPINSetInputTriggerState(uint16_t state);
Err sbarWinSetConstraintsSize(WinHandle winHandle, Coord minH, Coord prefH, Coord maxH, Coord minW, Coord prefW, Coord maxW);


//PINS 1.1:

Err sbarStatGetAttribute(uint16_t selector, uint32_t *dataP, bool fromArm);
Err sbarStatShow(void);
Err sbarStatHide(void);
uint16_t sbarSysGetOrientation(void);
Err sbarSysSetOrientation(uint16_t orientation);
uint16_t sbarSysGetOrientationTriggerState(void);
Err sbarSysSetOrientationTriggerState(uint16_t state);
void sbarFrmPrvSetActiveFormPINAttributes(uint32_t whichToAffect, bool useCustom /* use force open */);
void sbarFrmPrvRedrawDisplay(const struct RectangleType *area);

//PINS 2.0:

bool sbarPINAltInputSystemEnabled(void);
const char* sbarPINGetCurrentPinletName(void);
Err sbarPINSwitchToPinlet(const char *pinletName, uint16_t initialInputMode);
uint16_t sbarPINCountPinlets(void);
Err sbarPINGetPinletInfo(uint16_t pinletIndex, uint16_t selector, uint32_t *infoP);
void sbarPINSetInputMode(uint16_t inputModeToSetForCurPinlet);
uint16_t sbarPINGetInputMode(void);
void sbarPINClearPinletState(void);
void sbarPINShowReferenceDialog(void);





#endif
