#ifndef _PATCHING_H_
#define _PATCHING_H_

#include <stdint.h>


struct PalmOsFuncPatch {
	void* func;
	uint16_t entryPt	: 12;
	uint16_t moduleId	:  4;
	int16_t oldTrapOfst;	//from start of globals, in words, neg means none
};

#define DEF_PATCH(_name, _mod, _ofst, _oldTrapOfstInBytes) 												\
	static const __attribute__((used, section(".patches.m"))) struct PalmOsFuncPatch _PI_ ## _name = {	\
		.func = &_name,																					\
		.entryPt = ((uint32_t)(_ofst)) / 4,																\
		.moduleId = _mod,																				\
		.oldTrapOfst = (_oldTrapOfstInBytes) >> 2, /* -1 => -1; +x -> x / 4 */							\
	}
#define DEF_PATCH_FULL(_name, _mod, _ofst)	DEF_PATCH(_name, _mod, _ofst, -1)


#define DEF_DAL_PATCH(_name, _ofst)			DEF_PATCH_FULL(_name, 0, _ofst)
#define DEF_BOOT_PATCH(_name, _ofst)		DEF_PATCH_FULL(_name, 1, _ofst)
#define DEF_UI_PATCH(_name, _ofst)			DEF_PATCH_FULL(_name, 2, _ofst)

#define DEF_DAL_PATCH_PARTIAL(_name, _ofst)		DEF_PATCH(_name, 0, _ofst, offsetof(struct Globals, ot_ ## _name))
#define DEF_BOOT_PATCH_PARTIAL(_name, _ofst)	DEF_PATCH(_name, 1, _ofst, offsetof(struct Globals, ot_ ## _name))
#define DEF_UI_PATCH_PARTIAL(_name, _ofst)		DEF_PATCH(_name, 2, _ofst, offsetof(struct Globals, ot_ ## _name))


///do it all
void sbarPrvInstallPatches(void);


#endif
