#ifndef _PACE_H_
#define _PACE_H_

#include <stdint.h>
#include "palmosInternal.h"

typedef struct EmulState {
	uint32_t rfu;
	
	uint32_t d[8];
	uint32_t a[8];	//a[7] is stack
	uint32_t pc;
	
	//more scary things here
	
} *EmulStateRef;


typedef void (*PaceTrapHandler)(EmulStateRef ref);

uint16_t PceReadInt8From68KStack(EmulStateRef ref, int32_t offset);
uint16_t PceReadInt16From68KStack(EmulStateRef ref, int32_t offset);
uint32_t PceReadInt32From68KStack(EmulStateRef ref, int32_t offset);
uint32_t PceReadInt32From68KMemory(EmulStateRef ref, uint32_t* val, int32_t offset);
void *PceReadPtrFrom68KStack(EmulStateRef emulState, int32_t offset);
void PceWriteInt32To68KMemory(EmulStateRef ref, uint32_t* val, int32_t offset, uint32_t newVal);
void PceWriteInt16To68KMemory(EmulStateRef ref, uint16_t* val, int32_t offset, uint16_t newVal);
void PceSet68KInt8ReturnResult(EmulStateRef ref, int8_t val);
void PceSet68KInt16ReturnResult(EmulStateRef ref, uint16_t val);
void PceSet68KPtrReturnResult(EmulStateRef ref, void* ptr);
void PceSet68KInt32ReturnResult(EmulStateRef ref, uint32_t val);
int8_t PceGet68KInt8ReturnResult(EmulStateRef ref);
EmulStateRef PceGetCurrentAppEmulState(void);
EmulStateRef PceGetSystemEmulState(void);
void PceWriteInt32To68KStack(EmulStateRef ref, int32_t offset, uint32_t value);
Err PceCall68KRoutine(EmulStateRef ref, void *procP, uint32_t argsSize);
Err PceWriteStructureTo68KMemory(EmulStateRef ref, void* srcStruct, void* dstStruct, int8_t* format);
Err PceReadStructureFrom68KMemory(EmulStateRef ref, void* dstStruct, void* srcStruct, int8_t* format);
Err PceSet68KTrapHandler(EmulStateRef ref, uint32_t trap, PaceTrapHandler handler);
Err PceGet68KTrapHandler(EmulStateRef ref, uint32_t trap, PaceTrapHandler *handlerP);



#endif