#include <string.h>
#include "zodiac.h"
#include "printf.h"
#include "boot.h"
#include "kal.h"


#define VIB_ERROR_INVAL_REQUEST		0x0016

#define VIB_DEVICE_NAME		"vibrator0"


static bool mVibFakeOn = false;	//continuous action neevr ends. time-limited action ends instantly


static bool zodVibDevIsActive(void)
{
	return mVibFakeOn;
}

static Err zodVibDevControl(struct TwDevice *handle, int32_t cmd, void* buf, int32_t lenP)
{
	switch (cmd) {
		
		case CREATE_4CC('s','t','r','t'):
		case CREATE_4CC('f','a','s','t'):
		case CREATE_4CC('m','e','d','i'):
		case CREATE_4CC('s','l','o','w'):
		case CREATE_4CC('r','e','p','t'):
			mVibFakeOn = true;
			break;
		
		case CREATE_4CC('s','t','o','p'):
		case CREATE_4CC('p','l','a','y'):	//time-limited actions end instantly for us...
			mVibFakeOn = false;
			break;
		
		default:
			return VIB_ERROR_INVAL_REQUEST;
	}
	
	return errNone;
}

static Err zodVibDevPropGet(struct TwDevice *handle, int32_t prop, void* buf, int32_t *lenP)
{
	uint_fast8_t ret;
	
	if (!buf || !lenP || *lenP < 1)
		return VIB_ERROR_INVAL_REQUEST;
	
	switch (prop) {
		case CREATE_4CC('a','n','l','g'):
			ret = 0;								//vibrator is digital, no analog control
			break;
		
		case CREATE_4CC('d','u','r','a'):
			ret = 0xff;								//max duration is 2550 msec
			break;
		
		case CREATE_4CC('p','l','n','g'):
			ret = zodVibDevIsActive() ? 1 : 0;		//currently playing?
			break;
		
		case CREATE_4CC('s','p','e','d'):
			ret = 0xff;								//max speed is 255
			break;
		
		default:
			return VIB_ERROR_INVAL_REQUEST;
	}
	
	*(uint8_t*)buf = ret;
	*lenP = sizeof(uint8_t);
	return errNone;
}

static Err zodVibDevClose(struct TwDevice *handle)
{
	return errNone;
}

static Err zodVibDevInit(struct TwDevice *handle, const char *name, const char *mode)
{
	if (!name || !mode || strcmp(VIB_DEVICE_NAME, name) || strcmp(mode, "w"))
		return sysErrParamErr;
	
	handle->initF = &zodVibDevInit;
	handle->closeF = &zodVibDevClose;
	handle->getPropF = &zodVibDevPropGet;
	handle->controlF = &zodVibDevControl;
	
	//one time hw init might be done here
	
	return errNone;
}

void zodVibratorInit(void)
{
	if (errNone != impl_TwDeviceRegister(VIB_DEVICE_NAME, zodVibDevInit, NULL))
		fatal("Failed ot init vibrator\n");
}
