#include <stdbool.h>
#include <stdint.h>
#include "zodiac.h"
#include "printf.h"
#include "boot.h"
#include "dal.h"


static LocalID mCurAppDb;
static uint32_t mApiCalledfromAddr;

static void twPrvRotateFailReason(uint32_t *failReasonP)
{
	if (failReasonP)
		failReasonP[0] = (failReasonP[0] >> 19) | (failReasonP[0] << 13);
}

bool DALEXPORT impl_TwSetCurRunningDb(LocalID db)
{
	LocalID ret = mCurAppDb;
	
	logt("%s\n", __func__);
	
	mCurAppDb = db;
	return ret;
}

bool DALEXPORT impl_TwSecVerifyDatabase(LocalID dbH, UInt32 *failReasonP, UInt32 failureAction)
{
	logt("%s\n", __func__);
	
	twPrvRotateFailReason(failReasonP);
	
	return true;
}

bool DALEXPORT TwSecVerifyCurrentAppEx(uint32_t calledFromAddr, uint32_t *failReasonP, uint32_t failAction)
{
	logt("%s(0x%08x, ...)\n", __func__, calledFromAddr);
	
	twPrvRotateFailReason(failReasonP);
	
	return true;
}

uint32_t DALEXPORT impl_TwSetApiCalledFromAddr(uint32_t addr)
{
	uint32_t ret = mApiCalledfromAddr;
	mApiCalledfromAddr = addr;
	
	return ret;
}

uint32_t DALEXPORT impl_TwGetApiCalledFromAddr(void)
{
	return mApiCalledfromAddr;
}

bool DALEXPORT impl_TwSecDoesAppHaveSigResource(LocalID dbLID)
{
	bool hasSig = false;
	MemHandle mh;
	DmOpenRef db;
	uint32_t i;
	
	logt("%s\n", __func__);
	
	db = DmOpenDatabase(dbLID, dmModeReadOnly);
	if (!db)
		return true;	//yes this is correct
	
	for (i = 2; i < 5 && !hasSig; i += 2) {
		
		mh = DmGet1Resource(CREATE_4CC('T','S','I','G'), i);
		if (!mh)
			continue;
		hasSig = true;
		DmReleaseResource(mh);
	}

	DmCloseDatabase(db);
	
	return hasSig;
}

bool DALEXPORT impl_TwSystemSelfVerifyNow(uint32_t flags)
{
	logt("%s(0x%08x)\n", __func__, flags);
	
	//only one flag is defined: bottom bit. if set we're expected to reset if the check fails
	
	return true;	//yup, we're secure...
}

bool DALEXPORT impl_TwSecVerifyCurrentAppEx(uint32_t calledFromAddr, uint32_t *failReasonP, uint32_t failAction)
{
	logt("%s(0x%08x, ...)\n", __func__, calledFromAddr);
	
	twPrvRotateFailReason(failReasonP);
	
	return true;
}