#ifndef _PRINTF_H_
#define _PRINTF_H_

#include <stdbool.h>
#include <unistd.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>


void prPutchar(char chr);
void pr(const char* fmtStr, ...);
void vpr(const char* fmtStr, va_list vl);

uint32_t vspr(char* dst, const char* fmtStr, va_list vl);
uint32_t spr(char* dst, const char* fmtStr, ...);

#define LOG_VERY_SPAMMY				0
#define LOG_JIT_TRACE				0
#define LOG_SPAMMY					0
#define LOG_TRACE					0
#define LOG_DEBUG					0
#define LOG_INFO					1
#define LOG_WARNING					1
#define LOG_ERROR					1
#define HAL_TRACE_ENABLED			1

#define PRINTF_MAY_DISABLE_IRQS		0		//set for less messy printing. clear to not disable irqs for arbitrarily long...

#define logvst(...)	do { if(LOG_VERY_SPAMMY)	pr("T " __VA_ARGS__); } while(0)		//very spammy trace
#define logst(...)	do { if(LOG_SPAMMY)			pr("T " __VA_ARGS__); } while(0)		//spammy trace
#define logjt(...)	do { if(LOG_JIT_TRACE)		pr("J " __VA_ARGS__); } while(0)		//jit trace
#define logt(...)	do { if(LOG_TRACE)			pr("T " __VA_ARGS__); } while(0)
#define logd(...)	do { if(LOG_DEBUG)			pr("D " __VA_ARGS__); } while(0)
#define logi(...)	do { if(LOG_INFO)			pr("I " __VA_ARGS__); } while(0)
#define logw(...)	do { if(LOG_WARNING)		pr("W " __VA_ARGS__); } while(0)
#define loge(...)	do { if(LOG_ERROR)			pr("E " __VA_ARGS__); } while(0)
#define fatal(...)	do { pr("F " __VA_ARGS__); do { asm volatile("bkpt"); } while(1); __builtin_unreachable(); } while(0)



#endif

