#ifndef _MEMORY_HEAP_H_
#define _MEMORY_HEAP_H_

#include <stdbool.h>
#include <stdint.h>
#include <memmap.h>

struct MemoryHeap;

struct MemoryHeap *memoryheapInit(uintptr_t base, uintptr_t size);
void* memoryheapAlloc(struct MemoryHeap *heap, uint32_t sz);
void memoryheapFree(struct MemoryHeap *heap, void* ptr);
bool memoryheapIsThisInThere(struct MemoryHeap *heap, const void* ptr);
uint32_t memoryheapGetChunkActualSize(struct MemoryHeap *heap, const void* ptr);	//returns size of chunk's space. will be >= what was allocated


#endif
